/*
 * Decompiled with CFR 0.152.
 */
package org.k33nteam.jade.solver;

import java.util.HashMap;
import java.util.Map;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.internal.JimpleLocal;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class LocalMustPropagationAnalysis
extends ForwardFlowAnalysis<Unit, Map<Local, Constant>> {
    private static final Local RETURN_LOCAL = new JimpleLocal("@return", null);
    DirectedGraph<Unit> graph;

    public LocalMustPropagationAnalysis(DirectedGraph<Unit> graph) {
        super(graph);
        this.graph = graph;
        this.doAnalysis();
    }

    private void assign(Local lhs, Value rhs, Map<Local, Constant> input2, Map<Local, Constant> output) {
        if (rhs instanceof CastExpr) {
            rhs = ((CastExpr)rhs).getOp();
        }
        if (rhs instanceof Constant) {
            output.put(lhs, (Constant)rhs);
        } else if (rhs instanceof Local) {
            if (input2.containsKey(rhs)) {
                output.put(lhs, input2.get(rhs));
            }
        } else {
            output.put(lhs, null);
        }
    }

    @Override
    protected void flowThrough(Map<Local, Constant> inValue, Unit unit, Map<Local, Constant> outValue) {
        this.copy(inValue, outValue);
        if (unit instanceof AssignStmt) {
            Value lhsOp = ((AssignStmt)unit).getLeftOp();
            Value rhsOp = ((AssignStmt)unit).getRightOp();
            if (lhsOp instanceof Local) {
                this.assign((Local)lhsOp, rhsOp, inValue, outValue);
            }
        } else if (unit instanceof ReturnStmt) {
            Value rhsOp = ((ReturnStmt)unit).getOp();
            this.assign(RETURN_LOCAL, rhsOp, inValue, outValue);
        }
    }

    @Override
    protected void merge(Map<Local, Constant> op1, Map<Local, Constant> op2, Map<Local, Constant> out) {
        this.copy(op1, out);
        for (Local x : op2.keySet()) {
            if (op1.containsKey(x)) {
                Constant c1 = op1.get(x);
                Constant c2 = op2.get(x);
                if (c1 == null || c1.equals(c2)) continue;
                out.put(x, null);
                continue;
            }
            out.put(x, op2.get(x));
        }
    }

    @Override
    protected void copy(Map<Local, Constant> source, Map<Local, Constant> dest) {
        dest.clear();
        dest.putAll(source);
    }

    @Override
    protected Map<Local, Constant> entryInitialFlow() {
        return new HashMap<Local, Constant>();
    }

    @Override
    protected Map<Local, Constant> newInitialFlow() {
        return new HashMap<Local, Constant>();
    }

    public Constant getResultAtStmt(Local local, Stmt stmt) {
        return (Constant)((Map)this.getFlowBefore(stmt)).get(local);
    }
}

