/*
 * Decompiled with CFR 0.152.
 */
package org.k33nteam.jade.solver;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import soot.PatchingChain;
import soot.Timers;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.BranchedFlowAnalysis;

public abstract class ForwardMyBranchedFlowAnalysis<A>
extends BranchedFlowAnalysis<Unit, A> {
    public ForwardMyBranchedFlowAnalysis(UnitGraph graph) {
        super(graph);
    }

    @Override
    protected boolean isForward() {
        return true;
    }

    private void accumulateAfterFlowSets(Unit s2, A[] flowRepositories, List<Object> previousAfterFlows) {
        int repCount = 0;
        previousAfterFlows.clear();
        if (s2.fallsThrough()) {
            this.copy(((List)this.unitToAfterFallFlow.get(s2)).get(0), flowRepositories[repCount]);
            previousAfterFlows.add(flowRepositories[repCount++]);
        }
        if (s2.branches()) {
            List l = (List)this.unitToAfterBranchFlow.get(s2);
            for (Object fs : l) {
                this.copy(fs, flowRepositories[repCount]);
                previousAfterFlows.add(flowRepositories[repCount++]);
            }
        }
    }

    @Override
    protected void doAnalysis() {
        int i;
        final HashMap<Unit, Integer> numbers = new HashMap<Unit, Integer>();
        List orderedUnits = new PseudoTopologicalOrderer().newList(this.graph, false);
        int i2 = 1;
        for (Unit u : orderedUnits) {
            numbers.put(u, new Integer(i2));
            ++i2;
        }
        TreeSet<Unit> changedUnits = new TreeSet<Unit>(new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer i1 = (Integer)numbers.get(o1);
                Integer i2 = (Integer)numbers.get(o2);
                return i1 - i2;
            }
        });
        HashMap unitToIncomingFlowSets = new HashMap(this.graph.size() * 2 + 1, 0.7f);
        List heads2 = this.graph.getHeads();
        int numNodes = this.graph.size();
        int numComputations = 0;
        int maxBranchSize = 0;
        for (Unit s2 : this.graph) {
            unitToIncomingFlowSets.put(s2, new ArrayList());
        }
        PatchingChain<Unit> sl = ((UnitGraph)this.graph).getBody().getUnits();
        for (Unit s3 : this.graph) {
            changedUnits.add(s3);
            this.unitToBeforeFlow.put(s3, this.newInitialFlow());
            if (s3.fallsThrough()) {
                ArrayList fl = new ArrayList();
                fl.add(this.newInitialFlow());
                this.unitToAfterFallFlow.put(s3, fl);
                Unit succ = sl.getSuccOf(s3);
                if (succ != null) {
                    List l = (List)unitToIncomingFlowSets.get(sl.getSuccOf(s3));
                    l.addAll(fl);
                }
            } else {
                this.unitToAfterFallFlow.put(s3, new ArrayList());
            }
            if (s3.branches()) {
                ArrayList l = new ArrayList();
                Iterator<UnitBox> boxIt = s3.getUnitBoxes().iterator();
                while (boxIt.hasNext()) {
                    Object f = this.newInitialFlow();
                    l.add(f);
                    Unit ss = boxIt.next().getUnit();
                    List incList = (List)unitToIncomingFlowSets.get(ss);
                    incList.add(f);
                }
                this.unitToAfterBranchFlow.put(s3, l);
            } else {
                this.unitToAfterBranchFlow.put(s3, new ArrayList());
            }
            if (s3.getUnitBoxes().size() <= maxBranchSize) continue;
            maxBranchSize = s3.getUnitBoxes().size();
        }
        for (Unit s2 : heads2) {
            this.unitToBeforeFlow.put(s2, this.entryInitialFlow());
        }
        if (this.treatTrapHandlersAsEntries()) {
            for (Trap trap : ((UnitGraph)this.graph).getBody().getTraps()) {
                Unit handler = trap.getHandlerUnit();
                this.unitToBeforeFlow.put(handler, this.entryInitialFlow());
            }
        }
        Object[] flowRepositories = new Object[maxBranchSize + 1];
        Object[] previousFlowRepositories = new Object[maxBranchSize + 1];
        for (i = 0; i < maxBranchSize + 1; ++i) {
            flowRepositories[i] = this.newInitialFlow();
        }
        for (i = 0; i < maxBranchSize + 1; ++i) {
            previousFlowRepositories[i] = this.newInitialFlow();
        }
        ArrayList<Object> previousAfterFlows = new ArrayList<Object>();
        ArrayList<Object> afterFlows = new ArrayList<Object>();
        while (!changedUnits.isEmpty()) {
            Unit s4 = (Unit)changedUnits.first();
            changedUnits.remove(s4);
            boolean isHead = heads2.contains(s4);
            this.accumulateAfterFlowSets(s4, previousFlowRepositories, previousAfterFlows);
            List preds = (List)unitToIncomingFlowSets.get(s4);
            Object beforeFlow = this.unitToBeforeFlow.get(s4);
            if (preds.size() == 1) {
                this.copy(preds.get(0), beforeFlow);
            } else if (preds.size() != 0) {
                Iterator predIt = preds.iterator();
                this.copy(predIt.next(), beforeFlow);
                while (predIt.hasNext()) {
                    Object otherBranchFlow = predIt.next();
                    Object newBeforeFlow = this.newInitialFlow();
                    this.merge(s4, beforeFlow, otherBranchFlow, newBeforeFlow);
                    this.copy(newBeforeFlow, beforeFlow);
                }
            }
            if (isHead && preds.size() != 0) {
                this.mergeInto(s4, beforeFlow, this.entryInitialFlow());
            }
            List afterFallFlow = (List)this.unitToAfterFallFlow.get(s4);
            List afterBranchFlow = (List)this.unitToAfterBranchFlow.get(s4);
            this.flowThrough(beforeFlow, s4, afterFallFlow, afterBranchFlow);
            ++numComputations;
            this.accumulateAfterFlowSets(s4, flowRepositories, afterFlows);
            if (!afterFlows.equals(previousAfterFlows)) {
                for (Unit succ : this.graph.getSuccsOf(s4)) {
                    changedUnits.add(succ);
                }
            }
            if (numComputations <= 200) continue;
            break;
        }
        Timers.v().totalFlowNodes += numNodes;
        Timers.v().totalFlowComputations += numComputations;
    }
}

