/*
 * Decompiled with CFR 0.152.
 */
package org.k33nteam;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.k33nteam.JadeCfg;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.dava.internal.javaRep.DIntConstant;
import soot.jimple.DefinitionStmt;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.VirtualInvokeExpr;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.Pair;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;

public class ConnectCallbackTransformer
extends BodyTransformer {
    private final Set<String> androidCallbacks = this.loadAndroidCallbacks();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> loadAndroidCallbacks() throws IOException {
        HashSet<String> androidCallbacks = new HashSet<String>();
        try (BufferedReader rdr = null;){
            String line;
            String fileName = JadeCfg.getCallback_file();
            rdr = new BufferedReader(new FileReader(fileName));
            while ((line = rdr.readLine()) != null) {
                if (line.isEmpty()) continue;
                androidCallbacks.add(line);
            }
        }
        return androidCallbacks;
    }

    private Set<SootClass> collectAllInterfaces(SootClass sootClass) {
        HashSet<SootClass> interfaces = new HashSet<SootClass>(sootClass.getInterfaces());
        for (SootClass i : sootClass.getInterfaces()) {
            interfaces.addAll(this.collectAllInterfaces(i));
        }
        return interfaces;
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        SootMethod method = b.getMethod();
        if (method.getDeclaringClass().getName().startsWith("android.") || method.getDeclaringClass().getName().startsWith("java.")) {
            return;
        }
        if (!method.isConcrete()) {
            return;
        }
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(method.retrieveActiveBody());
        SmartLocalDefs smd = new SmartLocalDefs(graph, new SimpleLiveLocals(graph));
        ArrayList<Pair<Pair<Local, Local>, Pair<SootClass, Stmt>>> worklist = new ArrayList<Pair<Pair<Local, Local>, Pair<SootClass, Stmt>>>();
        for (Unit unit : method.retrieveActiveBody().getUnits()) {
            Stmt stmt = (Stmt)unit;
            if (!stmt.containsInvokeExpr() || !(stmt.getInvokeExpr() instanceof InstanceInvokeExpr)) continue;
            InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
            for (int i = 0; i < iinv.getArgCount(); ++i) {
                Value arg = iinv.getArg(i);
                Type argType = iinv.getArg(i).getType();
                Type paramType = iinv.getMethod().getParameterType(i);
                if (!(paramType instanceof RefType) || !(argType instanceof RefType) || !this.androidCallbacks.contains(((RefType)paramType).getSootClass().getName()) || !(arg instanceof Local)) continue;
                for (Unit def : smd.getDefsOfAt((Local)arg, unit)) {
                    assert (def instanceof DefinitionStmt);
                    Type tp = ((DefinitionStmt)def).getRightOp().getType();
                    if (!(tp instanceof RefType)) continue;
                    SootClass callbackClass = ((RefType)tp).getSootClass();
                    if (callbackClass.isInterface()) {
                        for (SootClass impl : Scene.v().getActiveHierarchy().getImplementersOf(callbackClass)) {
                            for (SootClass c : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(impl)) {
                                worklist.add(new Pair<Pair<Local, Local>, Pair<SootClass, Stmt>>(new Pair<Local, Local>((Local)arg, (Local)iinv.getBase()), new Pair<SootClass, Stmt>(c, stmt)));
                            }
                        }
                        continue;
                    }
                    for (SootClass c : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(callbackClass)) {
                        worklist.add(new Pair<Pair<Local, Local>, Pair<SootClass, Stmt>>(new Pair<Local, Local>((Local)arg, (Local)iinv.getBase()), new Pair<SootClass, Stmt>(c, stmt)));
                    }
                }
            }
        }
        for (Pair pair : worklist) {
            SootClass sootClass = (SootClass)((Pair)pair.getO2()).getO1();
            if (sootClass.getName().startsWith("android.") || sootClass.getName().startsWith("java.")) continue;
            for (SootClass i : this.collectAllInterfaces((SootClass)((Pair)pair.getO2()).getO1())) {
                if (!this.androidCallbacks.contains(i.getName())) continue;
                for (SootMethod sm : i.getMethods()) {
                    try {
                        VirtualInvokeExpr invokeExpr;
                        System.out.println("checking sm: " + sm);
                        SootMethod realmethod = this.getMethodFromHierarchyEx((SootClass)((Pair)pair.getO2()).getO1(), sm.getSubSignature());
                        if (realmethod.getParameterCount() == 1) {
                            invokeExpr = Jimple.v().newVirtualInvokeExpr((Local)((Pair)pair.getO1()).getO1(), realmethod.makeRef(), Collections.singletonList(((Pair)pair.getO1()).getO2()));
                        } else if (realmethod.getParameterCount() == 0) {
                            invokeExpr = Jimple.v().newVirtualInvokeExpr((Local)((Pair)pair.getO1()).getO1(), realmethod.makeRef(), Collections.emptyList());
                        } else {
                            ArrayList<Object> args = new ArrayList<Object>();
                            args.add(((Pair)pair.getO1()).getO2());
                            for (int j = 1; j < realmethod.getParameterCount(); ++j) {
                                if (ConnectCallbackTransformer.isSimpleType(realmethod.getParameterType(j).toString())) {
                                    args.add(this.getSimpleDefaultValue(realmethod.getParameterType(j).toString()));
                                    continue;
                                }
                                args.add(NullConstant.v());
                            }
                            invokeExpr = Jimple.v().newVirtualInvokeExpr((Local)((Pair)pair.getO1()).getO1(), realmethod.makeRef(), args);
                        }
                        InvokeStmt stmt = Jimple.v().newInvokeStmt(invokeExpr);
                        b.getUnits().insertAfter(stmt, (Unit)((Pair)pair.getO2()).getO2());
                    }
                    catch (RuntimeException e) {
                        System.err.println("runtimeException - callback method not found?");
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private Type getSimpleTypeFromType(Type type) {
        if (type.toString().equals("java.lang.String")) {
            assert (type instanceof RefType);
            return RefType.v(((RefType)type).getSootClass());
        }
        if (type.toString().equals("void")) {
            return VoidType.v();
        }
        if (type.toString().equals("char")) {
            return CharType.v();
        }
        if (type.toString().equals("byte")) {
            return ByteType.v();
        }
        if (type.toString().equals("short")) {
            return ShortType.v();
        }
        if (type.toString().equals("int")) {
            return IntType.v();
        }
        if (type.toString().equals("float")) {
            return FloatType.v();
        }
        if (type.toString().equals("long")) {
            return LongType.v();
        }
        if (type.toString().equals("double")) {
            return DoubleType.v();
        }
        if (type.toString().equals("boolean")) {
            return BooleanType.v();
        }
        throw new RuntimeException("Unknown simple type: " + type);
    }

    protected static boolean isSimpleType(String t) {
        return t.equals("java.lang.String") || t.equals("void") || t.equals("char") || t.equals("byte") || t.equals("short") || t.equals("int") || t.equals("float") || t.equals("long") || t.equals("double") || t.equals("boolean");
    }

    protected Value getSimpleDefaultValue(String t) {
        if (t.equals("java.lang.String")) {
            return StringConstant.v("");
        }
        if (t.equals("char")) {
            return DIntConstant.v(0, CharType.v());
        }
        if (t.equals("byte")) {
            return DIntConstant.v(0, ByteType.v());
        }
        if (t.equals("short")) {
            return DIntConstant.v(0, ShortType.v());
        }
        if (t.equals("int")) {
            return IntConstant.v(0);
        }
        if (t.equals("float")) {
            return FloatConstant.v(0.0f);
        }
        if (t.equals("long")) {
            return LongConstant.v(0L);
        }
        if (t.equals("double")) {
            return DoubleConstant.v(0.0);
        }
        if (t.equals("boolean")) {
            return DIntConstant.v(0, BooleanType.v());
        }
        return G.v().soot_jimple_NullConstant();
    }

    private SootMethod getMethodFromHierarchyEx(SootClass c, String methodSignature) {
        if (c.declaresMethod(methodSignature)) {
            return c.getMethod(methodSignature);
        }
        if (c.hasSuperclass()) {
            return this.getMethodFromHierarchyEx(c.getSuperclass(), methodSignature);
        }
        throw new RuntimeException("Could not find method");
    }
}

