/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.writer.AnnotationSection;
import org.jf.dexlib2.writer.builder.BuilderAnnotation;
import org.jf.dexlib2.writer.builder.BuilderAnnotationElement;
import org.jf.dexlib2.writer.builder.BuilderContext;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;

class BuilderAnnotationPool
implements AnnotationSection<BuilderStringReference, BuilderTypeReference, BuilderAnnotation, BuilderAnnotationElement, BuilderEncodedValues.BuilderEncodedValue> {
    @Nonnull
    private final BuilderContext context;
    @Nonnull
    private final ConcurrentMap<Annotation, BuilderAnnotation> internedItems = Maps.newConcurrentMap();

    BuilderAnnotationPool(@Nonnull BuilderContext context) {
        this.context = context;
    }

    @Nonnull
    public BuilderAnnotation internAnnotation(@Nonnull Annotation annotation2) {
        BuilderAnnotation ret = (BuilderAnnotation)this.internedItems.get(annotation2);
        if (ret != null) {
            return ret;
        }
        BuilderAnnotation dexBuilderAnnotation = new BuilderAnnotation(annotation2.getVisibility(), this.context.typePool.internType(annotation2.getType()), this.context.internAnnotationElements(annotation2.getElements()));
        ret = this.internedItems.putIfAbsent(dexBuilderAnnotation, dexBuilderAnnotation);
        return ret == null ? dexBuilderAnnotation : ret;
    }

    @Override
    public int getVisibility(@Nonnull BuilderAnnotation key2) {
        return key2.visibility;
    }

    @Override
    @Nonnull
    public BuilderTypeReference getType(@Nonnull BuilderAnnotation key2) {
        return key2.type;
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderAnnotationElement> getElements(@Nonnull BuilderAnnotation key2) {
        return key2.elements;
    }

    @Override
    @Nonnull
    public BuilderStringReference getElementName(@Nonnull BuilderAnnotationElement element2) {
        return element2.name;
    }

    @Override
    @Nonnull
    public BuilderEncodedValues.BuilderEncodedValue getElementValue(@Nonnull BuilderAnnotationElement element2) {
        return element2.value;
    }

    @Override
    public int getItemOffset(@Nonnull BuilderAnnotation key2) {
        return key2.offset;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderAnnotation, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderAnnotation>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderAnnotation key2) {
                return key2.offset;
            }

            @Override
            protected int setValue(@Nonnull BuilderAnnotation key2, int value2) {
                int prev = key2.offset;
                key2.offset = value2;
                return prev;
            }
        };
    }
}

