/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.jf.dexlib2.base.BaseAnnotationElement;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.writer.AnnotationSection;
import org.jf.dexlib2.writer.DexDataWriter;
import org.jf.dexlib2.writer.FieldSection;
import org.jf.dexlib2.writer.MethodSection;
import org.jf.dexlib2.writer.StringSection;
import org.jf.dexlib2.writer.TypeSection;

public abstract class EncodedValueWriter<StringKey, TypeKey, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference, AnnotationElement extends AnnotationElement, EncodedValue> {
    @Nonnull
    private final DexDataWriter writer;
    @Nonnull
    private final StringSection<StringKey, ?> stringSection;
    @Nonnull
    private final TypeSection<?, TypeKey, ?> typeSection;
    @Nonnull
    private final FieldSection<?, ?, FieldRefKey, ?> fieldSection;
    @Nonnull
    private final MethodSection<?, ?, ?, MethodRefKey, ?> methodSection;
    @Nonnull
    private final AnnotationSection<StringKey, TypeKey, ?, AnnotationElement, EncodedValue> annotationSection;

    public EncodedValueWriter(@Nonnull DexDataWriter writer, @Nonnull StringSection<StringKey, ?> stringSection, @Nonnull TypeSection<?, TypeKey, ?> typeSection, @Nonnull FieldSection<?, ?, FieldRefKey, ?> fieldSection, @Nonnull MethodSection<?, ?, ?, MethodRefKey, ?> methodSection, @Nonnull AnnotationSection<StringKey, TypeKey, ?, AnnotationElement, EncodedValue> annotationSection) {
        this.writer = writer;
        this.stringSection = stringSection;
        this.typeSection = typeSection;
        this.fieldSection = fieldSection;
        this.methodSection = methodSection;
        this.annotationSection = annotationSection;
    }

    protected abstract void writeEncodedValue(@Nonnull EncodedValue var1) throws IOException;

    public void writeAnnotation(TypeKey annotationType, Collection<? extends AnnotationElement> elements) throws IOException {
        this.writer.writeEncodedValueHeader(29, 0);
        this.writer.writeUleb128(this.typeSection.getItemIndex(annotationType));
        this.writer.writeUleb128(elements.size());
        ImmutableList<AnnotationElement> sortedElements = Ordering.from(BaseAnnotationElement.BY_NAME).immutableSortedCopy(elements);
        for (AnnotationElement element2 : sortedElements) {
            this.writer.writeUleb128(this.stringSection.getItemIndex(this.annotationSection.getElementName(element2)));
            this.writeEncodedValue(this.annotationSection.getElementValue(element2));
        }
    }

    public void writeArray(Collection<? extends EncodedValue> elements) throws IOException {
        this.writer.writeEncodedValueHeader(28, 0);
        this.writer.writeUleb128(elements.size());
        for (EncodedValue element2 : elements) {
            this.writeEncodedValue(element2);
        }
    }

    public void writeBoolean(boolean value2) throws IOException {
        this.writer.writeEncodedValueHeader(31, value2 ? 1 : 0);
    }

    public void writeByte(byte value2) throws IOException {
        this.writer.writeEncodedInt(0, value2);
    }

    public void writeChar(char value2) throws IOException {
        this.writer.writeEncodedUint(3, value2);
    }

    public void writeDouble(double value2) throws IOException {
        this.writer.writeEncodedDouble(17, value2);
    }

    public void writeEnum(@Nonnull FieldRefKey value2) throws IOException {
        this.writer.writeEncodedUint(27, this.fieldSection.getItemIndex(value2));
    }

    public void writeField(@Nonnull FieldRefKey value2) throws IOException {
        this.writer.writeEncodedUint(25, this.fieldSection.getItemIndex(value2));
    }

    public void writeFloat(float value2) throws IOException {
        this.writer.writeEncodedFloat(16, value2);
    }

    public void writeInt(int value2) throws IOException {
        this.writer.writeEncodedInt(4, value2);
    }

    public void writeLong(long value2) throws IOException {
        this.writer.writeEncodedLong(6, value2);
    }

    public void writeMethod(@Nonnull MethodRefKey value2) throws IOException {
        this.writer.writeEncodedUint(26, this.methodSection.getItemIndex(value2));
    }

    public void writeNull() throws IOException {
        this.writer.write(30);
    }

    public void writeShort(int value2) throws IOException {
        this.writer.writeEncodedInt(2, value2);
    }

    public void writeString(@Nonnull StringKey value2) throws IOException {
        this.writer.writeEncodedUint(23, this.stringSection.getItemIndex(value2));
    }

    public void writeType(@Nonnull TypeKey value2) throws IOException {
        this.writer.writeEncodedUint(24, this.typeSection.getItemIndex(value2));
    }
}

