/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import javax.annotation.Nonnull;
import org.jf.dexlib2.dexbacked.BaseDexBuffer;
import org.jf.util.ExceptionWithContext;
import org.jf.util.Utf8Utils;

public class BaseDexReader<T extends BaseDexBuffer> {
    @Nonnull
    public final T dexBuf;
    private int offset;

    public BaseDexReader(@Nonnull T dexBuf, int offset) {
        this.dexBuf = dexBuf;
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int readSleb128() {
        int result2;
        int end = this.offset;
        byte[] buf = ((BaseDexBuffer)this.dexBuf).buf;
        if ((result2 = buf[end++] & 0xFF) <= 127) {
            result2 = result2 << 25 >> 25;
        } else {
            int currentByteValue = buf[end++] & 0xFF;
            result2 = result2 & 0x7F | (currentByteValue & 0x7F) << 7;
            if (currentByteValue <= 127) {
                result2 = result2 << 18 >> 18;
            } else {
                currentByteValue = buf[end++] & 0xFF;
                result2 |= (currentByteValue & 0x7F) << 14;
                if (currentByteValue <= 127) {
                    result2 = result2 << 11 >> 11;
                } else {
                    currentByteValue = buf[end++] & 0xFF;
                    result2 |= (currentByteValue & 0x7F) << 21;
                    if (currentByteValue <= 127) {
                        result2 = result2 << 4 >> 4;
                    } else {
                        if ((currentByteValue = buf[end++] & 0xFF) > 127) {
                            throw new ExceptionWithContext("Invalid sleb128 integer encountered at offset 0x%x", this.offset);
                        }
                        result2 |= currentByteValue << 28;
                    }
                }
            }
        }
        this.offset = end;
        return result2;
    }

    public int readSmallUleb128() {
        return this.readUleb128(false);
    }

    private int readUleb128(boolean allowLarge) {
        int result2;
        int end = this.offset;
        byte[] buf = ((BaseDexBuffer)this.dexBuf).buf;
        if ((result2 = buf[end++] & 0xFF) > 127) {
            int currentByteValue = buf[end++] & 0xFF;
            result2 = result2 & 0x7F | (currentByteValue & 0x7F) << 7;
            if (currentByteValue > 127) {
                currentByteValue = buf[end++] & 0xFF;
                result2 |= (currentByteValue & 0x7F) << 14;
                if (currentByteValue > 127) {
                    currentByteValue = buf[end++] & 0xFF;
                    result2 |= (currentByteValue & 0x7F) << 21;
                    if (currentByteValue > 127) {
                        if ((currentByteValue = buf[end++]) < 0) {
                            throw new ExceptionWithContext("Invalid uleb128 integer encountered at offset 0x%x", this.offset);
                        }
                        if ((currentByteValue & 0xF) > 7 && !allowLarge) {
                            throw new ExceptionWithContext("Encountered valid uleb128 that is out of range at offset 0x%x", this.offset);
                        }
                        result2 |= currentByteValue << 28;
                    }
                }
            }
        }
        this.offset = end;
        return result2;
    }

    public int readLargeUleb128() {
        return this.readUleb128(true);
    }

    public int readBigUleb128() {
        int result2;
        int end = this.offset;
        byte[] buf = ((BaseDexBuffer)this.dexBuf).buf;
        if ((result2 = buf[end++] & 0xFF) > 127) {
            int currentByteValue = buf[end++] & 0xFF;
            result2 = result2 & 0x7F | (currentByteValue & 0x7F) << 7;
            if (currentByteValue > 127) {
                currentByteValue = buf[end++] & 0xFF;
                result2 |= (currentByteValue & 0x7F) << 14;
                if (currentByteValue > 127) {
                    currentByteValue = buf[end++] & 0xFF;
                    result2 |= (currentByteValue & 0x7F) << 21;
                    if (currentByteValue > 127) {
                        if ((currentByteValue = buf[end++]) < 0) {
                            throw new ExceptionWithContext("Invalid uleb128 integer encountered at offset 0x%x", this.offset);
                        }
                        result2 |= currentByteValue << 28;
                    }
                }
            }
        }
        this.offset = end;
        return result2;
    }

    public void skipUleb128() {
        byte currentByteValue;
        int end = this.offset;
        byte[] buf = ((BaseDexBuffer)this.dexBuf).buf;
        if ((currentByteValue = buf[end++]) < 0 && (currentByteValue = buf[end++]) < 0 && (currentByteValue = buf[end++]) < 0 && (currentByteValue = buf[end++]) < 0 && (currentByteValue = buf[end++]) < 0) {
            throw new ExceptionWithContext("Invalid uleb128 integer encountered at offset 0x%x", this.offset);
        }
        this.offset = end;
    }

    public int readSmallUint() {
        int o = this.offset;
        int result2 = ((BaseDexBuffer)this.dexBuf).readSmallUint(o);
        this.offset = o + 4;
        return result2;
    }

    public int readOptionalUint() {
        int o = this.offset;
        int result2 = ((BaseDexBuffer)this.dexBuf).readOptionalUint(o);
        this.offset = o + 4;
        return result2;
    }

    public int peekUshort() {
        return ((BaseDexBuffer)this.dexBuf).readUshort(this.offset);
    }

    public int readUshort() {
        int o = this.offset;
        int result2 = ((BaseDexBuffer)this.dexBuf).readUshort(this.offset);
        this.offset = o + 2;
        return result2;
    }

    public int peekUbyte() {
        return ((BaseDexBuffer)this.dexBuf).readUbyte(this.offset);
    }

    public int readUbyte() {
        int o = this.offset;
        int result2 = ((BaseDexBuffer)this.dexBuf).readUbyte(this.offset);
        this.offset = o + 1;
        return result2;
    }

    public long readLong() {
        int o = this.offset;
        long result2 = ((BaseDexBuffer)this.dexBuf).readLong(this.offset);
        this.offset = o + 8;
        return result2;
    }

    public int readInt() {
        int o = this.offset;
        int result2 = ((BaseDexBuffer)this.dexBuf).readInt(this.offset);
        this.offset = o + 4;
        return result2;
    }

    public int readShort() {
        int o = this.offset;
        int result2 = ((BaseDexBuffer)this.dexBuf).readShort(this.offset);
        this.offset = o + 2;
        return result2;
    }

    public int readByte() {
        int o = this.offset;
        int result2 = ((BaseDexBuffer)this.dexBuf).readByte(this.offset);
        this.offset = o + 1;
        return result2;
    }

    public void skipByte() {
        ++this.offset;
    }

    public void moveRelative(int i) {
        this.offset += i;
    }

    public int readSmallUint(int offset) {
        return ((BaseDexBuffer)this.dexBuf).readSmallUint(offset);
    }

    public int readUshort(int offset) {
        return ((BaseDexBuffer)this.dexBuf).readUshort(offset);
    }

    public int readUbyte(int offset) {
        return ((BaseDexBuffer)this.dexBuf).readUbyte(offset);
    }

    public long readLong(int offset) {
        return ((BaseDexBuffer)this.dexBuf).readLong(offset);
    }

    public int readInt(int offset) {
        return ((BaseDexBuffer)this.dexBuf).readInt(offset);
    }

    public int readShort(int offset) {
        return ((BaseDexBuffer)this.dexBuf).readShort(offset);
    }

    public int readByte(int offset) {
        return ((BaseDexBuffer)this.dexBuf).readByte(offset);
    }

    public int readSizedInt(int bytes) {
        int result2;
        int o = this.offset;
        byte[] buf = ((BaseDexBuffer)this.dexBuf).buf;
        switch (bytes) {
            case 4: {
                result2 = buf[o] & 0xFF | (buf[o + 1] & 0xFF) << 8 | (buf[o + 2] & 0xFF) << 16 | buf[o + 3] << 24;
                break;
            }
            case 3: {
                result2 = buf[o] & 0xFF | (buf[o + 1] & 0xFF) << 8 | buf[o + 2] << 16;
                break;
            }
            case 2: {
                result2 = buf[o] & 0xFF | buf[o + 1] << 8;
                break;
            }
            case 1: {
                result2 = buf[o];
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized int at offset 0x%x", bytes, this.offset);
            }
        }
        this.offset = o + bytes;
        return result2;
    }

    public int readSizedSmallUint(int bytes) {
        int o = this.offset;
        byte[] buf = ((BaseDexBuffer)this.dexBuf).buf;
        int result2 = 0;
        switch (bytes) {
            case 4: {
                byte b = buf[o + 3];
                if (b < 0) {
                    throw new ExceptionWithContext("Encountered valid sized uint that is out of range at offset 0x%x", this.offset);
                }
                result2 = b << 24;
            }
            case 3: {
                result2 |= (buf[o + 2] & 0xFF) << 16;
            }
            case 2: {
                result2 |= (buf[o + 1] & 0xFF) << 8;
            }
            case 1: {
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized uint at offset 0x%x", bytes, this.offset);
            }
        }
        this.offset = o + bytes;
        return result2 |= buf[o] & 0xFF;
    }

    public int readSizedRightExtendedInt(int bytes) {
        int result2;
        int o = this.offset;
        byte[] buf = ((BaseDexBuffer)this.dexBuf).buf;
        switch (bytes) {
            case 4: {
                result2 = buf[o] & 0xFF | (buf[o + 1] & 0xFF) << 8 | (buf[o + 2] & 0xFF) << 16 | buf[o + 3] << 24;
                break;
            }
            case 3: {
                result2 = (buf[o] & 0xFF) << 8 | (buf[o + 1] & 0xFF) << 16 | buf[o + 2] << 24;
                break;
            }
            case 2: {
                result2 = (buf[o] & 0xFF) << 16 | buf[o + 1] << 24;
                break;
            }
            case 1: {
                result2 = buf[o] << 24;
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized, right extended int at offset 0x%x", bytes, this.offset);
            }
        }
        this.offset = o + bytes;
        return result2;
    }

    public long readSizedRightExtendedLong(int bytes) {
        long result2;
        int o = this.offset;
        byte[] buf = ((BaseDexBuffer)this.dexBuf).buf;
        switch (bytes) {
            case 8: {
                result2 = (long)(buf[o] & 0xFF | (buf[o + 1] & 0xFF) << 8 | (buf[o + 2] & 0xFF) << 16) | ((long)buf[o + 3] & 0xFFL) << 24 | ((long)buf[o + 4] & 0xFFL) << 32 | ((long)buf[o + 5] & 0xFFL) << 40 | ((long)buf[o + 6] & 0xFFL) << 48 | (long)buf[o + 7] << 56;
                break;
            }
            case 7: {
                result2 = (long)((buf[o] & 0xFF) << 8 | (buf[o + 1] & 0xFF) << 16) | ((long)buf[o + 2] & 0xFFL) << 24 | ((long)buf[o + 3] & 0xFFL) << 32 | ((long)buf[o + 4] & 0xFFL) << 40 | ((long)buf[o + 5] & 0xFFL) << 48 | (long)buf[o + 6] << 56;
                break;
            }
            case 6: {
                result2 = (long)((buf[o] & 0xFF) << 16) | ((long)buf[o + 1] & 0xFFL) << 24 | ((long)buf[o + 2] & 0xFFL) << 32 | ((long)buf[o + 3] & 0xFFL) << 40 | ((long)buf[o + 4] & 0xFFL) << 48 | (long)buf[o + 5] << 56;
                break;
            }
            case 5: {
                result2 = ((long)buf[o] & 0xFFL) << 24 | ((long)buf[o + 1] & 0xFFL) << 32 | ((long)buf[o + 2] & 0xFFL) << 40 | ((long)buf[o + 3] & 0xFFL) << 48 | (long)buf[o + 4] << 56;
                break;
            }
            case 4: {
                result2 = ((long)buf[o] & 0xFFL) << 32 | ((long)buf[o + 1] & 0xFFL) << 40 | ((long)buf[o + 2] & 0xFFL) << 48 | (long)buf[o + 3] << 56;
                break;
            }
            case 3: {
                result2 = ((long)buf[o] & 0xFFL) << 40 | ((long)buf[o + 1] & 0xFFL) << 48 | (long)buf[o + 2] << 56;
                break;
            }
            case 2: {
                result2 = ((long)buf[o] & 0xFFL) << 48 | (long)buf[o + 1] << 56;
                break;
            }
            case 1: {
                result2 = (long)buf[o] << 56;
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized, right extended long at offset 0x%x", bytes, this.offset);
            }
        }
        this.offset = o + bytes;
        return result2;
    }

    public long readSizedLong(int bytes) {
        long result2;
        int o = this.offset;
        byte[] buf = ((BaseDexBuffer)this.dexBuf).buf;
        switch (bytes) {
            case 8: {
                result2 = (long)(buf[o] & 0xFF | (buf[o + 1] & 0xFF) << 8 | (buf[o + 2] & 0xFF) << 16) | ((long)buf[o + 3] & 0xFFL) << 24 | ((long)buf[o + 4] & 0xFFL) << 32 | ((long)buf[o + 5] & 0xFFL) << 40 | ((long)buf[o + 6] & 0xFFL) << 48 | (long)buf[o + 7] << 56;
                break;
            }
            case 7: {
                result2 = (long)(buf[o] & 0xFF | (buf[o + 1] & 0xFF) << 8 | (buf[o + 2] & 0xFF) << 16) | ((long)buf[o + 3] & 0xFFL) << 24 | ((long)buf[o + 4] & 0xFFL) << 32 | ((long)buf[o + 5] & 0xFFL) << 40 | (long)buf[o + 6] << 48;
                break;
            }
            case 6: {
                result2 = (long)(buf[o] & 0xFF | (buf[o + 1] & 0xFF) << 8 | (buf[o + 2] & 0xFF) << 16) | ((long)buf[o + 3] & 0xFFL) << 24 | ((long)buf[o + 4] & 0xFFL) << 32 | (long)buf[o + 5] << 40;
                break;
            }
            case 5: {
                result2 = (long)(buf[o] & 0xFF | (buf[o + 1] & 0xFF) << 8 | (buf[o + 2] & 0xFF) << 16) | ((long)buf[o + 3] & 0xFFL) << 24 | (long)buf[o + 4] << 32;
                break;
            }
            case 4: {
                result2 = (long)(buf[o] & 0xFF | (buf[o + 1] & 0xFF) << 8 | (buf[o + 2] & 0xFF) << 16) | (long)buf[o + 3] << 24;
                break;
            }
            case 3: {
                result2 = buf[o] & 0xFF | (buf[o + 1] & 0xFF) << 8 | buf[o + 2] << 16;
                break;
            }
            case 2: {
                result2 = buf[o] & 0xFF | buf[o + 1] << 8;
                break;
            }
            case 1: {
                result2 = buf[o];
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized long at offset 0x%x", bytes, this.offset);
            }
        }
        this.offset = o + bytes;
        return result2;
    }

    public String readString(int utf16Length) {
        int[] ret = new int[1];
        String value2 = Utf8Utils.utf8BytesWithUtf16LengthToString(((BaseDexBuffer)this.dexBuf).buf, this.offset, utf16Length, ret);
        this.offset += ret[0];
        return value2;
    }
}

