/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.xml.catalog.readers;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.jboss.util.xml.catalog.Catalog;
import org.jboss.util.xml.catalog.CatalogEntry;
import org.jboss.util.xml.catalog.CatalogException;
import org.jboss.util.xml.catalog.helpers.PublicId;
import org.jboss.util.xml.catalog.readers.SAXCatalogParser;
import org.jboss.util.xml.catalog.readers.SAXCatalogReader;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class OASISXMLCatalogReader
extends SAXCatalogReader
implements SAXCatalogParser {
    protected Catalog catalog = null;
    public static final String namespaceName = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    public static final String tr9401NamespaceName = "urn:oasis:names:tc:entity:xmlns:tr9401:catalog";
    protected Stack baseURIStack = new Stack();
    protected Stack overrideStack = new Stack();
    protected Stack namespaceStack = new Stack();

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
        this.debug = catalog.getCatalogManager().debug;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    protected boolean inExtensionNamespace() {
        boolean inExtension = false;
        Enumeration elements = this.namespaceStack.elements();
        while (!inExtension && elements.hasMoreElements()) {
            String ns = (String)elements.nextElement();
            if (ns == null) {
                inExtension = true;
                continue;
            }
            inExtension = !ns.equals(tr9401NamespaceName) && !ns.equals(namespaceName);
        }
        return inExtension;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.baseURIStack.push(this.catalog.getCurrentBase());
        this.overrideStack.push(this.catalog.getDefaultOverride());
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        block75: {
            CatalogEntry ce;
            CatalogEntry ce2;
            String baseURI;
            boolean inExtension;
            Vector<String> entryArgs;
            int entryType;
            block73: {
                entryType = -1;
                entryArgs = new Vector<String>();
                this.namespaceStack.push(namespaceURI);
                inExtension = this.inExtensionNamespace();
                if (namespaceURI != null && namespaceName.equals(namespaceURI) && !inExtension) {
                    if (atts.getValue("xml:base") != null) {
                        block71: {
                            baseURI = atts.getValue("xml:base");
                            entryType = Catalog.BASE;
                            entryArgs.add(baseURI);
                            this.baseURIStack.push(baseURI);
                            this.debug.message(4, "xml:base", baseURI);
                            try {
                                ce2 = new CatalogEntry(entryType, entryArgs);
                                this.catalog.addEntry(ce2);
                            }
                            catch (CatalogException cex) {
                                if (cex.getExceptionType() == 3) {
                                    this.debug.message(1, "Invalid catalog entry type", localName);
                                }
                                if (cex.getExceptionType() != 2) break block71;
                                this.debug.message(1, "Invalid catalog entry (base)", localName);
                            }
                        }
                        entryType = -1;
                        entryArgs = new Vector();
                    } else {
                        this.baseURIStack.push(this.baseURIStack.peek());
                    }
                    if ((localName.equals("catalog") || localName.equals("group")) && atts.getValue("prefer") != null) {
                        block72: {
                            String override = atts.getValue("prefer");
                            if (override.equals("public")) {
                                override = "yes";
                            } else if (override.equals("system")) {
                                override = "no";
                            } else {
                                this.debug.message(1, "Invalid prefer: must be 'system' or 'public'", localName);
                                override = this.catalog.getDefaultOverride();
                            }
                            entryType = Catalog.OVERRIDE;
                            entryArgs.add(override);
                            this.overrideStack.push(override);
                            this.debug.message(4, "override", override);
                            try {
                                ce2 = new CatalogEntry(entryType, entryArgs);
                                this.catalog.addEntry(ce2);
                            }
                            catch (CatalogException cex) {
                                if (cex.getExceptionType() == 3) {
                                    this.debug.message(1, "Invalid catalog entry type", localName);
                                }
                                if (cex.getExceptionType() != 2) break block72;
                                this.debug.message(1, "Invalid catalog entry (override)", localName);
                            }
                        }
                        entryType = -1;
                        entryArgs = new Vector();
                    } else {
                        this.overrideStack.push(this.overrideStack.peek());
                    }
                    if (localName.equals("delegatePublic")) {
                        if (this.checkAttributes(atts, "publicIdStartString", "catalog")) {
                            entryType = Catalog.DELEGATE_PUBLIC;
                            entryArgs.add(atts.getValue("publicIdStartString"));
                            entryArgs.add(atts.getValue("catalog"));
                            this.debug.message(4, "delegatePublic", PublicId.normalize(atts.getValue("publicIdStartString")), atts.getValue("catalog"));
                        }
                    } else if (localName.equals("delegateSystem")) {
                        if (this.checkAttributes(atts, "systemIdStartString", "catalog")) {
                            entryType = Catalog.DELEGATE_SYSTEM;
                            entryArgs.add(atts.getValue("systemIdStartString"));
                            entryArgs.add(atts.getValue("catalog"));
                            this.debug.message(4, "delegateSystem", atts.getValue("systemIdStartString"), atts.getValue("catalog"));
                        }
                    } else if (localName.equals("delegateURI")) {
                        if (this.checkAttributes(atts, "uriStartString", "catalog")) {
                            entryType = Catalog.DELEGATE_URI;
                            entryArgs.add(atts.getValue("uriStartString"));
                            entryArgs.add(atts.getValue("catalog"));
                            this.debug.message(4, "delegateURI", atts.getValue("uriStartString"), atts.getValue("catalog"));
                        }
                    } else if (localName.equals("rewriteSystem")) {
                        if (this.checkAttributes(atts, "systemIdStartString", "rewritePrefix")) {
                            entryType = Catalog.REWRITE_SYSTEM;
                            entryArgs.add(atts.getValue("systemIdStartString"));
                            entryArgs.add(atts.getValue("rewritePrefix"));
                            this.debug.message(4, "rewriteSystem", atts.getValue("systemIdStartString"), atts.getValue("rewritePrefix"));
                        }
                    } else if (localName.equals("rewriteURI")) {
                        if (this.checkAttributes(atts, "uriStartString", "rewritePrefix")) {
                            entryType = Catalog.REWRITE_URI;
                            entryArgs.add(atts.getValue("uriStartString"));
                            entryArgs.add(atts.getValue("rewritePrefix"));
                            this.debug.message(4, "rewriteURI", atts.getValue("uriStartString"), atts.getValue("rewritePrefix"));
                        }
                    } else if (localName.equals("nextCatalog")) {
                        if (this.checkAttributes(atts, "catalog")) {
                            entryType = Catalog.CATALOG;
                            entryArgs.add(atts.getValue("catalog"));
                            this.debug.message(4, "nextCatalog", atts.getValue("catalog"));
                        }
                    } else if (localName.equals("public")) {
                        if (this.checkAttributes(atts, "publicId", "uri")) {
                            entryType = Catalog.PUBLIC;
                            entryArgs.add(atts.getValue("publicId"));
                            entryArgs.add(atts.getValue("uri"));
                            this.debug.message(4, "public", PublicId.normalize(atts.getValue("publicId")), atts.getValue("uri"));
                        }
                    } else if (localName.equals("system")) {
                        if (this.checkAttributes(atts, "systemId", "uri")) {
                            entryType = Catalog.SYSTEM;
                            entryArgs.add(atts.getValue("systemId"));
                            entryArgs.add(atts.getValue("uri"));
                            this.debug.message(4, "system", atts.getValue("systemId"), atts.getValue("uri"));
                        }
                    } else if (localName.equals("uri")) {
                        if (this.checkAttributes(atts, "name", "uri")) {
                            entryType = Catalog.URI;
                            entryArgs.add(atts.getValue("name"));
                            entryArgs.add(atts.getValue("uri"));
                            this.debug.message(4, "uri", atts.getValue("name"), atts.getValue("uri"));
                        }
                    } else if (!localName.equals("catalog") && !localName.equals("group")) {
                        this.debug.message(1, "Invalid catalog entry type", localName);
                    }
                    if (entryType >= 0) {
                        try {
                            ce = new CatalogEntry(entryType, entryArgs);
                            this.catalog.addEntry(ce);
                        }
                        catch (CatalogException cex) {
                            if (cex.getExceptionType() == 3) {
                                this.debug.message(1, "Invalid catalog entry type", localName);
                            }
                            if (cex.getExceptionType() != 2) break block73;
                            this.debug.message(1, "Invalid catalog entry", localName);
                        }
                    }
                }
            }
            if (namespaceURI != null && tr9401NamespaceName.equals(namespaceURI) && !inExtension) {
                if (atts.getValue("xml:base") != null) {
                    block74: {
                        baseURI = atts.getValue("xml:base");
                        entryType = Catalog.BASE;
                        entryArgs.add(baseURI);
                        this.baseURIStack.push(baseURI);
                        this.debug.message(4, "xml:base", baseURI);
                        try {
                            ce2 = new CatalogEntry(entryType, entryArgs);
                            this.catalog.addEntry(ce2);
                        }
                        catch (CatalogException cex) {
                            if (cex.getExceptionType() == 3) {
                                this.debug.message(1, "Invalid catalog entry type", localName);
                            }
                            if (cex.getExceptionType() != 2) break block74;
                            this.debug.message(1, "Invalid catalog entry (base)", localName);
                        }
                    }
                    entryType = -1;
                    entryArgs = new Vector();
                } else {
                    this.baseURIStack.push(this.baseURIStack.peek());
                }
                if (localName.equals("doctype")) {
                    entryType = Catalog.DOCTYPE;
                    entryArgs.add(atts.getValue("name"));
                    entryArgs.add(atts.getValue("uri"));
                } else if (localName.equals("document")) {
                    entryType = Catalog.DOCUMENT;
                    entryArgs.add(atts.getValue("uri"));
                } else if (localName.equals("dtddecl")) {
                    entryType = Catalog.DTDDECL;
                    entryArgs.add(atts.getValue("publicId"));
                    entryArgs.add(atts.getValue("uri"));
                } else if (localName.equals("entity")) {
                    entryType = Catalog.ENTITY;
                    entryArgs.add(atts.getValue("name"));
                    entryArgs.add(atts.getValue("uri"));
                } else if (localName.equals("linktype")) {
                    entryType = Catalog.LINKTYPE;
                    entryArgs.add(atts.getValue("name"));
                    entryArgs.add(atts.getValue("uri"));
                } else if (localName.equals("notation")) {
                    entryType = Catalog.NOTATION;
                    entryArgs.add(atts.getValue("name"));
                    entryArgs.add(atts.getValue("uri"));
                } else if (localName.equals("sgmldecl")) {
                    entryType = Catalog.SGMLDECL;
                    entryArgs.add(atts.getValue("uri"));
                } else {
                    this.debug.message(1, "Invalid catalog entry type", localName);
                }
                if (entryType >= 0) {
                    try {
                        ce = new CatalogEntry(entryType, entryArgs);
                        this.catalog.addEntry(ce);
                    }
                    catch (CatalogException cex) {
                        if (cex.getExceptionType() == 3) {
                            this.debug.message(1, "Invalid catalog entry type", localName);
                        }
                        if (cex.getExceptionType() != 2) break block75;
                        this.debug.message(1, "Invalid catalog entry", localName);
                    }
                }
            }
        }
    }

    public boolean checkAttributes(Attributes atts, String attName) {
        if (atts.getValue(attName) == null) {
            this.debug.message(1, "Error: required attribute " + attName + " missing.");
            return false;
        }
        return true;
    }

    public boolean checkAttributes(Attributes atts, String attName1, String attName2) {
        return this.checkAttributes(atts, attName1) && this.checkAttributes(atts, attName2);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        block11: {
            CatalogEntry ce;
            boolean inExtension;
            Vector<String> entryArgs;
            int entryType;
            block10: {
                entryType = -1;
                entryArgs = new Vector<String>();
                inExtension = this.inExtensionNamespace();
                if (namespaceURI != null && !inExtension && (namespaceName.equals(namespaceURI) || tr9401NamespaceName.equals(namespaceURI))) {
                    String popURI = (String)this.baseURIStack.pop();
                    String baseURI = (String)this.baseURIStack.peek();
                    if (!baseURI.equals(popURI)) {
                        entryType = Catalog.BASE;
                        entryArgs.add(baseURI);
                        this.debug.message(4, "(reset) xml:base", baseURI);
                        try {
                            ce = new CatalogEntry(entryType, entryArgs);
                            this.catalog.addEntry(ce);
                        }
                        catch (CatalogException cex) {
                            if (cex.getExceptionType() == 3) {
                                this.debug.message(1, "Invalid catalog entry type", localName);
                            }
                            if (cex.getExceptionType() != 2) break block10;
                            this.debug.message(1, "Invalid catalog entry (rbase)", localName);
                        }
                    }
                }
            }
            if (namespaceURI != null && namespaceName.equals(namespaceURI) && !inExtension && (localName.equals("catalog") || localName.equals("group"))) {
                String popOverride = (String)this.overrideStack.pop();
                String override = (String)this.overrideStack.peek();
                if (!override.equals(popOverride)) {
                    entryType = Catalog.OVERRIDE;
                    entryArgs.add(override);
                    this.overrideStack.push(override);
                    this.debug.message(4, "(reset) override", override);
                    try {
                        ce = new CatalogEntry(entryType, entryArgs);
                        this.catalog.addEntry(ce);
                    }
                    catch (CatalogException cex) {
                        if (cex.getExceptionType() == 3) {
                            this.debug.message(1, "Invalid catalog entry type", localName);
                        }
                        if (cex.getExceptionType() != 2) break block11;
                        this.debug.message(1, "Invalid catalog entry (roverride)", localName);
                    }
                }
            }
        }
        this.namespaceStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length2) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }
}

