/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.stream;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.util.stream.StreamListener;

public class NotifyingBufferedOutputStream
extends BufferedOutputStream {
    int chunkSize;
    int chunk = 0;
    StreamListener listener;

    public NotifyingBufferedOutputStream(OutputStream os, int size2, int chunkSize, StreamListener listener) {
        super(os, size2);
        if (chunkSize <= size2) {
            throw new IllegalArgumentException("chunkSize must be bigger than the buffer");
        }
        this.chunkSize = chunkSize;
        this.listener = listener;
    }

    public void setStreamListener(StreamListener listener) {
        this.listener = listener;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.checkNotification(1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.checkNotification(len);
    }

    public void checkNotification(int result2) {
        this.chunk += result2;
        if (this.chunk >= this.chunkSize) {
            if (this.listener != null) {
                this.listener.onStreamNotification(this, this.chunk);
            }
            this.chunk = 0;
        }
    }
}

