/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.property;

import java.beans.PropertyEditor;
import org.jboss.util.Classes;
import org.jboss.util.FieldInstance;
import org.jboss.util.NullArgumentException;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.property.BoundPropertyAdapter;
import org.jboss.util.property.PropertyEvent;
import org.jboss.util.property.PropertyException;
import org.jboss.util.property.PropertyMap;
import org.jboss.util.propertyeditor.PropertyEditors;

public class FieldBoundPropertyListener
extends BoundPropertyAdapter {
    protected final String propertyName;
    protected final FieldInstance fieldInstance;

    public FieldBoundPropertyListener(Object instance, String fieldName, String propertyName) {
        if (propertyName == null) {
            throw new NullArgumentException("propertyName");
        }
        this.propertyName = propertyName;
        try {
            this.fieldInstance = new FieldInstance(instance, fieldName);
            try {
                this.fieldInstance.getField().setAccessible(true);
            }
            catch (SecurityException e) {
                ThrowableHandler.add(e);
            }
            Classes.forceLoad(this.fieldInstance.getField().getType());
        }
        catch (NoSuchFieldException e) {
            throw new PropertyException(e);
        }
    }

    public FieldBoundPropertyListener(Object instance, String fieldName) {
        this(instance, fieldName, fieldName);
    }

    @Override
    public final String getPropertyName() {
        return this.propertyName;
    }

    public String filterValue(String value2) {
        return value2;
    }

    protected void setFieldValue(String value2) {
        try {
            value2 = this.filterValue(value2);
            Class<?> type = this.fieldInstance.getField().getType();
            PropertyEditor editor = PropertyEditors.findEditor(type);
            editor.setAsText(value2);
            Object coerced = editor.getValue();
            this.fieldInstance.set(coerced);
        }
        catch (IllegalAccessException e) {
            throw new PropertyException(e);
        }
    }

    @Override
    public void propertyAdded(PropertyEvent event) {
        this.setFieldValue(event.getPropertyValue());
    }

    @Override
    public void propertyChanged(PropertyEvent event) {
        this.setFieldValue(event.getPropertyValue());
    }

    @Override
    public void propertyBound(PropertyMap map2) {
        if (map2.containsProperty(this.propertyName)) {
            this.setFieldValue(map2.getProperty(this.propertyName));
        }
    }
}

