/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.util.collection.SecurityActions;
import org.jboss.util.collection.WeakValueHashMap;

public abstract class WeakTypeCache<T> {
    private Map<ClassLoader, Map<String, T>> cache = new WeakHashMap<ClassLoader, Map<String, T>>();

    public T get(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (type instanceof ParameterizedType) {
            return this.getParameterizedType((ParameterizedType)type);
        }
        if (type instanceof Class) {
            return this.getClass((Class)type);
        }
        if (type instanceof TypeVariable) {
            return this.getTypeVariable((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return this.getGenericArrayType((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            return this.getWildcardType((WildcardType)type);
        }
        throw new UnsupportedOperationException("Unknown type: " + type + " class=" + type.getClass());
    }

    public T get(String name, ClassLoader cl) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        Class<?> clazz = cl.loadClass(name);
        return this.get(clazz);
    }

    protected abstract T instantiate(Class<?> var1);

    protected abstract void generate(Class<?> var1, T var2);

    protected abstract T instantiate(ParameterizedType var1);

    protected abstract void generate(ParameterizedType var1, T var2);

    protected T getParameterizedType(ParameterizedType type) {
        T result2 = this.peek(type);
        if (result2 != null) {
            return result2;
        }
        result2 = this.instantiate(type);
        this.put(type, result2);
        this.generate(type, result2);
        return result2;
    }

    protected T getWildcardType(WildcardType type) {
        return this.get(type.getUpperBounds()[0]);
    }

    protected <D extends GenericDeclaration> T getTypeVariable(TypeVariable<D> type) {
        return this.get(type.getBounds()[0]);
    }

    protected T getGenericArrayType(GenericArrayType type) {
        return this.get((Type)((Object)Object[].class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T peek(ParameterizedType type) {
        Map<String, T> classLoaderCache;
        Class rawType = (Class)type.getRawType();
        ClassLoader cl = SecurityActions.getClassLoader(rawType);
        Map<String, T> map2 = classLoaderCache = this.getClassLoaderCache(cl);
        synchronized (map2) {
            return classLoaderCache.get(type.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(ParameterizedType type, T result2) {
        Map<String, T> classLoaderCache;
        Class rawType = (Class)type.getRawType();
        ClassLoader cl = SecurityActions.getClassLoader(rawType);
        Map<String, T> map2 = classLoaderCache = this.getClassLoaderCache(cl);
        synchronized (map2) {
            classLoaderCache.put(type.toString(), result2);
        }
    }

    protected T getClass(Class<?> clazz) {
        T result2 = this.peek(clazz);
        if (result2 != null) {
            return result2;
        }
        result2 = this.instantiate(clazz);
        this.put(clazz, result2);
        this.generate(clazz, result2);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T peek(Class<?> clazz) {
        Map<String, T> classLoaderCache;
        ClassLoader cl = SecurityActions.getClassLoader(clazz);
        Map<String, T> map2 = classLoaderCache = this.getClassLoaderCache(cl);
        synchronized (map2) {
            return classLoaderCache.get(clazz.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(Class<?> clazz, T result2) {
        Map<String, T> classLoaderCache;
        ClassLoader cl = SecurityActions.getClassLoader(clazz);
        Map<String, T> map2 = classLoaderCache = this.getClassLoaderCache(cl);
        synchronized (map2) {
            classLoaderCache.put(clazz.getName(), result2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, T> getClassLoaderCache(ClassLoader cl) {
        Map<ClassLoader, Map<String, T>> map2 = this.cache;
        synchronized (map2) {
            Map<String, T> result2 = this.cache.get(cl);
            if (result2 == null) {
                result2 = new WeakValueHashMap<String, T>();
                this.cache.put(cl, result2);
            }
            return result2;
        }
    }
}

