/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakIdentityHashMap
implements Map {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();
    private volatile int modCount;
    volatile transient Set keySet = null;
    volatile transient Collection values = null;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;

    public WeakIdentityHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.table = new Entry[capacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public WeakIdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakIdentityHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
    }

    public WeakIdentityHashMap(Map t) {
        this(Math.max((int)((float)t.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(t);
    }

    private static Object maskNull(Object key2) {
        return key2 == null ? NULL_KEY : key2;
    }

    private static Object unmaskNull(Object key2) {
        return key2 == NULL_KEY ? null : key2;
    }

    int hash(Object x) {
        int h = System.identityHashCode(x);
        return h - (h << 7);
    }

    static int indexFor(int h, int length2) {
        return h & length2 - 1;
    }

    private void expungeStaleEntries() {
        Reference r;
        block0: while ((r = this.queue.poll()) != null) {
            Entry prev;
            Entry e = (Entry)r;
            int h = e.hash;
            int i = WeakIdentityHashMap.indexFor(h, this.table.length);
            Entry p = prev = this.table[i];
            while (p != null) {
                Entry next2 = p.next;
                if (p == e) {
                    if (prev == e) {
                        this.table[i] = next2;
                    } else {
                        prev.next = next2;
                    }
                    e.next = null;
                    e.value = null;
                    --this.size;
                    continue block0;
                }
                prev = p;
                p = next2;
            }
        }
    }

    private Entry[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object get(Object key2) {
        Object k = WeakIdentityHashMap.maskNull(key2);
        int h = this.hash(k);
        Entry[] tab = this.getTable();
        int index = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == h && k == e.get()) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.getEntry(key2) != null;
    }

    Entry getEntry(Object key2) {
        Object k = WeakIdentityHashMap.maskNull(key2);
        int h = this.hash(k);
        Entry[] tab = this.getTable();
        int index = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = tab[index];
        while (e != null && (e.hash != h || k != e.get())) {
            e = e.next;
        }
        return e;
    }

    public Object put(Object key2, Object value2) {
        Object k = WeakIdentityHashMap.maskNull(key2);
        int h = this.hash(k);
        Entry[] tab = this.getTable();
        int i = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = tab[i];
        while (e != null) {
            if (h == e.hash && k == e.get()) {
                Object oldValue = e.value;
                if (value2 != oldValue) {
                    e.value = value2;
                }
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        tab[i] = new Entry(k, value2, this.queue, h, tab[i]);
        if (++this.size >= this.threshold) {
            this.resize(tab.length * 2);
        }
        return null;
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.getTable();
        int oldCapacity = oldTable.length;
        if (this.size < this.threshold || oldCapacity > newCapacity) {
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(oldTable, newTable);
        this.table = newTable;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable);
            this.table = oldTable;
        }
    }

    private void transfer(Entry[] src, Entry[] dest) {
        for (int j = 0; j < src.length; ++j) {
            Entry e = src[j];
            src[j] = null;
            while (e != null) {
                Entry next2 = e.next;
                Object key2 = e.get();
                if (key2 == null) {
                    e.next = null;
                    e.value = null;
                    --this.size;
                } else {
                    int i = WeakIdentityHashMap.indexFor(e.hash, dest.length);
                    e.next = dest[i];
                    dest[i] = e;
                }
                e = next2;
            }
        }
    }

    public void putAll(Map t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            int capacity;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (capacity = this.table.length; capacity < n; capacity <<= 1) {
            }
            this.resize(capacity);
        }
        for (Map.Entry e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key2) {
        Entry prev;
        Object k = WeakIdentityHashMap.maskNull(key2);
        int h = this.hash(k);
        Entry[] tab = this.getTable();
        int i = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = prev = tab[i];
        while (e != null) {
            Entry next2 = e.next;
            if (h == e.hash && k == e.get()) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next2;
                } else {
                    prev.next = next2;
                }
                return e.value;
            }
            prev = e;
            e = next2;
        }
        return null;
    }

    Entry removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Entry[] tab = this.getTable();
        Map.Entry entry2 = (Map.Entry)o;
        Object k = WeakIdentityHashMap.maskNull(entry2.getKey());
        int h = this.hash(k);
        int i = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = prev = tab[i];
        while (e != null) {
            Entry next2 = e.next;
            if (h == e.hash && e.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next2;
                } else {
                    prev.next = next2;
                }
                return e;
            }
            prev = e;
            e = next2;
        }
        return null;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object value2) {
        if (value2 == null) {
            return this.containsNullValue();
        }
        Entry[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (value2.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    static class SimpleEntry
    implements Map.Entry {
        Object key;
        Object value;

        public SimpleEntry(Object key2, Object value2) {
            this.key = key2;
            this.value = value2;
        }

        public SimpleEntry(Map.Entry e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value2) {
            Object oldValue = this.value;
            this.value = value2;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.key, e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = WeakIdentityHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return WeakIdentityHashMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<SimpleEntry> c = new ArrayList<SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a2) {
            ArrayList<SimpleEntry> c = new ArrayList<SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray(a2);
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakIdentityHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a2) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a2);
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakIdentityHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (WeakIdentityHashMap.this.containsKey(o)) {
                WeakIdentityHashMap.this.remove(o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a2) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a2);
        }
    }

    private class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator
    implements Iterator {
        int index;
        Entry entry = null;
        Entry lastReturned = null;
        int expectedModCount = WeakIdentityHashMap.access$400(WeakIdentityHashMap.this);
        Object nextKey = null;
        Object currentKey = null;

        HashIterator() {
            this.index = WeakIdentityHashMap.this.size() != 0 ? WeakIdentityHashMap.this.table.length : 0;
        }

        @Override
        public boolean hasNext() {
            Entry[] t = WeakIdentityHashMap.this.table;
            while (this.nextKey == null) {
                Entry e = this.entry;
                int i = this.index;
                while (e == null && i > 0) {
                    e = t[--i];
                }
                this.entry = e;
                this.index = i;
                if (e == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = e.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry nextEntry() {
            if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakIdentityHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakIdentityHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    private static class Entry
    extends WeakReference
    implements Map.Entry {
        private Object value;
        private final int hash;
        private Entry next;

        Entry(Object key2, Object value2, ReferenceQueue queue, int hash, Entry next2) {
            super(key2, queue);
            this.value = value2;
            this.hash = hash;
            this.next = next2;
        }

        public Object getKey() {
            return WeakIdentityHashMap.unmaskNull(this.get());
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return k1 == (k2 = e.getKey()) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            Object k = this.getKey();
            Object v = this.getValue();
            return (k == null ? 0 : System.identityHashCode(k)) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

