/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;

public class MapDelegateSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<E, Object> map;
    private static final Object PRESENT = new Object();

    public MapDelegateSet(Map<E, Object> map2) {
        if (map2 == null) {
            throw new IllegalArgumentException("Null map");
        }
        this.map = map2;
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public String toString() {
        return this.map.keySet().toString();
    }
}

