/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LazyMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<K, V> delegate = Collections.emptyMap();

    private Map<K, V> createImplementation() {
        if (!(this.delegate instanceof HashMap)) {
            return new HashMap<K, V>(this.delegate);
        }
        return this.delegate;
    }

    @Override
    public void clear() {
        this.delegate = Collections.emptyMap();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.delegate.containsValue(value2);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public V get(Object key2) {
        return this.delegate.get(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public V put(K key2, V value2) {
        if (this.delegate.isEmpty()) {
            this.delegate = Collections.singletonMap(key2, value2);
            return null;
        }
        this.delegate = this.createImplementation();
        return this.delegate.put(key2, value2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.delegate = this.createImplementation();
        this.delegate.putAll(t);
    }

    @Override
    public V remove(Object key2) {
        this.delegate = this.createImplementation();
        return this.delegate.remove(key2);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

