/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class FastCopyHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final Object NULL = new Object();
    private static final long serialVersionUID = 10929568968762L;
    private static final int DEFAULT_CAPACITY = 8;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.67f;
    private transient Entry<K, V>[] table;
    private transient int size;
    private transient int threshold;
    private final float loadFactor;
    private transient int modCount;
    private transient KeySet keySet;
    private transient Values values;
    private transient EntrySet entrySet;

    public FastCopyHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Can not have a negative size table!");
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (!(loadFactor > 0.0f) || !(loadFactor <= 1.0f)) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and less than or equal to 1");
        }
        this.loadFactor = loadFactor;
        this.init(initialCapacity, loadFactor);
    }

    public FastCopyHashMap(Map<? extends K, ? extends V> map2) {
        if (map2 instanceof FastCopyHashMap) {
            FastCopyHashMap fast = (FastCopyHashMap)map2;
            this.table = (Entry[])fast.table.clone();
            this.loadFactor = fast.loadFactor;
            this.size = fast.size;
            this.threshold = fast.threshold;
        } else {
            this.loadFactor = 0.67f;
            this.init(map2.size(), this.loadFactor);
            this.putAll(map2);
        }
    }

    private void init(int initialCapacity, float loadFactor) {
        int c;
        for (c = 1; c < initialCapacity; c <<= 1) {
        }
        this.threshold = (int)((float)c * loadFactor);
        if (initialCapacity > this.threshold && c < 0x40000000) {
            this.threshold = (int)((float)(c <<= 1) * loadFactor);
        }
        this.table = new Entry[c];
    }

    public FastCopyHashMap(int initialCapacity) {
        this(initialCapacity, 0.67f);
    }

    public FastCopyHashMap() {
        this(8);
    }

    private static final int hash(Object key2) {
        int h = key2.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static final <K> K maskNull(K key2) {
        return (K)(key2 == null ? NULL : key2);
    }

    private static final <K> K unmaskNull(K key2) {
        return key2 == NULL ? null : (K)key2;
    }

    private int nextIndex(int index, int length2) {
        index = index >= length2 - 1 ? 0 : index + 1;
        return index;
    }

    private static final boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private static final int index(int hashCode, int length2) {
        return hashCode & length2 - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key2) {
        int index;
        key2 = FastCopyHashMap.maskNull(key2);
        int hash = FastCopyHashMap.hash(key2);
        int length2 = this.table.length;
        int start = index = FastCopyHashMap.index(hash, length2);
        do {
            Entry<K, V> e;
            if ((e = this.table[index]) == null) {
                return null;
            }
            if (e.hash != hash || !FastCopyHashMap.eq(key2, e.key)) continue;
            return e.value;
        } while ((index = this.nextIndex(index, length2)) != start);
        return null;
    }

    @Override
    public boolean containsKey(Object key2) {
        int index;
        key2 = FastCopyHashMap.maskNull(key2);
        int hash = FastCopyHashMap.hash(key2);
        int length2 = this.table.length;
        int start = index = FastCopyHashMap.index(hash, length2);
        do {
            Entry<K, V> e;
            if ((e = this.table[index]) == null) {
                return false;
            }
            if (e.hash != hash || !FastCopyHashMap.eq(key2, e.key)) continue;
            return true;
        } while ((index = this.nextIndex(index, length2)) != start);
        return false;
    }

    @Override
    public boolean containsValue(Object value2) {
        for (Entry<K, V> e : this.table) {
            if (e == null || !FastCopyHashMap.eq(value2, e.value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V put(K key2, V value2) {
        Entry<K, V> e;
        int index;
        key2 = FastCopyHashMap.maskNull(key2);
        Entry<K, V>[] table = this.table;
        int hash = FastCopyHashMap.hash(key2);
        int length2 = table.length;
        int start = index = FastCopyHashMap.index(hash, length2);
        while ((e = table[index]) != null) {
            if (e.hash == hash && FastCopyHashMap.eq(key2, e.key)) {
                table[index] = new Entry(e.key, e.hash, value2);
                return e.value;
            }
            if ((index = this.nextIndex(index, length2)) != start) continue;
            throw new IllegalStateException("Table is full!");
        }
        ++this.modCount;
        table[index] = new Entry<K, V>(key2, hash, value2);
        if (++this.size >= this.threshold) {
            this.resize(length2);
        }
        return null;
    }

    private void resize(int from2) {
        Entry<K, V>[] old;
        int newLength = from2 << 1;
        if (newLength > 0x40000000 || newLength <= from2) {
            return;
        }
        Entry[] newTable = new Entry[newLength];
        for (Entry<K, V> e : old = this.table) {
            if (e == null) continue;
            int index = FastCopyHashMap.index(e.hash, newLength);
            while (newTable[index] != null) {
                index = this.nextIndex(index, newLength);
            }
            newTable[index] = e;
        }
        this.threshold = (int)(this.loadFactor * (float)newLength);
        this.table = newTable;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        int size2 = map2.size();
        if (size2 == 0) {
            return;
        }
        if (size2 > this.threshold) {
            int length2;
            if (size2 > 0x40000000) {
                size2 = 0x40000000;
            }
            for (length2 = this.table.length; length2 < size2; length2 <<= 1) {
            }
            this.resize(length2);
        }
        for (Map.Entry<K, V> e : map2.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key2) {
        int start;
        key2 = FastCopyHashMap.maskNull(key2);
        Entry<K, V>[] table = this.table;
        int length2 = table.length;
        int hash = FastCopyHashMap.hash(key2);
        int index = start = FastCopyHashMap.index(hash, length2);
        do {
            Entry<K, V> e;
            if ((e = table[index]) == null) {
                return null;
            }
            if (e.hash != hash || !FastCopyHashMap.eq(key2, e.key)) continue;
            table[index] = null;
            this.relocate(index);
            ++this.modCount;
            --this.size;
            return e.value;
        } while ((index = this.nextIndex(index, length2)) != start);
        return null;
    }

    private void relocate(int start) {
        Entry<K, V>[] table = this.table;
        int length2 = table.length;
        int current = this.nextIndex(start, length2);
        Entry<K, V> e;
        while ((e = table[current]) != null) {
            int prefer = FastCopyHashMap.index(e.hash, length2);
            if (current < prefer && (prefer <= start || start <= current) || prefer <= start && start <= current) {
                table[start] = e;
                table[current] = null;
                start = current;
            }
            current = this.nextIndex(current, length2);
        }
        return;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry<K, V>[] table = this.table;
        for (int i = 0; i < table.length; ++i) {
            table[i] = null;
        }
        this.size = 0;
    }

    @Override
    public Object clone() {
        try {
            FastCopyHashMap clone2 = (FastCopyHashMap)super.clone();
            clone2.table = (Entry[])this.table.clone();
            clone2.entrySet = null;
            clone2.values = null;
            clone2.keySet = null;
            return clone2;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void printDebugStats() {
        int optimal = 0;
        int total = 0;
        int totalSkew = 0;
        int maxSkew = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry<K, V> e = this.table[i];
            if (e == null) continue;
            ++total;
            int target = FastCopyHashMap.index(e.hash, this.table.length);
            if (i == target) {
                ++optimal;
                continue;
            }
            int skew = Math.abs(i - target);
            if (skew > maxSkew) {
                maxSkew = skew;
            }
            totalSkew += skew;
        }
        System.out.println(" Size:             " + this.size);
        System.out.println(" Real Size:        " + total);
        System.out.println(" Optimal:          " + optimal + " (" + (float)optimal * 100.0f / (float)total + "%)");
        System.out.println(" Average Distance: " + (float)totalSkew / (float)(total - optimal));
        System.out.println(" Max Distance:     " + maxSkew);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int size2 = s2.readInt();
        this.init(size2, this.loadFactor);
        for (int i = 0; i < size2; ++i) {
            Object key2 = s2.readObject();
            Object value2 = s2.readObject();
            this.putForCreate(key2, value2);
        }
        this.size = size2;
    }

    private void putForCreate(K key2, V value2) {
        key2 = FastCopyHashMap.maskNull(key2);
        Entry<K, V>[] table = this.table;
        int hash = FastCopyHashMap.hash(key2);
        int length2 = table.length;
        int index = FastCopyHashMap.index(hash, length2);
        Entry<K, V> e = table[index];
        while (e != null) {
            index = this.nextIndex(index, length2);
            e = table[index];
        }
        table[index] = new Entry<K, V>(key2, hash, value2);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.size);
        for (Entry<K, V> e : this.table) {
            if (e == null) continue;
            s2.writeObject(FastCopyHashMap.unmaskNull(e.key));
            s2.writeObject(e.value);
        }
    }

    protected static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        SimpleEntry(K key2, V value2) {
            this.key = key2;
            this.value = value2;
        }

        SimpleEntry(Map.Entry<K, V> entry2) {
            this.key = entry2.getKey();
            this.value = entry2.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value2) {
            V old = this.value;
            this.value = value2;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return FastCopyHashMap.eq(this.key, e.getKey()) && FastCopyHashMap.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : FastCopyHashMap.hash(this.key)) ^ (this.value == null ? 0 : FastCopyHashMap.hash(this.value));
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry2 = (Map.Entry)o;
            Object value2 = FastCopyHashMap.this.get(entry2.getKey());
            return FastCopyHashMap.eq(entry2.getValue(), value2);
        }

        @Override
        public void clear() {
            FastCopyHashMap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return FastCopyHashMap.this.isEmpty();
        }

        @Override
        public int size() {
            return FastCopyHashMap.this.size();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public void clear() {
            FastCopyHashMap.this.clear();
        }

        @Override
        public int size() {
            return FastCopyHashMap.this.size();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public void clear() {
            FastCopyHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return FastCopyHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int size2 = this.size();
            FastCopyHashMap.this.remove(o);
            return this.size() < size2;
        }

        @Override
        public int size() {
            return FastCopyHashMap.this.size();
        }
    }

    private class EntryIterator
    extends FastCopyHashMapIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            Entry e = this.nextEntry();
            return new WriteThroughEntry(FastCopyHashMap.unmaskNull(e.key), e.value);
        }

        private class WriteThroughEntry
        extends SimpleEntry<K, V> {
            WriteThroughEntry(K key2, V value2) {
                super(key2, value2);
            }

            @Override
            public V setValue(V value2) {
                if (EntryIterator.this.table != FastCopyHashMap.this.table) {
                    FastCopyHashMap.this.put(this.getKey(), value2);
                }
                return super.setValue(value2);
            }
        }
    }

    private class ValueIterator
    extends FastCopyHashMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends FastCopyHashMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return FastCopyHashMap.unmaskNull(this.nextEntry().key);
        }
    }

    private abstract class FastCopyHashMapIterator<E>
    implements Iterator<E> {
        private int next = 0;
        private int expectedCount = FastCopyHashMap.access$300(FastCopyHashMap.this);
        private int current = -1;
        private boolean hasNext;
        Entry<K, V>[] table = FastCopyHashMap.access$400(FastCopyHashMap.this);

        private FastCopyHashMapIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            Entry<K, V>[] table = this.table;
            for (int i = this.next; i < table.length; ++i) {
                if (table[i] == null) continue;
                this.next = i;
                this.hasNext = true;
                return true;
            }
            this.next = table.length;
            return false;
        }

        protected Entry<K, V> nextEntry() {
            if (FastCopyHashMap.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next++;
            this.hasNext = false;
            return this.table[this.current];
        }

        @Override
        public void remove() {
            Entry e;
            int current;
            if (FastCopyHashMap.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            int delete = current = this.current;
            if (current == -1) {
                throw new IllegalStateException();
            }
            this.current = -1;
            this.next = delete;
            Entry<K, V>[] table = this.table;
            if (table != FastCopyHashMap.this.table) {
                FastCopyHashMap.this.remove(table[delete].key);
                table[delete] = null;
                this.expectedCount = FastCopyHashMap.this.modCount;
                return;
            }
            int length2 = table.length;
            int i = delete;
            table[delete] = null;
            FastCopyHashMap.this.size--;
            while ((e = table[i = FastCopyHashMap.this.nextIndex(i, length2)]) != null) {
                int prefer = FastCopyHashMap.index(e.hash, length2);
                if ((i >= prefer || prefer > delete && delete > i) && (prefer > delete || delete > i)) continue;
                if (i < current && current <= delete && table == FastCopyHashMap.this.table) {
                    int remaining = length2 - current;
                    Entry[] newTable = new Entry[remaining];
                    System.arraycopy(table, current, newTable, 0, remaining);
                    this.table = newTable;
                    this.next = 0;
                }
                table[delete] = e;
                table[i] = null;
                delete = i;
            }
        }
    }

    private static final class Entry<K, V> {
        final K key;
        final int hash;
        final V value;

        Entry(K key2, int hash, V value2) {
            this.key = key2;
            this.hash = hash;
            this.value = value2;
        }
    }
}

