/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.lang.ref.ReferenceQueue;
import java.util.AbstractList;
import java.util.LinkedList;
import java.util.List;
import org.jboss.util.Objects;
import org.jboss.util.SoftObject;

public class CachedList
extends AbstractList {
    protected final ReferenceQueue queue = new ReferenceQueue();
    protected final List list;

    public CachedList(List list) {
        this.list = list;
    }

    public CachedList() {
        this(new LinkedList());
    }

    private Object getObject(int index) {
        Object obj = this.list.get(index);
        return Objects.deref(obj);
    }

    @Override
    public Object get(int index) {
        this.maintain();
        return this.getObject(index);
    }

    @Override
    public int size() {
        this.maintain();
        return this.list.size();
    }

    @Override
    public Object set(int index, Object obj) {
        this.maintain();
        SoftObject soft = SoftObject.create(obj, this.queue);
        soft = this.list.set(index, soft);
        return Objects.deref(soft);
    }

    @Override
    public void add(int index, Object obj) {
        this.maintain();
        SoftObject soft = SoftObject.create(obj, this.queue);
        this.list.add(index, soft);
    }

    @Override
    public Object remove(int index) {
        this.maintain();
        Object obj = this.list.remove(index);
        return Objects.deref(obj);
    }

    private void maintain() {
        SoftObject obj;
        int count2 = 0;
        while ((obj = (SoftObject)this.queue.poll()) != null) {
            ++count2;
            this.list.remove(obj);
        }
        if (count2 != 0) {
            System.err.println("vm reclaimed " + count2 + " objects");
        }
    }
}

