/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.File;
import java.util.Properties;
import org.jboss.util.SysPropertyActions;

public final class StringPropertyReplacer {
    public static final String NEWLINE = SysPropertyActions.getProperty("line.separator", "\n");
    private static final String FILE_SEPARATOR = File.separator;
    private static final String PATH_SEPARATOR = File.pathSeparator;
    private static final String FILE_SEPARATOR_ALIAS = "/";
    private static final String PATH_SEPARATOR_ALIAS = ":";
    private static final int NORMAL = 0;
    private static final int SEEN_DOLLAR = 1;
    private static final int IN_BRACKET = 2;

    public static String replaceProperties(String string2) {
        return StringPropertyReplacer.replaceProperties(string2, null);
    }

    public static String replaceProperties(String string2, Properties props) {
        char[] chars = string2.toCharArray();
        StringBuffer buffer = new StringBuffer();
        boolean properties = false;
        int state = 0;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '$' && state != 2) {
                state = 1;
                continue;
            }
            if (c == '{' && state == 1) {
                buffer.append(string2.substring(start, i - 1));
                state = 2;
                start = i - 1;
                continue;
            }
            if (state == 1) {
                state = 0;
                continue;
            }
            if (c != '}' || state != 2) continue;
            if (start + 2 == i) {
                buffer.append("${}");
            } else {
                String value2 = null;
                String key2 = string2.substring(start + 2, i);
                if (FILE_SEPARATOR_ALIAS.equals(key2)) {
                    value2 = FILE_SEPARATOR;
                } else if (PATH_SEPARATOR_ALIAS.equals(key2)) {
                    value2 = PATH_SEPARATOR;
                } else {
                    value2 = props != null ? props.getProperty(key2) : System.getProperty(key2);
                    if (value2 == null) {
                        int colon2 = key2.indexOf(58);
                        if (colon2 > 0) {
                            String realKey = key2.substring(0, colon2);
                            value2 = props != null ? props.getProperty(realKey) : System.getProperty(realKey);
                            if (value2 == null && (value2 = StringPropertyReplacer.resolveCompositeKey(realKey, props)) == null) {
                                value2 = key2.substring(colon2 + 1);
                            }
                        } else {
                            value2 = StringPropertyReplacer.resolveCompositeKey(key2, props);
                        }
                    }
                }
                if (value2 != null) {
                    properties = true;
                    buffer.append(value2);
                } else {
                    buffer.append("${");
                    buffer.append(key2);
                    buffer.append('}');
                }
            }
            start = i + 1;
            state = 0;
        }
        if (!properties) {
            return string2;
        }
        if (start != chars.length) {
            buffer.append(string2.substring(start, chars.length));
        }
        return buffer.toString();
    }

    private static String resolveCompositeKey(String key2, Properties props) {
        String value2 = null;
        int comma = key2.indexOf(44);
        if (comma > -1) {
            if (comma > 0) {
                String key1 = key2.substring(0, comma);
                value2 = props != null ? props.getProperty(key1) : System.getProperty(key1);
            }
            if (value2 == null && comma < key2.length() - 1) {
                String key22 = key2.substring(comma + 1);
                value2 = props != null ? props.getProperty(key22) : System.getProperty(key22);
            }
        }
        return value2;
    }
}

