/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.util.JBossInterface;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.collection.ConcurrentReferenceHashMap;

public class JBossObject
implements JBossInterface {
    private static final Map<Class<?>, Logger> loggers = new ConcurrentReferenceHashMap();
    protected Logger log;
    protected transient SoftReference toString;
    protected transient int hashCode = Integer.MIN_VALUE;

    public JBossObject() {
        this.log = this.createLog();
    }

    public JBossObject(Logger log) {
        this.log = log != null ? log : this.createLog();
    }

    private Logger createLog() {
        Class<?> clazz = this.getClass();
        Logger logger = loggers.get(clazz);
        if (logger == null) {
            logger = Logger.getLogger(clazz);
            loggers.put(clazz, logger);
        }
        return logger;
    }

    public static boolean equals(Object one, Object two) {
        if (one == null && two != null) {
            return false;
        }
        return one == null || one.equals(two);
    }

    public static boolean notEqual(Object one, Object two) {
        return !JBossObject.equals(one, two);
    }

    public static void list(JBossStringBuilder buffer, Collection objects) {
        if (objects == null) {
            return;
        }
        buffer.append('[');
        if (!objects.isEmpty()) {
            Iterator i = objects.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                if (object instanceof JBossObject) {
                    ((JBossObject)object).toShortString(buffer);
                } else {
                    buffer.append(object.toString());
                }
                if (!i.hasNext()) continue;
                buffer.append(", ");
            }
        }
        buffer.append(']');
    }

    public String toString() {
        if (!this.cacheToString()) {
            return this.toStringImplementation();
        }
        String result2 = null;
        if (this.toString != null) {
            result2 = (String)this.toString.get();
        }
        if (result2 == null) {
            result2 = this.toStringImplementation();
            this.toString = new SoftReference<String>(result2);
        }
        return result2;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE || !this.cacheGetHashCode()) {
            this.hashCode = this.getHashCode();
        }
        return this.hashCode;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toShortString() {
        JBossStringBuilder buffer = new JBossStringBuilder();
        this.toShortString(buffer);
        return buffer.toString();
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
    }

    public String getClassShortName() {
        String longName = this.getClass().getName();
        int dot = longName.lastIndexOf(46);
        if (dot != -1) {
            return longName.substring(dot + 1);
        }
        return longName;
    }

    protected String toStringImplementation() {
        JBossStringBuilder buffer = new JBossStringBuilder();
        buffer.append(this.getClassShortName()).append('@');
        buffer.append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append('{');
        this.toString(buffer);
        buffer.append('}');
        return buffer.toString();
    }

    protected void flushJBossObjectCache() {
        this.toString = null;
        this.hashCode = Integer.MIN_VALUE;
    }

    protected void toString(JBossStringBuilder buffer) {
    }

    protected int getHashCode() {
        return super.hashCode();
    }

    protected boolean cacheToString() {
        return true;
    }

    protected boolean cacheGetHashCode() {
        return true;
    }
}

