/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.Serializable;

public class Counter
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7736259185393081556L;
    private int count;

    public Counter(int count2) {
        this.count = count2;
    }

    public Counter() {
    }

    public int increment() {
        return ++this.count;
    }

    public int decrement() {
        return --this.count;
    }

    public int getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return ((Counter)obj).count == this.count;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.count);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static Counter makeSynchronized(Counter counter) {
        return new Wrapper(counter){
            private static final long serialVersionUID = -6024309396861726945L;

            @Override
            public synchronized int increment() {
                return this.counter.increment();
            }

            @Override
            public synchronized int decrement() {
                return this.counter.decrement();
            }

            @Override
            public synchronized int getCount() {
                return this.counter.getCount();
            }

            @Override
            public synchronized void reset() {
                this.counter.reset();
            }

            public synchronized int hashCode() {
                return this.counter.hashCode();
            }

            @Override
            public synchronized boolean equals(Object obj) {
                return this.counter.equals(obj);
            }

            @Override
            public synchronized String toString() {
                return this.counter.toString();
            }

            @Override
            public synchronized Object clone() {
                return this.counter.clone();
            }
        };
    }

    public static Counter makeDirectional(Counter counter, boolean increasing) {
        Wrapper temp = increasing ? new Wrapper(counter){
            private static final long serialVersionUID = 2161377898611431781L;

            @Override
            public int decrement() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void reset() {
                throw new UnsupportedOperationException();
            }
        } : new Wrapper(counter){
            private static final long serialVersionUID = -4683457706354663230L;

            @Override
            public int increment() {
                throw new UnsupportedOperationException();
            }
        };
        return temp;
    }

    private static class Wrapper
    extends Counter {
        private static final long serialVersionUID = -1803971437884946242L;
        protected final Counter counter;

        public Wrapper(Counter counter) {
            this.counter = counter;
        }

        @Override
        public int increment() {
            return this.counter.increment();
        }

        @Override
        public int decrement() {
            return this.counter.decrement();
        }

        @Override
        public int getCount() {
            return this.counter.getCount();
        }

        @Override
        public void reset() {
            this.counter.reset();
        }

        @Override
        public boolean equals(Object obj) {
            return this.counter.equals(obj);
        }

        @Override
        public String toString() {
            return this.counter.toString();
        }

        @Override
        public Object clone() {
            return this.counter.clone();
        }
    }
}

