/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.ToString;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.CanonicalASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class ToStringASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = ToString.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode STRINGBUILDER_TYPE = ClassHelper.make(StringBuilder.class);
    private static final ClassNode INVOKER_TYPE = ClassHelper.make(InvokerHelper.class);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            boolean includePackage;
            ClassNode cNode = (ClassNode)parent;
            if (!this.checkNotInterface(cNode, MY_TYPE_NAME)) {
                return;
            }
            boolean includeSuper = this.memberHasValue(anno, "includeSuper", true);
            boolean cacheToString = this.memberHasValue(anno, "cache", true);
            if (includeSuper && cNode.getSuperClass().getName().equals("java.lang.Object")) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: includeSuper=true but '" + cNode.getName() + "' has no super class.", anno);
            }
            boolean includeNames = this.memberHasValue(anno, "includeNames", true);
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            List<String> excludes = this.getMemberList(anno, "excludes");
            List<String> includes = this.getMemberList(anno, "includes");
            boolean ignoreNulls = this.memberHasValue(anno, "ignoreNulls", true);
            boolean bl = includePackage = !this.memberHasValue(anno, "includePackage", false);
            if (this.hasAnnotation(cNode, CanonicalASTTransformation.MY_TYPE)) {
                AnnotationNode canonical = cNode.getAnnotations(CanonicalASTTransformation.MY_TYPE).get(0);
                if (excludes == null || excludes.isEmpty()) {
                    excludes = this.getMemberList(canonical, "excludes");
                }
                if (includes == null || includes.isEmpty()) {
                    includes = this.getMemberList(canonical, "includes");
                }
            }
            if (!this.checkIncludeExclude(anno, excludes, includes, MY_TYPE_NAME)) {
                return;
            }
            ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes, includeNames, ignoreNulls, includePackage, cacheToString);
        }
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes, includeNames, false);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames, boolean ignoreNulls) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes, includeNames, ignoreNulls, true);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames, boolean ignoreNulls, boolean includePackage) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes, includeNames, ignoreNulls, includePackage, false);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames, boolean ignoreNulls, boolean includePackage, boolean cache) {
        Expression tempToString;
        boolean hasExistingToString = GeneralUtils.hasDeclaredMethod(cNode, "toString", 0);
        if (hasExistingToString && GeneralUtils.hasDeclaredMethod(cNode, "_toString", 0)) {
            return;
        }
        BlockStatement body = new BlockStatement();
        if (cache) {
            FieldNode cacheField = cNode.addField("$to$string", 4098, ClassHelper.STRING_TYPE, null);
            VariableExpression savedToString = GeneralUtils.varX(cacheField);
            body.addStatement(GeneralUtils.ifS((Expression)GeneralUtils.equalsNullX(savedToString), GeneralUtils.assignS(savedToString, ToStringASTTransformation.calculateToStringStatements(cNode, includeSuper, includeFields, excludes, includes, includeNames, ignoreNulls, includePackage, body))));
            tempToString = savedToString;
        } else {
            tempToString = ToStringASTTransformation.calculateToStringStatements(cNode, includeSuper, includeFields, excludes, includes, includeNames, ignoreNulls, includePackage, body);
        }
        body.addStatement(GeneralUtils.returnS(tempToString));
        cNode.addMethod(new MethodNode(hasExistingToString ? "_toString" : "toString", hasExistingToString ? 2 : 1, ClassHelper.STRING_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body));
    }

    private static Expression calculateToStringStatements(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames, boolean ignoreNulls, boolean includePackage, BlockStatement body) {
        VariableExpression result2 = GeneralUtils.varX("_result");
        body.addStatement(GeneralUtils.declS(result2, GeneralUtils.ctorX(STRINGBUILDER_TYPE)));
        VariableExpression first = GeneralUtils.varX("$toStringFirst");
        body.addStatement(GeneralUtils.declS(first, GeneralUtils.constX(Boolean.TRUE)));
        String className = includePackage ? cNode.getName() : cNode.getNameWithoutPackage();
        body.addStatement(ToStringASTTransformation.appendS(result2, GeneralUtils.constX(className + "(")));
        List<PropertyNode> pList = GeneralUtils.getInstanceProperties(cNode);
        for (PropertyNode pNode : pList) {
            if (ToStringASTTransformation.shouldSkip(pNode.getName(), excludes, includes)) continue;
            StaticMethodCallExpression getter2 = GeneralUtils.callX(INVOKER_TYPE, "getProperty", (Expression)GeneralUtils.args(GeneralUtils.varX("this"), GeneralUtils.constX(pNode.getName())));
            ToStringASTTransformation.appendValue(body, result2, first, getter2, pNode.getName(), includeNames, ignoreNulls);
        }
        if (includeFields) {
            ArrayList<FieldNode> fList = new ArrayList<FieldNode>();
            fList.addAll(GeneralUtils.getInstanceNonPropertyFields(cNode));
            for (FieldNode fNode : fList) {
                if (ToStringASTTransformation.shouldSkip(fNode.getName(), excludes, includes)) continue;
                ToStringASTTransformation.appendValue(body, result2, first, GeneralUtils.varX(fNode), fNode.getName(), includeNames, ignoreNulls);
            }
        }
        if (includeSuper) {
            ToStringASTTransformation.appendCommaIfNotFirst(body, result2, first);
            ToStringASTTransformation.appendPrefix(body, result2, "super", includeNames);
            body.addStatement(ToStringASTTransformation.appendS(result2, GeneralUtils.callSuperX("toString")));
        }
        body.addStatement(ToStringASTTransformation.appendS(result2, GeneralUtils.constX(")")));
        MethodCallExpression toString2 = GeneralUtils.callX(result2, "toString");
        toString2.setImplicitThis(false);
        return toString2;
    }

    private static void appendValue(BlockStatement body, Expression result2, VariableExpression first, Expression value2, String name, boolean includeNames, boolean ignoreNulls) {
        BlockStatement thenBlock = new BlockStatement();
        BlockStatement appendValue = ignoreNulls ? GeneralUtils.ifS((Expression)GeneralUtils.notNullX(value2), thenBlock) : thenBlock;
        ToStringASTTransformation.appendCommaIfNotFirst(thenBlock, result2, first);
        ToStringASTTransformation.appendPrefix(thenBlock, result2, name, includeNames);
        thenBlock.addStatement(GeneralUtils.ifElseS(GeneralUtils.sameX(value2, VariableExpression.THIS_EXPRESSION), ToStringASTTransformation.appendS(result2, GeneralUtils.constX("(this)")), ToStringASTTransformation.appendS(result2, GeneralUtils.callX(INVOKER_TYPE, "toString", value2))));
        body.addStatement(appendValue);
    }

    private static void appendCommaIfNotFirst(BlockStatement body, Expression result2, VariableExpression first) {
        body.addStatement(GeneralUtils.ifElseS(first, GeneralUtils.assignS(first, ConstantExpression.FALSE), ToStringASTTransformation.appendS(result2, GeneralUtils.constX(", "))));
    }

    private static void appendPrefix(BlockStatement body, Expression result2, String name, boolean includeNames) {
        if (includeNames) {
            body.addStatement(ToStringASTTransformation.toStringPropertyName(result2, name));
        }
    }

    private static Statement toStringPropertyName(Expression result2, String fName) {
        BlockStatement body = new BlockStatement();
        body.addStatement(ToStringASTTransformation.appendS(result2, GeneralUtils.constX(fName + ":")));
        return body;
    }

    private static Statement appendS(Expression result2, Expression expr) {
        MethodCallExpression append2 = GeneralUtils.callX(result2, "append", expr);
        append2.setImplicitThis(false);
        return GeneralUtils.stmt(append2);
    }
}

