/*
 * Decompiled with CFR 0.152.
 */
package heros.utilities;

import com.google.common.collect.Maps;
import heros.utilities.DefaultValueMap;
import heros.utilities.JsonArray;
import java.util.Map;

public class JsonDocument {
    private DefaultValueMap<String, JsonDocument> documents = new DefaultValueMap<String, JsonDocument>(){

        @Override
        protected JsonDocument createItem(String key2) {
            return new JsonDocument();
        }
    };
    private DefaultValueMap<String, JsonArray> arrays = new DefaultValueMap<String, JsonArray>(){

        @Override
        protected JsonArray createItem(String key2) {
            return new JsonArray();
        }
    };
    private Map<String, String> keyValuePairs = Maps.newHashMap();

    public JsonDocument doc(String key2) {
        return this.documents.getOrCreate(key2);
    }

    public JsonDocument doc(String key2, JsonDocument doc) {
        if (this.documents.containsKey(key2)) {
            throw new IllegalArgumentException("There is already a document registered for key: " + key2);
        }
        this.documents.put(key2, doc);
        return doc;
    }

    public JsonArray array(String key2) {
        return this.arrays.getOrCreate(key2);
    }

    public void keyValue(String key2, String value2) {
        this.keyValuePairs.put(key2, value2);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.write(builder, 0);
        return builder.toString();
    }

    public void write(StringBuilder builder, int tabs) {
        builder.append("{\n");
        for (Map.Entry<String, String> entry2 : this.keyValuePairs.entrySet()) {
            JsonDocument.tabs(tabs + 1, builder);
            builder.append("\"" + entry2.getKey() + "\": \"" + entry2.getValue() + "\",\n");
        }
        for (Map.Entry<String, Object> entry3 : this.arrays.entrySet()) {
            JsonDocument.tabs(tabs + 1, builder);
            builder.append("\"" + entry3.getKey() + "\": ");
            ((JsonArray)entry3.getValue()).write(builder, tabs + 1);
            builder.append(",\n");
        }
        for (Map.Entry<String, Object> entry4 : this.documents.entrySet()) {
            JsonDocument.tabs(tabs + 1, builder);
            builder.append("\"" + entry4.getKey() + "\": ");
            ((JsonDocument)entry4.getValue()).write(builder, tabs + 1);
            builder.append(",\n");
        }
        if (!(this.keyValuePairs.isEmpty() && this.arrays.isEmpty() && this.documents.isEmpty())) {
            builder.delete(builder.length() - 2, builder.length() - 1);
        }
        JsonDocument.tabs(tabs, builder);
        builder.append("}");
    }

    static void tabs(int tabs, StringBuilder builder) {
        for (int i = 0; i < tabs; ++i) {
            builder.append("\t");
        }
    }
}

