/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens.structs;

import heros.fieldsens.AccessPath;
import heros.fieldsens.FlowFunction;
import heros.fieldsens.Resolver;

public class WrappedFact<Field, Fact, Stmt, Method> {
    private final Fact fact;
    private final AccessPath<Field> accessPath;
    private final Resolver<Field, Fact, Stmt, Method> resolver;

    public WrappedFact(Fact fact, AccessPath<Field> accessPath, Resolver<Field, Fact, Stmt, Method> resolver) {
        assert (fact != null);
        assert (accessPath != null);
        assert (resolver != null);
        this.fact = fact;
        this.accessPath = accessPath;
        this.resolver = resolver;
    }

    public Fact getFact() {
        return this.fact;
    }

    public WrappedFact<Field, Fact, Stmt, Method> applyDelta(AccessPath.Delta<Field> delta) {
        return new WrappedFact<Field, Fact, Stmt, Method>(this.fact, delta.applyTo(this.accessPath), this.resolver);
    }

    public AccessPath<Field> getAccessPath() {
        return this.accessPath;
    }

    public WrappedFact<Field, Fact, Stmt, Method> applyConstraint(FlowFunction.Constraint<Field> constraint, Fact zeroValue) {
        if (this.fact.equals(zeroValue)) {
            return this;
        }
        return new WrappedFact<Field, Fact, Stmt, Method>(this.fact, constraint.applyToAccessPath(this.accessPath), this.resolver);
    }

    public String toString() {
        String result2 = this.fact.toString() + this.accessPath;
        if (this.resolver != null) {
            result2 = result2 + this.resolver.toString();
        }
        return result2;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.accessPath == null ? 0 : this.accessPath.hashCode());
        result2 = 31 * result2 + (this.fact == null ? 0 : this.fact.hashCode());
        result2 = 31 * result2 + (this.resolver == null ? 0 : this.resolver.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WrappedFact other = (WrappedFact)obj;
        if (this.accessPath == null ? other.accessPath != null : !this.accessPath.equals(other.accessPath)) {
            return false;
        }
        if (this.fact == null ? other.fact != null : !this.fact.equals(other.fact)) {
            return false;
        }
        return !(this.resolver == null ? other.resolver != null : !this.resolver.equals(other.resolver));
    }

    public Resolver<Field, Fact, Stmt, Method> getResolver() {
        return this.resolver;
    }
}

