/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import heros.fieldsens.AccessPath;
import heros.fieldsens.CallEdgeResolver;
import heros.fieldsens.FactMergeHandler;
import heros.fieldsens.InterestCallback;
import heros.fieldsens.PerAccessPathMethodAnalyzer;
import heros.fieldsens.Resolver;
import heros.fieldsens.ResolverTemplate;
import heros.fieldsens.structs.DeltaConstraint;
import heros.fieldsens.structs.ReturnEdge;
import heros.fieldsens.structs.WrappedFact;
import heros.fieldsens.structs.WrappedFactAtStatement;

public class ReturnSiteResolver<Field, Fact, Stmt, Method>
extends ResolverTemplate<Field, Fact, Stmt, Method, ReturnEdge<Field, Fact, Stmt, Method>> {
    private Stmt returnSite;
    private AccessPath<Field> resolvedAccPath;
    private boolean propagated = false;
    private Fact sourceFact;
    private FactMergeHandler<Fact> factMergeHandler;

    public ReturnSiteResolver(FactMergeHandler<Fact> factMergeHandler, PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, Stmt returnSite) {
        this(factMergeHandler, analyzer, returnSite, null, new AccessPath(), null);
        this.factMergeHandler = factMergeHandler;
        this.propagated = false;
    }

    private ReturnSiteResolver(FactMergeHandler<Fact> factMergeHandler, PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, Stmt returnSite, Fact sourceFact, AccessPath<Field> resolvedAccPath, ReturnSiteResolver<Field, Fact, Stmt, Method> parent) {
        super(analyzer, parent);
        this.factMergeHandler = factMergeHandler;
        this.returnSite = returnSite;
        this.sourceFact = sourceFact;
        this.resolvedAccPath = resolvedAccPath;
        this.propagated = true;
    }

    public String toString() {
        return "<" + this.resolvedAccPath + ":" + this.returnSite + ">";
    }

    @Override
    public AccessPath<Field> getResolvedAccessPath() {
        return this.resolvedAccPath;
    }

    @Override
    protected AccessPath<Field> getAccessPathOf(ReturnEdge<Field, Fact, Stmt, Method> inc) {
        return inc.incAccessPath;
    }

    public void addIncoming(WrappedFact<Field, Fact, Stmt, Method> fact, Resolver<Field, Fact, Stmt, Method> resolverAtCaller, AccessPath.Delta<Field> callDelta) {
        this.addIncoming(new ReturnEdge<Field, Fact, Stmt, Method>(fact, resolverAtCaller, callDelta));
    }

    @Override
    protected void processIncomingGuaranteedPrefix(ReturnEdge<Field, Fact, Stmt, Method> retEdge) {
        if (this.propagated) {
            this.factMergeHandler.merge(this.sourceFact, retEdge.incFact);
        } else {
            this.propagated = true;
            this.sourceFact = retEdge.incFact;
            this.analyzer.scheduleEdgeTo(new WrappedFactAtStatement(this.returnSite, new WrappedFact(retEdge.incFact, new AccessPath(), this)));
        }
    }

    @Override
    protected void processIncomingPotentialPrefix(ReturnEdge<Field, Fact, Stmt, Method> retEdge) {
        this.log("Incoming potential prefix:  " + retEdge);
        this.resolveViaDelta(retEdge);
    }

    @Override
    protected void log(String message) {
        this.analyzer.log("Return Site " + this.toString() + ": " + message);
    }

    @Override
    protected ResolverTemplate<Field, Fact, Stmt, Method, ReturnEdge<Field, Fact, Stmt, Method>> createNestedResolver(AccessPath<Field> newAccPath) {
        return new ReturnSiteResolver<Field, Fact, Stmt, Method>(this.factMergeHandler, this.analyzer, this.returnSite, this.sourceFact, newAccPath, this);
    }

    public Stmt getReturnSite() {
        return this.returnSite;
    }

    private void resolveViaDelta(final ReturnEdge<Field, Fact, Stmt, Method> retEdge) {
        if (retEdge.incResolver == null || retEdge.incResolver instanceof CallEdgeResolver) {
            this.resolveViaDeltaAndPotentiallyDelegateToCallSite(retEdge);
        } else {
            AccessPath.Delta delta = retEdge.usedAccessPathOfIncResolver.applyTo(retEdge.incAccessPath).getDeltaTo(this.getResolvedAccessPath());
            assert (delta.accesses.length <= 1);
            retEdge.incResolver.resolve(new DeltaConstraint(delta), new InterestCallback<Field, Fact, Stmt, Method>(){

                @Override
                public void interest(PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, Resolver<Field, Fact, Stmt, Method> resolver) {
                    ReturnSiteResolver.this.incomingEdges.add(retEdge.copyWithIncomingResolver(resolver, retEdge.incAccessPath.getDeltaTo(ReturnSiteResolver.this.getResolvedAccessPath())));
                    ReturnSiteResolver.this.interest();
                }

                @Override
                public void canBeResolvedEmpty() {
                    ReturnSiteResolver.this.resolveViaDeltaAndPotentiallyDelegateToCallSite(retEdge);
                }
            });
        }
    }

    private void resolveViaDeltaAndPotentiallyDelegateToCallSite(ReturnEdge<Field, Fact, Stmt, Method> retEdge) {
        AccessPath currAccPath = retEdge.callDelta.applyTo(retEdge.usedAccessPathOfIncResolver.applyTo(retEdge.incAccessPath));
        if (this.getResolvedAccessPath().isPrefixOf(currAccPath) == AccessPath.PrefixTestResult.GUARANTEED_PREFIX) {
            this.incomingEdges.add(retEdge.copyWithIncomingResolver(null, retEdge.usedAccessPathOfIncResolver));
            this.interest();
        } else if (currAccPath.isPrefixOf(this.getResolvedAccessPath()).atLeast(AccessPath.PrefixTestResult.POTENTIAL_PREFIX)) {
            this.resolveViaCallSiteResolver(retEdge, currAccPath);
        }
    }

    protected void resolveViaCallSiteResolver(final ReturnEdge<Field, Fact, Stmt, Method> retEdge, AccessPath<Field> currAccPath) {
        if (retEdge.resolverAtCaller == null || retEdge.resolverAtCaller instanceof CallEdgeResolver) {
            this.canBeResolvedEmpty();
        } else {
            retEdge.resolverAtCaller.resolve(new DeltaConstraint<Field>(currAccPath.getDeltaTo(this.getResolvedAccessPath())), new InterestCallback<Field, Fact, Stmt, Method>(){

                @Override
                public void interest(PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, Resolver<Field, Fact, Stmt, Method> resolver) {
                    ReturnSiteResolver.this.incomingEdges.add(retEdge.copyWithResolverAtCaller(resolver, retEdge.incAccessPath.getDeltaTo(ReturnSiteResolver.this.getResolvedAccessPath())));
                    ReturnSiteResolver.this.interest();
                }

                @Override
                public void canBeResolvedEmpty() {
                    ReturnSiteResolver.this.canBeResolvedEmpty();
                }
            });
        }
    }
}

