/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import heros.fieldsens.AccessPath;
import heros.fieldsens.FlowFunction;
import heros.fieldsens.InterestCallback;
import heros.fieldsens.PerAccessPathMethodAnalyzer;
import heros.fieldsens.Resolver;
import java.util.Map;
import java.util.Set;

public abstract class ResolverTemplate<Field, Fact, Stmt, Method, Incoming>
extends Resolver<Field, Fact, Stmt, Method> {
    private boolean recursionLock = false;
    protected Set<Incoming> incomingEdges = Sets.newHashSet();
    private ResolverTemplate<Field, Fact, Stmt, Method, Incoming> parent;
    private Map<AccessPath<Field>, ResolverTemplate<Field, Fact, Stmt, Method, Incoming>> nestedResolvers = Maps.newHashMap();

    public ResolverTemplate(PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, ResolverTemplate<Field, Fact, Stmt, Method, Incoming> parent) {
        super(analyzer);
        this.parent = parent;
    }

    protected boolean isLocked() {
        if (this.recursionLock) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.isLocked();
    }

    protected void lock() {
        this.recursionLock = true;
    }

    protected void unlock() {
        this.recursionLock = false;
    }

    protected abstract AccessPath<Field> getResolvedAccessPath();

    protected abstract AccessPath<Field> getAccessPathOf(Incoming var1);

    public void addIncoming(Incoming inc) {
        if (this.getResolvedAccessPath().isPrefixOf(this.getAccessPathOf(inc)) == AccessPath.PrefixTestResult.GUARANTEED_PREFIX) {
            this.log("Incoming Edge: " + inc);
            if (!this.incomingEdges.add(inc)) {
                return;
            }
            this.interest();
            for (ResolverTemplate<Field, Fact, Stmt, Method, Incoming> nestedResolver : this.nestedResolvers.values()) {
                nestedResolver.addIncoming(inc);
            }
            this.processIncomingGuaranteedPrefix(inc);
        } else if (this.getAccessPathOf(inc).isPrefixOf(this.getResolvedAccessPath()).atLeast(AccessPath.PrefixTestResult.POTENTIAL_PREFIX)) {
            this.processIncomingPotentialPrefix(inc);
        }
    }

    protected abstract void processIncomingPotentialPrefix(Incoming var1);

    protected abstract void processIncomingGuaranteedPrefix(Incoming var1);

    @Override
    public void resolve(FlowFunction.Constraint<Field> constraint, InterestCallback<Field, Fact, Stmt, Method> callback) {
        this.log("Resolve: " + constraint);
        if (constraint.canBeAppliedTo(this.getResolvedAccessPath()) && !this.isLocked()) {
            AccessPath<Field> newAccPath = constraint.applyToAccessPath(this.getResolvedAccessPath());
            ResolverTemplate<Field, Fact, Stmt, Method, Incoming> nestedResolver = this.getOrCreateNestedResolver(newAccPath);
            assert (nestedResolver.getResolvedAccessPath().equals(constraint.applyToAccessPath(this.getResolvedAccessPath())));
            nestedResolver.registerCallback(callback);
        }
    }

    protected ResolverTemplate<Field, Fact, Stmt, Method, Incoming> getOrCreateNestedResolver(AccessPath<Field> newAccPath) {
        if (this.getResolvedAccessPath().equals(newAccPath)) {
            return this;
        }
        if (!this.nestedResolvers.containsKey(newAccPath)) {
            assert (this.getResolvedAccessPath().getDeltaTo(newAccPath).accesses.length <= 1);
            ResolverTemplate<Field, Fact, Stmt, Method, Incoming> nestedResolver = this.createNestedResolver(newAccPath);
            this.nestedResolvers.put(newAccPath, nestedResolver);
            for (Incoming inc : this.incomingEdges) {
                nestedResolver.addIncoming(inc);
            }
        }
        return this.nestedResolvers.get(newAccPath);
    }

    protected abstract ResolverTemplate<Field, Fact, Stmt, Method, Incoming> createNestedResolver(AccessPath<Field> var1);
}

