/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import heros.fieldsens.AccessPath;
import heros.fieldsens.FactMergeHandler;
import heros.fieldsens.InterestCallback;
import heros.fieldsens.PerAccessPathMethodAnalyzer;
import heros.fieldsens.Resolver;
import heros.fieldsens.ResolverTemplate;
import heros.fieldsens.structs.DeltaConstraint;
import heros.fieldsens.structs.WrappedFact;
import heros.fieldsens.structs.WrappedFactAtStatement;

public class ControlFlowJoinResolver<Field, Fact, Stmt, Method>
extends ResolverTemplate<Field, Fact, Stmt, Method, WrappedFact<Field, Fact, Stmt, Method>> {
    private Stmt joinStmt;
    private AccessPath<Field> resolvedAccPath;
    private boolean propagated = false;
    private Fact sourceFact;
    private FactMergeHandler<Fact> factMergeHandler;

    public ControlFlowJoinResolver(FactMergeHandler<Fact> factMergeHandler, PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, Stmt joinStmt) {
        this(factMergeHandler, analyzer, joinStmt, null, new AccessPath(), null);
        this.factMergeHandler = factMergeHandler;
        this.propagated = false;
    }

    private ControlFlowJoinResolver(FactMergeHandler<Fact> factMergeHandler, PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, Stmt joinStmt, Fact sourceFact, AccessPath<Field> resolvedAccPath, ControlFlowJoinResolver<Field, Fact, Stmt, Method> parent) {
        super(analyzer, parent);
        this.factMergeHandler = factMergeHandler;
        this.joinStmt = joinStmt;
        this.sourceFact = sourceFact;
        this.resolvedAccPath = resolvedAccPath;
        this.propagated = true;
    }

    @Override
    protected AccessPath<Field> getAccessPathOf(WrappedFact<Field, Fact, Stmt, Method> inc) {
        return inc.getAccessPath();
    }

    @Override
    protected void processIncomingGuaranteedPrefix(WrappedFact<Field, Fact, Stmt, Method> fact) {
        if (this.propagated) {
            this.factMergeHandler.merge(this.sourceFact, fact.getFact());
        } else {
            this.propagated = true;
            this.sourceFact = fact.getFact();
            this.analyzer.processFlowFromJoinStmt(new WrappedFactAtStatement(this.joinStmt, new WrappedFact(fact.getFact(), new AccessPath(), this)));
        }
    }

    @Override
    protected void processIncomingPotentialPrefix(WrappedFact<Field, Fact, Stmt, Method> fact) {
        this.lock();
        AccessPath.Delta<Field> delta = fact.getAccessPath().getDeltaTo(this.resolvedAccPath);
        fact.getResolver().resolve(new DeltaConstraint<Field>(delta), new InterestCallback<Field, Fact, Stmt, Method>(){

            @Override
            public void interest(PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, Resolver<Field, Fact, Stmt, Method> resolver) {
                ControlFlowJoinResolver.this.interest();
            }

            @Override
            public void canBeResolvedEmpty() {
                ControlFlowJoinResolver.this.canBeResolvedEmpty();
            }
        });
        this.unlock();
    }

    @Override
    protected ResolverTemplate<Field, Fact, Stmt, Method, WrappedFact<Field, Fact, Stmt, Method>> createNestedResolver(AccessPath<Field> newAccPath) {
        return new ControlFlowJoinResolver<Field, Fact, Stmt, Method>(this.factMergeHandler, this.analyzer, this.joinStmt, this.sourceFact, newAccPath, this);
    }

    @Override
    protected void log(String message) {
        this.analyzer.log("Join Stmt " + this.toString() + ": " + message);
    }

    public String toString() {
        return "<" + this.resolvedAccPath + ":" + this.joinStmt + ">";
    }

    @Override
    public AccessPath<Field> getResolvedAccessPath() {
        return this.resolvedAccPath;
    }

    public Stmt getJoinStmt() {
        return this.joinStmt;
    }
}

