/*
 * Decompiled with CFR 0.152.
 */
package groovy.servlet;

import groovy.lang.Closure;
import groovy.servlet.AbstractHttpServlet;
import groovy.servlet.ServletBinding;
import groovy.servlet.ServletCategory;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.runtime.GroovyCategorySupport;

public class GroovyServlet
extends AbstractHttpServlet {
    private GroovyScriptEngine gse;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.gse = this.createGroovyScriptEngine();
        this.servletContext.log("Groovy servlet initialized on " + this.gse + ".");
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        final String scriptUri = this.getScriptUri(request);
        response.setContentType("text/html; charset=" + this.encoding);
        final ServletBinding binding = new ServletBinding(request, response, this.servletContext);
        this.setVariables(binding);
        try {
            Closure closure = new Closure(this.gse){

                @Override
                public Object call() {
                    try {
                        return ((GroovyScriptEngine)this.getDelegate()).run(scriptUri, binding);
                    }
                    catch (ResourceException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ScriptException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            GroovyCategorySupport.use(ServletCategory.class, closure);
        }
        catch (RuntimeException runtimeException) {
            StringBuilder error2 = new StringBuilder("GroovyServlet Error: ");
            error2.append(" script: '");
            error2.append(scriptUri);
            error2.append("': ");
            Throwable e = runtimeException.getCause();
            if (e == null) {
                error2.append(" Script processing failed.\n");
                error2.append(runtimeException.getMessage());
                if (runtimeException.getStackTrace().length > 0) {
                    error2.append(runtimeException.getStackTrace()[0].toString());
                }
                this.servletContext.log(error2.toString());
                System.err.println(error2.toString());
                runtimeException.printStackTrace(System.err);
                response.sendError(500, error2.toString());
                return;
            }
            if (e instanceof ResourceException) {
                error2.append(" Script not found, sending 404.");
                this.servletContext.log(error2.toString());
                System.err.println(error2.toString());
                response.sendError(404);
                return;
            }
            this.servletContext.log("An error occurred processing the request", (Throwable)runtimeException);
            error2.append(e.getMessage());
            if (e.getStackTrace().length > 0) {
                error2.append(e.getStackTrace()[0].toString());
            }
            this.servletContext.log(e.toString());
            System.err.println(e.toString());
            runtimeException.printStackTrace(System.err);
            response.sendError(500, e.toString());
        }
    }

    protected GroovyScriptEngine createGroovyScriptEngine() {
        return new GroovyScriptEngine(this);
    }
}

