/*
 * Decompiled with CFR 0.152.
 */
package groovy.json.internal;

import groovy.json.internal.LazyValueMap;
import groovy.json.internal.Value;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ValueList
extends AbstractList<Object>
implements List<Object> {
    List<Object> list = new ArrayList<Object>(5);
    private final boolean lazyChop;
    boolean converted = false;

    public ValueList(boolean lazyChop) {
        this.lazyChop = lazyChop;
    }

    @Override
    public Object get(int index) {
        Object obj = this.list.get(index);
        if (obj instanceof Value) {
            obj = this.convert((Value)obj);
            this.list.set(index, obj);
        }
        this.chopIfNeeded(obj);
        return obj;
    }

    private Object convert(Value value2) {
        return value2.toValue();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<Object> iterator() {
        this.convertAllIfNeeded();
        return this.list.iterator();
    }

    private void convertAllIfNeeded() {
        if (!this.converted) {
            this.converted = true;
            for (int index = 0; index < this.list.size(); ++index) {
                this.get(index);
            }
        }
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean add(Object obj) {
        return this.list.add(obj);
    }

    public void chopList() {
        for (Object obj : this.list) {
            if (obj == null || !(obj instanceof Value)) continue;
            Value value2 = (Value)obj;
            if (value2.isContainer()) {
                this.chopContainer(value2);
                continue;
            }
            value2.chop();
        }
    }

    private void chopIfNeeded(Object object) {
        if (this.lazyChop) {
            if (object instanceof LazyValueMap) {
                LazyValueMap m = (LazyValueMap)object;
                m.chopMap();
            } else if (object instanceof ValueList) {
                ValueList list = (ValueList)object;
                list.chopList();
            }
        }
    }

    void chopContainer(Value value2) {
        Object obj = value2.toValue();
        if (obj instanceof LazyValueMap) {
            LazyValueMap map2 = (LazyValueMap)obj;
            map2.chopMap();
        } else if (obj instanceof ValueList) {
            ValueList list = (ValueList)obj;
            list.chopList();
        }
    }

    public List<Object> list() {
        return this.list;
    }
}

