/*
 * Decompiled with CFR 0.152.
 */
package groovy.json.internal;

import groovy.json.internal.Cache;
import groovy.json.internal.CacheType;
import java.util.LinkedHashMap;
import java.util.Map;

public class SimpleCache<K, V>
implements Cache<K, V> {
    Map<K, V> map = new LinkedHashMap();

    public SimpleCache(int limit, CacheType type) {
        this.map = type.equals((Object)CacheType.LRU) ? new InternalCacheLinkedList(limit, true) : new InternalCacheLinkedList(limit, false);
    }

    public SimpleCache(int limit) {
        this.map = new InternalCacheLinkedList(limit, true);
    }

    @Override
    public void put(K key2, V value2) {
        this.map.put(key2, value2);
    }

    @Override
    public V get(K key2) {
        return this.map.get(key2);
    }

    @Override
    public V getSilent(K key2) {
        V value2 = this.map.get(key2);
        if (value2 != null) {
            this.map.remove(key2);
            this.map.put(key2, value2);
        }
        return value2;
    }

    @Override
    public void remove(K key2) {
        this.map.remove(key2);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    private static class InternalCacheLinkedList<K, V>
    extends LinkedHashMap<K, V> {
        final int limit;

        InternalCacheLinkedList(int limit, boolean lru) {
            super(16, 0.75f, lru);
            this.limit = limit;
        }

        @Override
        protected final boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return super.size() > this.limit;
        }
    }
}

