/*
 * Decompiled with CFR 0.152.
 */
package groovy.json.internal;

import groovy.json.internal.CharBuf;
import groovy.json.internal.Exceptions;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class IO {
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharBuf read(Reader input2, CharBuf charBuf, int bufSize) {
        if (charBuf == null) {
            charBuf = CharBuf.create(bufSize);
        } else {
            charBuf.readForRecycle();
        }
        try {
            char[] buffer = charBuf.toCharArray();
            int size2 = input2.read(buffer);
            if (size2 != -1) {
                charBuf._len(size2);
            }
            if (size2 < 0) {
                CharBuf charBuf2 = charBuf;
                return charBuf2;
            }
            IO.copy(input2, charBuf);
        }
        catch (IOException e) {
            Exceptions.handle(e);
        }
        finally {
            try {
                input2.close();
            }
            catch (IOException e) {
                Exceptions.handle(e);
            }
        }
        return charBuf;
    }

    public static int copy(Reader input2, Writer output) {
        long count2 = IO.copyLarge(input2, output);
        if (count2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count2;
    }

    public static long copyLarge(Reader reader, Writer writer) {
        return IO.copyLarge(reader, writer, new char[4096]);
    }

    public static long copyLarge(Reader reader, Writer writer, char[] buffer) {
        long count2 = 0L;
        try {
            int n;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
                count2 += (long)n;
            }
        }
        catch (IOException e) {
            Exceptions.handle(e);
        }
        return count2;
    }
}

