/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Literal;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.rules.Rule;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class SimplifyAnd<K>
extends Rule<And<K>, K> {
    @Override
    public Expression<K> applyInternal(And<K> input2) {
        for (Expression expr : input2.expressions) {
            if (expr instanceof Literal) {
                Literal l = (Literal)expr;
                if (l.getValue()) {
                    return this.copyWithoutTrue(input2);
                }
                return Literal.getFalse();
            }
            if (!(expr instanceof Not)) continue;
            Expression notChild = ((Not)expr).getE();
            for (Expression child : input2.expressions) {
                if (!child.equals(notChild)) continue;
                return Literal.getFalse();
            }
        }
        return input2;
    }

    private Expression<K> copyWithoutTrue(And<K> input2) {
        ArrayList copy = Lists.newArrayList();
        for (Expression expr : input2.expressions) {
            Literal l;
            if (expr instanceof Literal && (l = (Literal)expr).getValue()) continue;
            copy.add(expr);
        }
        if (copy.isEmpty()) {
            return Literal.getTrue();
        }
        return And.of(copy);
    }

    @Override
    protected boolean isApply(Expression<K> input2) {
        return input2 instanceof And;
    }
}

