#! /usr/bin/env python
# coding:utf-8
from scapy.all import conf
from scapy.packet import *
from scapy.fields import *
from scapy.layers.inet import TCP, UDP
from icssploit.protocols.cip import CIPHeader


ENIP_COMMANDS = {
    0x0000: "NOP",
    0x0004: "List Services",
    0x0063: "List Identity",
    0x0064: "List Interfaces",
    0x0065: "Register Session",
    0x0066: "Unregister Session",
    0x006f: "Send RR Data",
    0x0070: "Send Unit Data",
    0x0072: "Indicate Status",
    0x0073: "Cancel"
}


ENIP_TYPE_IDS = {
    0x0000: "Null Address Item",
    0x000c: "List Identity Response",
    0x0086: "CIP Security Information",
    0x00a1: "Connected Address Item",
    0x00b1: "Connected Data Item",
    0x00b2: "Unconnected Data Item",
    0x0100: "List Services Response",
    0x8000: "Socket Address Info O->T",
    0x8001: "Socket Address Info T->O",
    0x8002: "Sequenced Address Item",
    0x8003: "Unconnected Message over UDP"
}


VENDOR_IDS = {
    0x0000: "Reserved(0x0000)",
    0x0001: "Rockwell Automation/Allen-Bradley(0x0001)",
    0x0002: "Namco Controls Corp.(0x0002)",
    0x0003: "Honeywell Inc.(0x0003)",
    0x0004: "Parker Hannifin Corp. (Veriflo Division)(0x0004)",
    0x0005: "Rockwell Automation/Reliance Elec.(0x0005)",
    0x0006: "Reserved(0x0006)",
    0x0007: "SMC Corporation(0x0007)",
    0x0008: "Molex Incorporated(0x0008)",
    0x0009: "Western Reserve Controls Corp.(0x0009)",
    0x000A: "Advanced Micro Controls Inc. (AMCI)(0x000A)",
    0x000B: "ASCO Pneumatic Controls(0x000B)",
    0x000C: "Banner Engineering Corp.(0x000C)",
    0x000D: "Belden Wire & Cable Company(0x000D)",
    0x000E: "Cooper Interconnect(0x000E)",
    0x000F: "Reserved(0x000F)",
    0x0010: "Daniel Woodhead Co. (Woodhead Connectivity)(0x0010)",
    0x0011: "Dearborn Group Inc.(0x0011)",
    0x0012: "Reserved(0x0012)",
    0x0013: "Helm Instrument Company(0x0013)",
    0x0014: "Huron Net Works(0x0014)",
    0x0015: "Lumberg Inc.(0x0015)",
    0x0016: "Online Development Inc.(Automation Value)(0x0016)",
    0x0017: "Vorne Industries Inc.(0x0017)",
    0x0018: "ODVA Special Reserve(0x0018)",
    0x0019: "Reserved(0x0019)",
    0x001A: "Festo Corporation(0x001A)",
    0x001B: "Reserved(0x001B)",
    0x001C: "Reserved(0x001C)",
    0x001D: "Reserved(0x001D)",
    0x001E: "Unico Inc.(0x001E)",
    0x001F: "Ross Controls(0x001F)",
    0x0020: "Reserved(0x0020)",
    0x0021: "Reserved(0x0021)",
    0x0022: "Hohner Corp.(0x0022)",
    0x0023: "Micro Mo Electronics Inc.(0x0023)",
    0x0024: "MKS Instruments Inc.(0x0024)",
    0x0025: "Yaskawa Electric America formerly Magnetek Drives(0x0025)",
    0x0026: "Reserved(0x0026)",
    0x0027: "AVG Automation (Uticor)(0x0027)",
    0x0028: "Wago Corporation(0x0028)",
    0x0029: "Kinetics (Unit Instruments)(0x0029)",
    0x002A: "IMI Norgren Limited(0x002A)",
    0x002B: "BALLUFF Inc.(0x002B)",
    0x002C: "Yaskawa Electric America Inc.(0x002C)",
    0x002D: "Eurotherm Controls Inc(0x002D)",
    0x002E: "ABB Industrial Systems(0x002E)",
    0x002F: "Omron Corporation(0x002F)",
    0x0030: "TURCk Inc.(0x0030)",
    0x0031: "Grayhill Inc.(0x0031)",
    0x0032: "Real Time Automation (C&ID)(0x0032)",
    0x0033: "Reserved(0x0033)",
    0x0034: "Numatics Inc.(0x0034)",
    0x0035: "Lutze Inc.(0x0035)",
    0x0036: "Reserved(0x0036)",
    0x0037: "Reserved(0x0037)",
    0x0038: "Softing GmbH(0x0038)",
    0x0039: "Pepperl + Fuchs(0x0039)",
    0x003A: "Spectrum Controls Inc.(0x003A)",
    0x003B: "D.I.P. Inc. MKS Inst.(0x003B)",
    0x003C: "Applied Motion Products Inc.(0x003C)",
    0x003D: "Sencon Inc.(0x003D)",
    0x003E: "High Country Tek(0x003E)",
    0x003F: "SWAC Automation Consult GmbH(0x003F)",
    0x0040: "Clippard Instrument Laboratory(0x0040)",
    0x0041: "Reserved(0x0041)",
    0x0042: "Reserved(0x0042)",
    0x0043: "Reserved(0x0043)",
    0x0044: "Eaton Electrical(0x0044)",
    0x0045: "Reserved(0x0045)",
    0x0046: "Reserved(0x0046)",
    0x0047: "Toshiba International Corp.(0x0047)",
    0x0048: "Control Technology Incorporated(0x0048)",
    0x0049: "TCS (NZ) Ltd.(0x0049)",
    0x004A: "HitachiLtd.(0x004A)",
    0x004B: "ABB Robotics Products AB(0x004B)",
    0x004C: "NKE Corporation(0x004C)",
    0x004D: "Rockwell Software Inc.(0x004D)",
    0x004E: "Escort Memory Systems (A Datalogic Group Co.)(0x004E)",
    0x004F: "Reserved(0x004F)",
    0x0050: "Industrial Devices Corporation(0x0050)",
    0x0051: "IXXAT Automation GmbH(0x0051)",
    0x0052: "Mitsubishi Electric Automation Inc.(0x0052)",
    0x0053: "OPTO-22(0x0053)",
    0x0054: "Reserved(0x0054)",
    0x0055: "Reserved(0x0055)",
    0x0056: "Horner Electric(0x0056)",
    0x0057: "Burkert Werke GmbH & Co. KG(0x0057)",
    0x0058: "Reserved(0x0058)",
    0x0059: "Industrial Indexing Systems Inc.(0x0059)",
    0x005A: "HMS Industrial Networks AB(0x005A)",
    0x005B: "Robicon(0x005B)",
    0x005C: "Helix Technology (Granville-Phillips)(0x005C)",
    0x005D: "Arlington Laboratory(0x005D)",
    0x005E: "Advantech Co. Ltd.(0x005E)",
    0x005F: "Square D Company(0x005F)",
    0x0060: "Digital Electronics Corp.(0x0060)",
    0x0061: "Danfoss(0x0061)",
    0x0062: "Reserved(0x0062)",
    0x0063: "Reserved(0x0063)",
    0x0064: "Bosch Rexroth Corporation: Pneumatics(0x0064)",
    0x0065: "Applied Materials Inc.(0x0065)",
    0x0066: "Showa Electric Wire & Cable Co.(0x0066)",
    0x0067: "Pacific Scientific (API Controls Inc.)(0x0067)",
    0x0068: "Sharp Manufacturing Systems Corp.(0x0068)",
    0x0069: "Olflex Wire & Cable Inc.(0x0069)",
    0x006A: "Reserved(0x006A)",
    0x006B: "Unitrode(0x006B)",
    0x006C: "Beckhoff Automation GmbH(0x006C)",
    0x006D: "National Instruments(0x006D)",
    0x006E: "Mykrolis Corporations (Millipore)(0x006E)",
    0x006F: "International Motion Controls Corp.(0x006F)",
    0x0070: "Reserved(0x0070)",
    0x0071: "SEG Kempen GmbH(0x0071)",
    0x0072: "Reserved(0x0072)",
    0x0073: "Reserved(0x0073)",
    0x0074: "MTS Systems Corp.(0x0074)",
    0x0075: "Krones Inc(0x0075)",
    0x0076: "Reserved(0x0076)",
    0x0077: "EXOR Electronic R & D(0x0077)",
    0x0078: "SIEI S.p.A.(0x0078)",
    0x0079: "KUKA Roboter GmbH(0x0079)",
    0x007A: "Reserved(0x007A)",
    0x007B: "SEC (Samsung Electronics Co.Ltd)(0x007B)",
    0x007C: "Binary Electronics Ltd(0x007C)",
    0x007D: "Flexible Machine Controls(0x007D)",
    0x007E: "Reserved(0x007E)",
    0x007F: "ABB Inc. (Entrelec)(0x007F)",
    0x0080: "MAC Valves Inc.(0x0080)",
    0x0081: "Auma Actuators Inc(0x0081)",
    0x0082: "Toyoda Machine WorksLtd(0x0082)",
    0x0083: "Reserved(0x0083)",
    0x0084: "Reserved(0x0084)",
    0x0085: "Balogh T.A.G.: Corporation(0x0085)",
    0x0086: "TR Systemtechnik GmbH(0x0086)",
    0x0087: "UNIPULSE Corporation(0x0087)",
    0x0088: "Reserved(0x0088)",
    0x0089: "Reserved(0x0089)",
    0x008A: "Conxall Corporation Inc.(0x008A)",
    0x008B: "Reserved(0x008B)",
    0x008C: "Reserved(0x008C)",
    0x008D: "Kuramo Electric Co.Ltd.(0x008D)",
    0x008E: "Creative Micro Designs(0x008E)",
    0x008F: "GE Industrial Systems(0x008F)",
    0x0090: "Leybold Vacuum GmbH(0x0090)",
    0x0091: "Siemens Energy & Automation/Drives(0x0091)",
    0x0092: "Kodensha Ltd(0x0092)",
    0x0093: "Motion Engineering Inc.(0x0093)",
    0x0094: "Honda Engineering Co.Ltd(0x0094)",
    0x0095: "EIM Valve Controls(0x0095)",
    0x0096: "Melec Inc.(0x0096)",
    0x0097: "Sony Manufacturing Systems Corporation(0x0097)",
    0x0098: "North American Mfg.(0x0098)",
    0x0099: "WATLOW(0x0099)",
    0x009A: "Japan Radio Co.Ltd(0x009A)",
    0x009B: "NADEX Co.Ltd(0x009B)",
    0x009C: "Ametek Automation & Process Technologies(0x009C)",
    0x009D: "Reserved(0x009D)",
    0x009E: "KVASER AB(0x009E)",
    0x009F: "IDEC IZUMI Corporation(0x009F)",
    0x00A0: "Mitsubishi Heavy Industries Ltd(0x00A0)",
    0x00A1: "Mitsubishi Electric Corporation(0x00A1)",
    0x00A2: "Horiba-STEC Inc.(0x00A2)",
    0x00A3: "esd electronic system design gmbh(0x00A3)",
    0x00A4: "DAIHEN Corporation(0x00A4)",
    0x00A5: "Tyco Valves & Controls/Keystone(0x00A5)",
    0x00A6: "EBARA Corporation(0x00A6)",
    0x00A7: "Reserved(0x00A7)",
    0x00A8: "Reserved(0x00A8)",
    0x00A9: "Hokuyo Electric Co. Ltd(0x00A9)",
    0x00AA: "Pyramid Solutions Inc.(0x00AA)",
    0x00AB: "Denso Wave Incorporated(0x00AB)",
    0x00AC: "HLS Hard-Line Solutions Inc(0x00AC)",
    0x00AD: "Caterpillar Inc.(0x00AD)",
    0x00AE: "PDL Electronics Ltd.(0x00AE)",
    0x00AF: "Reserved(0x00AF)",
    0x00B0: "Red Lion Controls(0x00B0)",
    0x00B1: "ANELVA Corporation(0x00B1)",
    0x00B2: "Toyo Denki Seizo KK(0x00B2)",
    0x00B3: "Sanyo Denki Co.Ltd(0x00B3)",
    0x00B4: "Advanced Energy Japan K.K. (Aera Japan)(0x00B4)",
    0x00B5: "Pilz GmbH & Co(0x00B5)",
    0x00B6: "Marsh Bellofram-Bellofram PCD Division(0x00B6)",
    0x00B7: "Reserved(0x00B7)",
    0x00B8: "M-SYSTEM Co. Ltd(0x00B8)",
    0x00B9: "Nissin Electric Co.Ltd(0x00B9)",
    0x00BA: "Hitachi Metals Ltd.(0x00BA)",
    0x00BB: "Oriental Motor Company(0x00BB)",
    0x00BC: "A&D Co.Ltd(0x00BC)",
    0x00BD: "Phasetronics Inc.(0x00BD)",
    0x00BE: "Cummins Engine Company(0x00BE)",
    0x00BF: "Deltron Inc.(0x00BF)",
    0x00C0: "Geneer Corporation(0x00C0)",
    0x00C1: "Anatol Automation Inc.(0x00C1)",
    0x00C2: "Reserved(0x00C2)",
    0x00C3: "Reserved(0x00C3)",
    0x00C4: "Medar Inc.(0x00C4)",
    0x00C5: "Comdel Inc.(0x00C5)",
    0x00C6: "Advanced Energy Industries Inc(0x00C6)",
    0x00C7: "Reserved(0x00C7)",
    0x00C8: "DAIDEN Co.Ltd(0x00C8)",
    0x00C9: "CKD Corporation(0x00C9)",
    0x00CA: "Toyo Electric Corporation(0x00CA)",
    0x00CB: "Reserved(0x00CB)",
    0x00CC: "AuCom Electronics Ltd(0x00CC)",
    0x00CD: "Shinko Electric Co.Ltd(0x00CD)",
    0x00CE: "Vector Informatik GmbH(0x00CE)",
    0x00CF: "Reserved(0x00CF)",
    0x00D0: "Moog Inc.(0x00D0)",
    0x00D1: "Contemporary Controls(0x00D1)",
    0x00D2: "Tokyo Sokki Kenkyujo Co.Ltd(0x00D2)",
    0x00D3: "Schenck-AccuRate Inc.(0x00D3)",
    0x00D4: "The Oilgear Company(0x00D4)",
    0x00D5: "Reserved(0x00D5)",
    0x00D6: "ASM Japan K.K.(0x00D6)",
    0x00D7: "HIRATA Corp.(0x00D7)",
    0x00D8: "SUNX Limited(0x00D8)",
    0x00D9: "Meidensha Corp.(0x00D9)",
    0x00DA: "NIDEC SANKYO CORPORATION (Sankyo Seiki Mfg. Co.Ltd)(0x00DA)",
    0x00DB: "KAMRO Corp.(0x00DB)",
    0x00DC: "Nippon System Development Co.Ltd(0x00DC)",
    0x00DD: "EBARA Technologies Inc.(0x00DD)",
    0x00DE: "Reserved(0x00DE)",
    0x00DF: "Reserved(0x00DF)",
    0x00E0: "SG Co.Ltd(0x00E0)",
    0x00E1: "Vaasa Institute of Technology(0x00E1)",
    0x00E2: "MKS Instruments (ENI Technology)(0x00E2)",
    0x00E3: "Tateyama System Laboratory Co.Ltd.(0x00E3)",
    0x00E4: "QLOG Corporation(0x00E4)",
    0x00E5: "Matric Limited Inc.(0x00E5)",
    0x00E6: "NSD Corporation(0x00E6)",
    0x00E7: "Reserved(0x00E7)",
    0x00E8: "Sumitomo Wiring SystemsLtd(0x00E8)",
    0x00E9: "Group 3 Technology Ltd(0x00E9)",
    0x00EA: "CTI Cryogenics(0x00EA)",
    0x00EB: "POLSYS CORP(0x00EB)",
    0x00EC: "Ampere Inc.(0x00EC)",
    0x00ED: "Reserved(0x00ED)",
    0x00EE: "Simplatroll Ltd(0x00EE)",
    0x00EF: "Reserved(0x00EF)",
    0x00F0: "Reserved(0x00F0)",
    0x00F1: "Leading Edge Design(0x00F1)",
    0x00F2: "Humphrey Products(0x00F2)",
    0x00F3: "Schneider Automation Inc.(0x00F3)",
    0x00F4: "Westlock Controls Corp.(0x00F4)",
    0x00F5: "Nihon Weidmuller Co.Ltd(0x00F5)",
    0x00F6: "Brooks Instrument (Div. of Emerson)(0x00F6)",
    0x00F7: "Reserved(0x00F7)",
    0x00F8: " Moeller GmbH(0x00F8)",
    0x00F9: "Varian Vacuum Products(0x00F9)",
    0x00FA: "Yokogawa Electric Corporation(0x00FA)",
    0x00FB: "Electrical Design Daiyu Co.Ltd(0x00FB)",
    0x00FC: "Omron Software Co.Ltd(0x00FC)",
    0x00FD: "BOC Edwards(0x00FD)",
    0x00FE: "Control Technology Corporation(0x00FE)",
    0x00FF: "Bosch Rexroth(0x00FF)",
    0x0100: "Turck(0x0100)",
    0x0101: "Control Techniques PLC(0x0101)",
    0x0102: "Hardy Instruments Inc.(0x0102)",
    0x0103: "LS Industrial Systems(0x0103)",
    0x0104: "E.O.A. Systems Inc.(0x0104)",
    0x0105: "Reserved(0x0105)",
    0x0106: "New Cosmos Electric Co.Ltd.(0x0106)",
    0x0107: "Sense Eletronica LTDA(0x0107)",
    0x0108: "Xycom Inc.(0x0108)",
    0x0109: "Baldor Electric(0x0109)",
    0x010A: "Reserved(0x010A)",
    0x010B: "Patlite Corporation(0x010B)",
    0x010C: "Reserved(0x010C)",
    0x010D: "Mogami Wire & Cable Corporation(0x010D)",
    0x010E: "Welding Technology Corporation (WTC)(0x010E)",
    0x010F: "Reserved(0x010F)",
    0x0110: "Deutschmann Automation GmbH(0x0110)",
    0x0111: "ICP Panel-Tec Inc.(0x0111)",
    0x0112: "Bray Controls USA(0x0112)",
    0x0113: "Reserved(0x0113)",
    0x0114: "Status Technologies(0x0114)",
    0x0115: "Trio Motion Technology Ltd(0x0115)",
    0x0116: "Sherrex Systems Ltd(0x0116)",
    0x0117: "Adept Technology Inc.(0x0117)",
    0x0118: "Spang Power Electronics(0x0118)",
    0x0119: "Reserved(0x0119)",
    0x011A: "Acrosser Technology Co.Ltd(0x011A)",
    0x011B: "Hilscher GmbH(0x011B)",
    0x011C: "IMAX Corporation(0x011C)",
    0x011D: "Electronic Innovation Inc. (Falter Engineering)(0x011D)",
    0x011E: "Netlogic Inc.(0x011E)",
    0x011F: "Bosch Rexroth Corporation: Indramat(0x011F)",
    0x0120: "Reserved(0x0120)",
    0x0121: "Reserved(0x0121)",
    0x0122: "Murata  Machinery Ltd.(0x0122)",
    0x0123: "MTT Company Ltd.(0x0123)",
    0x0124: "Kanematsu Semiconductor Corp.(0x0124)",
    0x0125: "Takebishi Electric Sales Co.(0x0125)",
    0x0126: "Tokyo Electron Device Ltd(0x0126)",
    0x0127: "PFU Limited(0x0127)",
    0x0128: "Hakko Automation Co.Ltd.(0x0128)",
    0x0129: "Advanet Inc.(0x0129)",
    0x012A: "Tokyo Electron Software Technologies Ltd.(0x012A)",
    0x012B: "Reserved(0x012B)",
    0x012C: "Shinagawa Electric Wire Co.Ltd.(0x012C)",
    0x012D: "Yokogawa M&C Corporation(0x012D)",
    0x012E: "KONAN Electric Co.Ltd.(0x012E)",
    0x012F: "Binar Elektronik AB(0x012F)",
    0x0130: "Furukawa Electric Co.(0x0130)",
    0x0131: "Cooper Energy Services(0x0131)",
    0x0132: "Schleicher GmbH & Co.(0x0132)",
    0x0133: "Hirose Electric Co.Ltd(0x0133)",
    0x0134: "Western Servo Design Inc.(0x0134)",
    0x0135: "Prosoft Technology(0x0135)",
    0x0136: "Reserved(0x0136)",
    0x0137: "Towa Shoko Co.Ltd(0x0137)",
    0x0138: "Kyopal Co.Ltd(0x0138)",
    0x0139: "Extron Co.(0x0139)",
    0x013A: "Wieland Electric GmbH(0x013A)",
    0x013B: "SEW Eurodrive GmbH(0x013B)",
    0x013C: "Aera Corporation(0x013C)",
    0x013D: "STA Reutlingen(0x013D)",
    0x013E: "Reserved(0x013E)",
    0x013F: "Fuji Electric Co.Ltd.(0x013F)",
    0x0140: "Reserved(0x0140)",
    0x0141: "Reserved(0x0141)",
    0x0142: "ifm efector: inc.(0x0142)",
    0x0143: "Reserved(0x0143)",
    0x0144: "IDEACOD-Hohner Automation S.A.(0x0144)",
    0x0145: "CommScope Inc.(0x0145)",
    0x0146: "GE Fanuc Automation North America Inc.(0x0146)",
    0x0147: "Matsushita Electric Industrial Co.Ltd(0x0147)",
    0x0148: "Okaya Electronics Corporation(0x0148)",
    0x0149: "KASHIYAMA IndustriesLtd(0x0149)",
    0x014A: "JVC(0x014A)",
    0x014B: "Interface Corporation(0x014B)",
    0x014C: "Grape Systems Inc.(0x014C)",
    0x014D: "Reserved(0x014D)",
    0x014E: "Reserved(0x014E)",
    0x014F: "Toshiba IT & Control Systems Corporation(0x014F)",
    0x0150: "Sanyo Machine WorksLtd.(0x0150)",
    0x0151: "Vansco Electronics Ltd.(0x0151)",
    0x0152: "Dart Container Corp.(0x0152)",
    0x0153: "Livingston & Co. Inc.(0x0153)",
    0x0154: "Alfa Laval LKM as(0x0154)",
    0x0155: "BF ENTRON Ltd. (British Federal)(0x0155)",
    0x0156: "Bekaert Engineering NV(0x0156)",
    0x0157: "Ferran  Scientific Inc.(0x0157)",
    0x0158: "KEBA AG(0x0158)",
    0x0159: "Endress + Hauser(0x0159)",
    0x015A: "Reserved(0x015A)",
    0x015B: "ABB ALSTOM Power UK Ltd. (EGT)(0x015B)",
    0x015C: "Berger Lahr GmbH(0x015C)",
    0x015D: "Reserved(0x015D)",
    0x015E: "Federal Signal Corp.(0x015E)",
    0x015F: "Kawasaki Robotics (USA) Inc.(0x015F)",
    0x0160: "Bently Nevada Corporation(0x0160)",
    0x0161: "Reserved(0x0161)",
    0x0162: "FRABA Posital GmbH(0x0162)",
    0x0163: "Elsag Bailey Inc.(0x0163)",
    0x0164: "Fanuc Robotics America(0x0164)",
    0x0165: "Reserved(0x0165)",
    0x0166: "Surface Combustion Inc.(0x0166)",
    0x0167: "Reserved(0x0167)",
    0x0168: "AILES Electronics Ind. Co.Ltd.(0x0168)",
    0x0169: "Wonderware Corporation(0x0169)",
    0x016A: "Particle Measuring Systems Inc.(0x016A)",
    0x016B: "Reserved(0x016B)",
    0x016C: "Reserved(0x016C)",
    0x016D: "BITS Co.Ltd(0x016D)",
    0x016E: "Japan Aviation Electronics Industry Ltd(0x016E)",
    0x016F: "Keyence Corporation(0x016F)",
    0x0170: "Kuroda Precision Industries Ltd.(0x0170)",
    0x0171: "Mitsubishi Electric Semiconductor Application(0x0171)",
    0x0172: "Nippon Seisen CableLtd.(0x0172)",
    0x0173: "Omron ASO Co.Ltd(0x0173)",
    0x0174: "Seiko Seiki Co.Ltd.(0x0174)",
    0x0175: "Sumitomo Heavy IndustriesLtd.(0x0175)",
    0x0176: "Tango Computer Service Corporation(0x0176)",
    0x0177: "Technology Service Inc.(0x0177)",
    0x0178: "Toshiba Information Systems (Japan) Corporation(0x0178)",
    0x0179: "TOSHIBA Schneider Inverter Corporation(0x0179)",
    0x017A: "Toyooki Kogyo Co.Ltd.(0x017A)",
    0x017B: "XEBEC(0x017B)",
    0x017C: "Madison Cable Corporation(0x017C)",
    0x017D: "Hitati Engineering & Services Co.Ltd(0x017D)",
    0x017E: "TEM-TECH Lab Co.Ltd(0x017E)",
    0x017F: "International Laboratory Corporation(0x017F)",
    0x0180: "Dyadic Systems Co.Ltd.(0x0180)",
    0x0181: "SETO Electronics Industry Co.Ltd(0x0181)",
    0x0182: "Tokyo Electron Kyushu Limited(0x0182)",
    0x0183: "KEI System Co.Ltd(0x0183)",
    0x0184: "Reserved(0x0184)",
    0x0185: "Asahi Engineering Co.Ltd(0x0185)",
    0x0186: "Contrex Inc.(0x0186)",
    0x0187: "Paradigm Controls Ltd.(0x0187)",
    0x0188: "Reserved(0x0188)",
    0x0189: "Ohm Electric Co.Ltd.(0x0189)",
    0x018A: "RKC Instrument Inc.(0x018A)",
    0x018B: "Suzuki Motor Corporation(0x018B)",
    0x018C: "Custom Servo Motors Inc.(0x018C)",
    0x018D: "PACE Control Systems(0x018D)",
    0x018E: "Reserved(0x018E)",
    0x018F: "Reserved(0x018F)",
    0x0190: "LINTEC Co.Ltd.(0x0190)",
    0x0191: "Hitachi Cable Ltd.(0x0191)",
    0x0192: "BUSWARE Direct(0x0192)",
    0x0193: "Eaton Electric B.V. (former Holec Holland N.V.)(0x0193)",
    0x0194: "VAT Vakuumventile AG(0x0194)",
    0x0195: "Scientific Technologies Incorporated(0x0195)",
    0x0196: "Alfa Instrumentos Eletronicos Ltda(0x0196)",
    0x0197: "TWK Elektronik GmbH(0x0197)",
    0x0198: "ABB Welding Systems AB(0x0198)",
    0x0199: "BYSTRONIC Maschinen AG(0x0199)",
    0x019A: "Kimura Electric Co.Ltd(0x019A)",
    0x019B: "Nissei Plastic Industrial Co.Ltd(0x019B)",
    0x019C: "Reserved(0x019C)",
    0x019D: "Kistler-Morse Corporation(0x019D)",
    0x019E: "Proteous Industries Inc.(0x019E)",
    0x019F: "IDC Corporation(0x019F)",
    0x01A0: "Nordson Corporation(0x01A0)",
    0x01A1: "Rapistan Systems(0x01A1)",
    0x01A2: "LP-Elektronik GmbH(0x01A2)",
    0x01A3: "GERBI & FASE S.p.A.(Fase Saldatura)(0x01A3)",
    0x01A4: "Phoenix Digital Corporation(0x01A4)",
    0x01A5: "Z-World Engineering(0x01A5)",
    0x01A6: "Honda R&D Co.Ltd.(0x01A6)",
    0x01A7: "Bionics Instrument Co.Ltd.(0x01A7)",
    0x01A8: "Teknic Inc.(0x01A8)",
    0x01A9: "R.Stahl Inc.(0x01A9)",
    0x01AA: "Reserved(0x01AA)",
    0x01AB: "Ryco Graphic Manufacturing Inc.(0x01AB)",
    0x01AC: "Giddings & Lewis Inc.(0x01AC)",
    0x01AD: "Koganei Corporation(0x01AD)",
    0x01AE: "Reserved(0x01AE)",
    0x01AF: "Nichigoh Communication Electric Wire Co.Ltd.(0x01AF)",
    0x01B0: "Reserved(0x01B0)",
    0x01B1: "Fujikura Ltd.(0x01B1)",
    0x01B2: "AD Link Technology Inc.(0x01B2)",
    0x01B3: "StoneL Corporation(0x01B3)",
    0x01B4: "Computer Optical Products Inc.(0x01B4)",
    0x01B5: "CONOS Inc.(0x01B5)",
    0x01B6: "Erhardt + Leimer GmbH(0x01B6)",
    0x01B7: "UNIQUE Co. Ltd(0x01B7)",
    0x01B8: "Roboticsware Inc.(0x01B8)",
    0x01B9: "Nachi Fujikoshi Corporation(0x01B9)",
    0x01BA: "Hengstler GmbH(0x01BA)",
    0x01BB: "Reserved(0x01BB)",
    0x01BC: "SUNNY GIKEN Inc.(0x01BC)",
    0x01BD: "Lenze Drive Systems GmbH(0x01BD)",
    0x01BE: "CD Systems B.V.(0x01BE)",
    0x01BF: "FMT/Aircraft Gate Support Systems AB(0x01BF)",
    0x01C0: "Axiomatic Technologies Corp(0x01C0)",
    0x01C1: "Embedded System Products Inc.(0x01C1)",
    0x01C2: "Reserved(0x01C2)",
    0x01C3: "Mencom Corporation(0x01C3)",
    0x01C4: "Reserved(0x01C4)",
    0x01C5: "Matsushita Welding Systems Co.Ltd.(0x01C5)",
    0x01C6: "Dengensha Mfg. Co. Ltd.(0x01C6)",
    0x01C7: "Quinn Systems Ltd.(0x01C7)",
    0x01C8: "Tellima Technology Ltd(0x01C8)",
    0x01C9: "MDT: Software(0x01C9)",
    0x01CA: "Taiwan Keiso Co.Ltd(0x01CA)",
    0x01CB: "Pinnacle Systems(0x01CB)",
    0x01CC: "Ascom Hasler Mailing Sys(0x01CC)",
    0x01CD: "INSTRUMAR Limited(0x01CD)",
    0x01CE: "Reserved(0x01CE)",
    0x01CF: "Navistar International Transportation Corp(0x01CF)",
    0x01D0: "Huettinger Elektronik GmbH + Co. KG(0x01D0)",
    0x01D1: "OCM Technology Inc.(0x01D1)",
    0x01D2: "Professional Supply Inc.(0x01D2)",
    0x01D3: "Control Solutions(0x01D3)",
    0x01D4: "Baumer IVO GmbH & Co. KG(0x01D4)",
    0x01D5: "Worcester Controls Corporation(0x01D5)",
    0x01D6: "Pyramid Technical Consultants Inc.(0x01D6)",
    0x01D7: "Reserved(0x01D7)",
    0x01D8: "Apollo Fire Detectors Limited(0x01D8)",
    0x01D9: "Avtron Manufacturing Inc.(0x01D9)",
    0x01DA: "Reserved(0x01DA)",
    0x01DB: "Tokyo Keiso Co.Ltd.(0x01DB)",
    0x01DC: "Daishowa Swiki Co.Ltd.(0x01DC)",
    0x01DD: "Kojima Instruments Inc.(0x01DD)",
    0x01DE: "Shimadzu Corporation(0x01DE)",
    0x01DF: "Tatsuta Electric Wire & Cable Co.Ltd.(0x01DF)",
    0x01E0: "MECS Corporation(0x01E0)",
    0x01E1: "Tahara Electric(0x01E1)",
    0x01E2: "Koyo Electronics(0x01E2)",
    0x01E3: "Clever Devices(0x01E3)",
    0x01E4: "GCD Hardware & Software GmbH(0x01E4)",
    0x01E5: "Reserved(0x01E5)",
    0x01E6: "Miller Electric Mfg Co.(0x01E6)",
    0x01E7: "GEA Tuchenhagen GmbH(0x01E7)",
    0x01E8: "Riken Keiki Co.: LTD(0x01E8)",
    0x01E9: "Keisokugiken Corporation(0x01E9)",
    0x01EA: "Fuji Machine Mfg. Co.Ltd(0x01EA)",
    0x01EB: "Reserved(0x01EB)",
    0x01EC: "Nidec-Shimpo Corp.(0x01EC)",
    0x01ED: "UTEC Corporation(0x01ED)",
    0x01EE: "Sanyo Electric Co. Ltd.(0x01EE)",
    0x01EF: "Reserved(0x01EF)",
    0x01F0: "Reserved(0x01F0)",
    0x01F1: "Okano Electric Wire Co. Ltd(0x01F1)",
    0x01F2: "Shimaden Co. Ltd.(0x01F2)",
    0x01F3: "Teddington Controls Ltd(0x01F3)",
    0x01F4: "Reserved(0x01F4)",
    0x01F5: "VIPA GmbH(0x01F5)",
    0x01F6: "Warwick Manufacturing Group(0x01F6)",
    0x01F7: "Danaher Controls(0x01F7)",
    0x01F8: "Reserved(0x01F8)",
    0x01F9: "Reserved(0x01F9)",
    0x01FA: "American Science & Engineering(0x01FA)",
    0x01FB: "Accutron Controls International Inc.(0x01FB)",
    0x01FC: "Norcott Technologies Ltd(0x01FC)",
    0x01FD: "TB Woods Inc(0x01FD)",
    0x01FE: "Proportion-Air Inc.(0x01FE)",
    0x01FF: "SICK Stegmann GmbH(0x01FF)",
    0x0200: "Reserved(0x0200)",
    0x0201: "Edwards Signaling(0x0201)",
    0x0202: "Sumitomo Metal IndustriesLtd(0x0202)",
    0x0203: "Cosmo Instruments Co.Ltd.(0x0203)",
    0x0204: "Denshosha Co.Ltd.(0x0204)",
    0x0205: "Kaijo Corp.(0x0205)",
    0x0206: "Michiproducts Co.Ltd.(0x0206)",
    0x0207: "Miura Corporation(0x0207)",
    0x0208: "TG Information Network Co.Ltd.(0x0208)",
    0x0209: "Fujikin  Inc.(0x0209)",
    0x020A: "Estic Corp.(0x020A)",
    0x020B: "GS Hydraulic Sales(0x020B)",
    0x020C: "Reserved(0x020C)",
    0x020D: "MTE Limited(0x020D)",
    0x020E: "Hyde Park Electronics Inc.(0x020E)",
    0x020F: "Pfeiffer Vacuum GmbH(0x020F)",
    0x0210: "Cyberlogic Technologies(0x0210)",
    0x0211: "OKUMA Corporation FA Systems Division(0x0211)",
    0x0212: "Reserved(0x0212)",
    0x0213: "Hitachi Kokusai Electric Co.Ltd.(0x0213)",
    0x0214: "SHINKO TECHNOS Co.Ltd.(0x0214)",
    0x0215: "Itoh Electric Co.Ltd.(0x0215)",
    0x0216: "Colorado Flow Tech Inc.(0x0216)",
    0x0217: "Love Controls Division/Dwyer Inst.(0x0217)",
    0x0218: "Alstom Drives and Controls(0x0218)",
    0x0219: "The Foxboro Company(0x0219)",
    0x021A: "Tescom Corporation(0x021A)",
    0x021B: "Reserved(0x021B)",
    0x021C: "Atlas Copco Controls UK(0x021C)",
    0x021D: "Reserved(0x021D)",
    0x021E: "Autojet Technologies(0x021E)",
    0x021F: "Prima Electronics S.p.A.(0x021F)",
    0x0220: "PMA GmbH(0x0220)",
    0x0221: "Shimafuji Electric Co.Ltd(0x0221)",
    0x0222: "Oki Electric Industry Co.Ltd(0x0222)",
    0x0223: "Kyushu Matsushita Electric Co.Ltd(0x0223)",
    0x0224: "Nihon Electric Wire & Cable Co.Ltd(0x0224)",
    0x0225: "Tsuken Electric Ind Co.Ltd(0x0225)",
    0x0226: "Tamadic Co.(0x0226)",
    0x0227: "MAATEL SA(0x0227)",
    0x0228: "OKUMA America(0x0228)",
    0x0229: "Control Techniques PLC-NA(0x0229)",
    0x022A: "TPC Wire & Cable(0x022A)",
    0x022B: "ATI Industrial Automation(0x022B)",
    0x022C: "Microcontrol (Australia) Pty Ltd(0x022C)",
    0x022D: "Serra Soldadura: S.A.(0x022D)",
    0x022E: "Southwest Research Institute(0x022E)",
    0x022F: "Cabinplant International(0x022F)",
    0x0230: "Sartorius Mechatronics T&H GmbH(0x0230)",
    0x0231: "Comau S.p.A. Robotics & Final Assembly Division(0x0231)",
    0x0232: "Phoenix Contact(0x0232)",
    0x0233: "Yokogawa MAT Corporation(0x0233)",
    0x0234: "asahi sangyo co.: ltd.(0x0234)",
    0x0235: "Reserved(0x0235)",
    0x0236: "Akita Myotoku Ltd.(0x0236)",
    0x0237: "OBARA Corp.(0x0237)",
    0x0238: "Suetron Electronic GmbH(0x0238)",
    0x0239: "Reserved(0x0239)",
    0x023A: "Serck Controls Limited(0x023A)",
    0x023B: "Fairchild Industrial Products Company(0x023B)",
    0x023C: "ARO S.A.(0x023C)",
    0x023D: "M2C GmbH(0x023D)",
    0x023E: "Shin Caterpillar Mitsubishi Ltd.(0x023E)",
    0x023F: "Santest Co.Ltd.(0x023F)",
    0x0240: "Cosmotechs Co.Ltd.(0x0240)",
    0x0241: "Hitachi Electric Systems(0x0241)",
    0x0242: "Smartscan Ltd(0x0242)",
    0x0243: "Woodhead Software & Electronics France(0x0243)",
    0x0244: "Athena Controls Inc.(0x0244)",
    0x0245: "Syron Engineering & Manufacturing Inc.(0x0245)",
    0x0246: "Asahi Optical Co.Ltd.(0x0246)",
    0x0247: "Sansha Electric Mfg. Co.Ltd.(0x0247)",
    0x0248: "Nikki Denso Co.Ltd.(0x0248)",
    0x0249: "Star Micronics: Co.Ltd.(0x0249)",
    0x024A: "Ecotecnia Socirtat Corp.(0x024A)",
    0x024B: "AC Technology Corp.(0x024B)",
    0x024C: "West Instruments Limited(0x024C)",
    0x024D: "NTI Limited(0x024D)",
    0x024E: "Delta Computer Systems Inc.(0x024E)",
    0x024F: "FANUC Ltd.(0x024F)",
    0x0250: "Hearn-Gu Lee(0x0250)",
    0x0251: "ABB Automation Products(0x0251)",
    0x0252: "Orion Machinery Co.Ltd.(0x0252)",
    0x0253: "Reserved(0x0253)",
    0x0254: "Wire-Pro Inc.(0x0254)",
    0x0255: "Beijing Huakong Technology Co. Ltd.(0x0255)",
    0x0256: "Yokoyama Shokai Co.Ltd.(0x0256)",
    0x0257: "Toyogiken Co.Ltd.(0x0257)",
    0x0258: "Coester Equipamentos Eletronicos Ltda.(0x0258)",
    0x0259: "Reserved(0x0259)",
    0x025A: "Electroplating Engineers of Japan Ltd.(0x025A)",
    0x025B: "ROBOX S.p.A.(0x025B)",
    0x025C: "Spraying Systems Company(0x025C)",
    0x025D: "Benshaw Inc.(0x025D)",
    0x025E: "ZPA-DP A.S.(0x025E)",
    0x025F: "Wired Rite Systems(0x025F)",
    0x0260: "Tandis Research Inc.(0x0260)",
    0x0261: "SSD Drives GmbH(0x0261)",
    0x0262: "ULVAC Japan Ltd.(0x0262)",
    0x0263: "DYNAX Corporation(0x0263)",
    0x0264: "Nor-Cal Products Inc.(0x0264)",
    0x0265: "Aros Electronics AB(0x0265)",
    0x0266: "Jun-Tech Co.Ltd.(0x0266)",
    0x0267: "HAN-MI Co. Ltd.(0x0267)",
    0x0268: "uniNtech (formerly SungGi Internet)(0x0268)",
    0x0269: "Hae Pyung Electronics Reserch Institute(0x0269)",
    0x026A: "Milwaukee Electronics(0x026A)",
    0x026B: "OBERG Industries(0x026B)",
    0x026C: "Parker Hannifin/Compumotor Division(0x026C)",
    0x026D: "TECHNO DIGITAL CORPORATION(0x026D)",
    0x026E: "Network Supply Co.Ltd.(0x026E)",
    0x026F: "Union Electronics Co.Ltd.(0x026F)",
    0x0270: "Tritronics Services PM Ltd.(0x0270)",
    0x0271: "Rockwell Automation-Sprecher+Schuh(0x0271)",
    0x0272: "Matsushita Electric Industrial Co.Ltd/Motor Co.(0x0272)",
    0x0273: "Rolls-Royce Energy Systems Inc.(0x0273)",
    0x0274: "JEONGIL INTERCOM CO.: LTD(0x0274)",
    0x0275: "Interroll Corp.(0x0275)",
    0x0276: "Hubbell Wiring Device-Kellems (Delaware)(0x0276)",
    0x0277: "Intelligent Motion Systems(0x0277)",
    0x0278: "Reserved(0x0278)",
    0x0279: "INFICON AG(0x0279)",
    0x027A: "Hirschmann Inc.(0x027A)",
    0x027B: "The Siemon Company(0x027B)",
    0x027C: "YAMAHA Motor Co. Ltd.(0x027C)",
    0x027D: "aska corporation(0x027D)",
    0x027E: "Woodhead Connectivity(0x027E)",
    0x027F: "Trimble AB(0x027F)",
    0x0280: "Murrelektronik GmbH(0x0280)",
    0x0281: "Creatrix Labs Inc.(0x0281)",
    0x0282: "TopWorx(0x0282)",
    0x0283: "Kumho Industrial Co.Ltd.(0x0283)",
    0x0284: "Wind River Systems Inc.(0x0284)",
    0x0285: "Bihl & Wiedemann GmbH(0x0285)",
    0x0286: "Harmonic Drive Systems Inc.(0x0286)",
    0x0287: "Rikei Corporation(0x0287)",
    0x0288: "BL AutotecLtd.(0x0288)",
    0x0289: "Hana Information & Technology Co.Ltd.(0x0289)",
    0x028A: "Seoil Electric Co.Ltd.(0x028A)",
    0x028B: "Fife Corporation(0x028B)",
    0x028C: "Shanghai Electrical Apparatus Research Institute(0x028C)",
    0x028D: "Reserved(0x028D)",
    0x028E: "Parasense Development Centre(0x028E)",
    0x028F: "Reserved(0x028F)",
    0x0290: "Reserved(0x0290)",
    0x0291: "Six Tau S.p.A.(0x0291)",
    0x0292: "Aucos GmbH(0x0292)",
    0x0293: "Rotork Controls(0x0293)",
    0x0294: "Automationdirect.com(0x0294)",
    0x0295: "Thermo BLH(0x0295)",
    0x0296: "System ControlsLtd.(0x0296)",
    0x0297: "Univer S.p.A.(0x0297)",
    0x0298: "MKS-Tenta Technology(0x0298)",
    0x0299: "Lika Electronic SNC(0x0299)",
    0x029A: "Mettler-Toledo Inc.(0x029A)",
    0x029B: "DXL USA Inc.(0x029B)",
    0x029C: "Rockwell Automation/Entek IRD Intl.(0x029C)",
    0x029D: "Nippon Otis Elevator Company(0x029D)",
    0x029E: "Sinano Electric: Co.Ltd.(0x029E)",
    0x029F: "Sony Manufacturing Systems(0x029F)",
    0x02A0: "Reserved(0x02A0)",
    0x02A1: "Contec Co.Ltd.(0x02A1)",
    0x02A2: "Automated Solutions(0x02A2)",
    0x02A3: "Controlweigh(0x02A3)",
    0x02A4: "Reserved(0x02A4)",
    0x02A5: "Fincor Electronics(0x02A5)",
    0x02A6: "Cognex Corporation(0x02A6)",
    0x02A7: "Qualiflow(0x02A7)",
    0x02A8: "Weidmuller Inc.(0x02A8)",
    0x02A9: "Morinaga Milk Industry Co.Ltd.(0x02A9)",
    0x02AA: "Takagi Industrial Co.Ltd.(0x02AA)",
    0x02AB: "Wittenstein AG(0x02AB)",
    0x02AC: "Sena Technologies Inc.(0x02AC)",
    0x02AD: "Reserved(0x02AD)",
    0x02AE: "APV Products Unna(0x02AE)",
    0x02AF: "Creator Teknisk Utvedkling AB(0x02AF)",
    0x02B0: "Reserved(0x02B0)",
    0x02B1: "Mibu Denki Industrial Co.Ltd.(0x02B1)",
    0x02B2: "Takamastsu Machineer Section(0x02B2)",
    0x02B3: "Startco Engineering Ltd.(0x02B3)",
    0x02B4: "Reserved(0x02B4)",
    0x02B5: "Holjeron(0x02B5)",
    0x02B6: "ALCATEL High Vacuum Technology(0x02B6)",
    0x02B7: "Taesan LCD Co.Ltd.(0x02B7)",
    0x02B8: "POSCON(0x02B8)",
    0x02B9: "VMIC(0x02B9)",
    0x02BA: "Matsushita Electric WorksLtd.(0x02BA)",
    0x02BB: "IAI Corporation(0x02BB)",
    0x02BC: "Horst GmbH(0x02BC)",
    0x02BD: "MicroControl GmbH & Co.(0x02BD)",
    0x02BE: "Leine & Linde AB(0x02BE)",
    0x02BF: "Reserved(0x02BF)",
    0x02C0: "EC Elettronica Srl(0x02C0)",
    0x02C1: "VIT Software HB(0x02C1)",
    0x02C2: "Bronkhorst High-Tech B.V.(0x02C2)",
    0x02C3: "Optex Co.Ltd.(0x02C3)",
    0x02C4: "Yosio Electronic Co.(0x02C4)",
    0x02C5: "Terasaki Electric Co.Ltd.(0x02C5)",
    0x02C6: "Sodick Co.Ltd.(0x02C6)",
    0x02C7: "MTS Systems Corporation-Automation Division(0x02C7)",
    0x02C8: "Mesa Systemtechnik(0x02C8)",
    0x02C9: "SHIN HO SYSTEM Co.Ltd.(0x02C9)",
    0x02CA: "Goyo Electronics CoLtd.(0x02CA)",
    0x02CB: "Loreme(0x02CB)",
    0x02CC: "SAB Brockskes GmbH & Co. KG(0x02CC)",
    0x02CD: "Trumpf Laser GmbH + Co. KG(0x02CD)",
    0x02CE: "Niigata Electronic Instruments Co.Ltd.(0x02CE)",
    0x02CF: "Yokogawa Digital Computer Corporation(0x02CF)",
    0x02D0: "O.N. Electronic Co.Ltd.(0x02D0)",
    0x02D1: "Industrial Control  Communication Inc.(0x02D1)",
    0x02D2: "ABB Inc.(0x02D2)",
    0x02D3: "ElectroWave USA Inc.(0x02D3)",
    0x02D4: "Industrial Network Controls: LLC(0x02D4)",
    0x02D5: "KDT Systems Co.Ltd.(0x02D5)",
    0x02D6: "SEFA Technology Inc.(0x02D6)",
    0x02D7: "Nippon POP Rivets and Fasteners Ltd.(0x02D7)",
    0x02D8: "Yamato Scale Co.Ltd.(0x02D8)",
    0x02D9: "Zener Electric(0x02D9)",
    0x02DA: "GSE Scale Systems(0x02DA)",
    0x02DB: "ISAS (Integrated Switchgear & Sys. Pty Ltd)(0x02DB)",
    0x02DC: "Beta LaserMike Limited(0x02DC)",
    0x02DD: "TOEI Electric Co.Ltd.(0x02DD)",
    0x02DE: "Hakko Electronics Co.Ltd(0x02DE)",
    0x02DF: "Reserved(0x02DF)",
    0x02E0: "RFID Inc.(0x02E0)",
    0x02E1: "Adwin Corporation(0x02E1)",
    0x02E2: "Osaka VacuumLtd.(0x02E2)",
    0x02E3: "A-Kyung Motion Inc.(0x02E3)",
    0x02E4: "Camozzi S.P. A.(0x02E4)",
    0x02E5: "Crevis Co.: LTD(0x02E5)",
    0x02E6: "Rice Lake Weighing Systems(0x02E6)",
    0x02E7: "Linux Network Services(0x02E7)",
    0x02E8: "KEB Antriebstechnik GmbH(0x02E8)",
    0x02E9: "Hagiwara Electric Co.Ltd.(0x02E9)",
    0x02EA: "Glass Inc. International(0x02EA)",
    0x02EB: "Reserved(0x02EB)",
    0x02EC: "DVT Corporation(0x02EC)",
    0x02ED: "Woodward Governor(0x02ED)",
    0x02EE: "Mosaic Systems Inc.(0x02EE)",
    0x02EF: "Laserline GmbH(0x02EF)",
    0x02F0: "COM-TEC Inc.(0x02F0)",
    0x02F1: "Weed Instrument(0x02F1)",
    0x02F2: "Prof-face European Technology Center(0x02F2)",
    0x02F3: "Fuji Automation Co.Ltd.(0x02F3)",
    0x02F4: "Matsutame Co.Ltd.(0x02F4)",
    0x02F5: "Hitachi Via MechanicsLtd.(0x02F5)",
    0x02F6: "Dainippon Screen Mfg. Co. Ltd.(0x02F6)",
    0x02F7: "FLS Automation A/S(0x02F7)",
    0x02F8: "ABB Stotz Kontakt GmbH(0x02F8)",
    0x02F9: "Technical Marine Service(0x02F9)",
    0x02FA: "Advanced Automation Associates Inc.(0x02FA)",
    0x02FB: "Baumer Ident GmbH(0x02FB)",
    0x02FC: "Tsubakimoto Chain Co.(0x02FC)",
    0x02FD: "Reserved(0x02FD)",
    0x02FE: "Furukawa Co.Ltd.(0x02FE)",
    0x02FF: "Active Power(0x02FF)",
    0x0300: "CSIRO Mining Automation(0x0300)",
    0x0301: "Matrix Integrated Systems(0x0301)",
    0x0302: "Digitronic Automationsanlagen GmbH(0x0302)",
    0x0303: "SICK STEGMANN Inc.(0x0303)",
    0x0304: "TAE-Antriebstechnik GmbH(0x0304)",
    0x0305: "Electronic Solutions(0x0305)",
    0x0306: "Rocon L.L.C.(0x0306)",
    0x0307: "Dijitized Communications Inc.(0x0307)",
    0x0308: "Asahi Organic Chemicals Industry Co.Ltd.(0x0308)",
    0x0309: "Hodensha(0x0309)",
    0x030A: "Harting Inc. NA(0x030A)",
    0x030B: "Kubler GmbH(0x030B)",
    0x030C: "Yamatake Corporation(0x030C)",
    0x030D: "JEOL(0x030D)",
    0x030E: "Yamatake Industrial Systems Co.Ltd.(0x030E)",
    0x030F: "HAEHNE Elektronische Messgerate GmbH(0x030F)",
    0x0310: "Ci Technologies Pty Ltd (for Pelamos Industries)(0x0310)",
    0x0311: "N. SCHLUMBERGER & CIE(0x0311)",
    0x0312: "Teijin Seiki Co.Ltd.(0x0312)",
    0x0313: "DAIKIN IndustriesLtd(0x0313)",
    0x0314: "RyuSyo Industrial Co.Ltd.(0x0314)",
    0x0315: "SAGINOMIYA SEISAKUSHO: INC.(0x0315)",
    0x0316: "Seishin Engineering Co.Ltd.(0x0316)",
    0x0317: "Japan Support System Ltd.(0x0317)",
    0x0318: "Decsys(0x0318)",
    0x0319: "Metronix Messgerate u. Elektronik GmbH(0x0319)",
    0x031A: "Reserved(0x031A)",
    0x031B: "Vaccon Company Inc.(0x031B)",
    0x031C: "Siemens Energy & Automation Inc.(0x031C)",
    0x031D: "Ten X Technology Inc.(0x031D)",
    0x031E: "Tyco Electronics(0x031E)",
    0x031F: "Delta Power Electronics Center(0x031F)",
    0x0320: "Denker(0x0320)",
    0x0321: "Autonics Corporation(0x0321)",
    0x0322: "JFE Electronic Engineering Pty. Ltd.(0x0322)",
    0x0323: "Reserved(0x0323)",
    0x0324: "Electro-Sensors Inc.(0x0324)",
    0x0325: "Digi International Inc.(0x0325)",
    0x0326: "Texas Instruments(0x0326)",
    0x0327: "ADTEC Plasma Technology Co.Ltd(0x0327)",
    0x0328: "SICK AG(0x0328)",
    0x0329: "Ethernet Peripherals Inc.(0x0329)",
    0x032A: "Animatics Corporation(0x032A)",
    0x032B: "Reserved(0x032B)",
    0x032C: "Process Control Corporation(0x032C)",
    0x032D: "SystemV. Inc.(0x032D)",
    0x032E: "Danaher Motion SRL(0x032E)",
    0x032F: "SHINKAWA Sensor Technology Inc.(0x032F)",
    0x0330: "Tesch GmbH & Co. KG(0x0330)",
    0x0331: "Reserved(0x0331)",
    0x0332: "Trend Controls Systems Ltd.(0x0332)",
    0x0333: "Guangzhou ZHIYUAN Electronic Co.Ltd.(0x0333)",
    0x0334: "Mykrolis Corporation(0x0334)",
    0x0335: "Bethlehem Steel Corporation(0x0335)",
    0x0336: "KK ICP(0x0336)",
    0x0337: "Takemoto Denki Corporation(0x0337)",
    0x0338: "The Montalvo Corporation(0x0338)",
    0x0339: "Reserved(0x0339)",
    0x033A: "LEONI Special Cables GmbH(0x033A)",
    0x033B: "Reserved(0x033B)",
    0x033C: "ONO SOKKI CO.,LTD.(0x033C)",
    0x033D: "Rockwell Samsung Automation(0x033D)",
    0x033E: "SHINDENGEN ELECTRIC MFG. CO. LTD(0x033E)",
    0x033F: "Origin Electric Co. Ltd.(0x033F)",
    0x0340: "Quest Technical Solutions Inc.(0x0340)",
    0x0341: "LS CableLtd.(0x0341)",
    0x0342: "Enercon-Nord Electronic GmbH(0x0342)",
    0x0343: "Northwire Inc.(0x0343)",
    0x0344: "Engel Elektroantriebe GmbH(0x0344)",
    0x0345: "The Stanley Works(0x0345)",
    0x0346: "Celesco Transducer Products Inc.(0x0346)",
    0x0347: "Chugoku Electric Wire and Cable Co.(0x0347)",
    0x0348: "Kongsberg Simrad AS(0x0348)",
    0x0349: "Panduit Corporation(0x0349)",
    0x034A: "Spellman High Voltage Electronics Corp.(0x034A)",
    0x034B: "Kokusai Electric Alpha Co.Ltd.(0x034B)",
    0x034C: "Brooks Automation Inc.(0x034C)",
    0x034D: "ANYWIRE CORPORATION(0x034D)",
    0x034E: "Honda Electronics Co. Ltd(0x034E)",
    0x034F: "REO Elektronik AG(0x034F)",
    0x0350: "Fusion UV Systems Inc.(0x0350)",
    0x0351: "ASI Advanced Semiconductor Instruments GmbH(0x0351)",
    0x0352: "Datalogic Inc.(0x0352)",
    0x0353: "SoftPLC Corporation(0x0353)",
    0x0354: "Dynisco Instruments LLC(0x0354)",
    0x0355: "WEG Industrias SA(0x0355)",
    0x0356: "Frontline Test Equipment Inc.(0x0356)",
    0x0357: "Tamagawa Seiki Co.Ltd.(0x0357)",
    0x0358: "Multi Computing Co.Ltd.(0x0358)",
    0x0359: "RVSI(0x0359)",
    0x035A: "Commercial Timesharing Inc.(0x035A)",
    0x035B: "Tennessee Rand Automation LLC(0x035B)",
    0x035C: "Wacogiken Co.Ltd(0x035C)",
    0x035D: "Reflex Integration Inc.(0x035D)",
    0x035E: "Siemens AG: A&D PI Flow Instruments(0x035E)",
    0x035F: "G. Bachmann Electronic GmbH(0x035F)",
    0x0360: "NT International(0x0360)",
    0x0361: "Schweitzer Engineering Laboratories(0x0361)",
    0x0362: "ATR Industrie-Elektronik GmbH Co.(0x0362)",
    0x0363: "PLASMATECH Co.Ltd(0x0363)",
    0x0364: "Reserved(0x0364)",
    0x0365: "GEMU GmbH & Co. KG(0x0365)",
    0x0366: "Alcorn McBride Inc.(0x0366)",
    0x0367: "MORI SEIKI CO.: LTD(0x0367)",
    0x0368: "NodeTech Systems Ltd(0x0368)",
    0x0369: "Emhart Teknologies(0x0369)",
    0x036A: "Cervis Inc.(0x036A)",
    0x036B: "FieldServer Technologies (Div Sierra Monitor Corp)(0x036B)",
    0x036C: "NEDAP Power Supplies(0x036C)",
    0x036D: "Nippon Sanso Corporation(0x036D)",
    0x036E: "Mitomi Giken Co.Ltd.(0x036E)",
    0x036F: "PULS GmbH(0x036F)",
    0x0370: "Reserved(0x0370)",
    0x0371: "Japan Control Engineering Ltd(0x0371)",
    0x0372: "Embedded Systems Korea (Former Zues Emtek Co Ltd.)(0x0372)",
    0x0373: "Automa SRL(0x0373)",
    0x0374: "Harms+Wende GmbH & Co KG(0x0374)",
    0x0375: "SAE-STAHL GmbH(0x0375)",
    0x0376: "Microwave Data Systems(0x0376)",
    0x0377: "Bernecker + Rainer Industrie-Elektronik GmbH(0x0377)",
    0x0378: "Hiprom Technologies(0x0378)",
    0x0379: "Reserved(0x0379)",
    0x037A: "Nitta Corporation(0x037A)",
    0x037B: "Kontron Modular Computers GmbH(0x037B)",
    0x037C: "Marlin Controls(0x037C)",
    0x037D: "ELCIS s.r.l.(0x037D)",
    0x037E: "Acromag Inc.(0x037E)",
    0x037F: "Avery Weigh-Tronix(0x037F)",
    0x0380: "Reserved(0x0380)",
    0x0381: "Reserved(0x0381)",
    0x0382: "Reserved(0x0382)",
    0x0383: "Practicon Ltd(0x0383)",
    0x0384: "Schunk GmbH & Co. KG(0x0384)",
    0x0385: "MYNAH Technologies(0x0385)",
    0x0386: "Defontaine Groupe(0x0386)",
    0x0387: "Emerson Process Management Power & Water Solutions(0x0387)",
    0x0388: "F.A. Elec(0x0388)",
    0x0389: "Hottinger Baldwin Messtechnik GmbH(0x0389)",
    0x038A: "Coreco Imaging Inc.(0x038A)",
    0x038B: "London Electronics Ltd.(0x038B)",
    0x038C: "HSD SpA(0x038C)",
    0x038D: "Comtrol Corporation(0x038D)",
    0x038E: "TEAM: S.A. (Tecnica Electronica de Automatismo Y Medida)(0x038E)",
    0x038F: "MAN B&W Diesel Ltd. Regulateurs Europa(0x038F)",
    0x0390: "Reserved(0x0390)",
    0x0391: "Reserved(0x0391)",
    0x0392: "Micro Motion Inc.(0x0392)",
    0x0393: "Eckelmann AG(0x0393)",
    0x0394: "Hanyoung Nux(0x0394)",
    0x0395: "Ransburg Industrial Finishing KK(0x0395)",
    0x0396: "Kun Hung Electric Co. Ltd.(0x0396)",
    0x0397: "Brimos wegbebakening b.v.(0x0397)",
    0x0398: "Nitto Seiki Co.Ltd(0x0398)",
    0x0399: "PPT Vision Inc.(0x0399)",
    0x039A: "Yamazaki Machinery Works(0x039A)",
    0x039B: "SCHMIDT Technology GmbH(0x039B)",
    0x039C: "Parker Hannifin SpA (SBC Division)(0x039C)",
    0x039D: "HIMA Paul Hildebrandt GmbH(0x039D)",
    0x039E: "RivaTek Inc.(0x039E)",
    0x039F: "Misumi Corporation(0x039F)",
    0x03A0: "GE Multilin(0x03A0)",
    0x03A1: "Measurement Computing Corporation(0x03A1)",
    0x03A2: "Jetter AG(0x03A2)",
    0x03A3: "Tokyo Electronics Systems Corporation(0x03A3)",
    0x03A4: "Togami Electric Mfg. Co.Ltd.(0x03A4)",
    0x03A5: "HK Systems(0x03A5)",
    0x03A6: "CDA Systems Ltd.(0x03A6)",
    0x03A7: "Aerotech Inc.(0x03A7)",
    0x03A8: "JVL Industrie Elektronik A/S(0x03A8)",
    0x03A9: "NovaTech Process Solutions LLC(0x03A9)",
    0x03AA: "Reserved(0x03AA)",
    0x03AB: "Cisco Systems(0x03AB)",
    0x03AC: "Grid Connect(0x03AC)",
    0x03AD: "ITW Automotive Finishing(0x03AD)",
    0x03AE: "HanYang System(0x03AE)",
    0x03AF: "ABB K.K. Technical Center(0x03AF)",
    0x03B0: "Taiyo Electric Wire & Cable Co.Ltd.(0x03B0)",
    0x03B1: "Reserved(0x03B1)",
    0x03B2: "SEREN IPS INC(0x03B2)",
    0x03B3: "Belden CDT Electronics Division(0x03B3)",
    0x03B4: "ControlNet International(0x03B4)",
    0x03B5: "Gefran S.P.A.(0x03B5)",
    0x03B6: "Jokab Safety AB(0x03B6)",
    0x03B7: "SUMITA OPTICAL GLASS: INC.(0x03B7)",
    0x03B8: "Biffi Italia srl(0x03B8)",
    0x03B9: "Beck IPC GmbH(0x03B9)",
    0x03BA: "Copley Controls Corporation(0x03BA)",
    0x03BB: "Fagor Automation S. Coop.(0x03BB)",
    0x03BC: "DARCOM(0x03BC)",
    0x03BD: "Frick Controls (div. of York International)(0x03BD)",
    0x03BE: "SymCom Inc.(0x03BE)",
    0x03BF: "Infranor(0x03BF)",
    0x03C0: "Kyosan CableLtd.(0x03C0)",
    0x03C1: "Varian Vacuum Technologies(0x03C1)",
    0x03C2: "Messung Systems(0x03C2)",
    0x03C3: "Xantrex Technology Inc.(0x03C3)",
    0x03C4: "StarThis Inc.(0x03C4)",
    0x03C5: "Chiyoda Co.Ltd.(0x03C5)",
    0x03C6: "Flowserve Corporation(0x03C6)",
    0x03C7: "Spyder Controls Corp.(0x03C7)",
    0x03C8: "IBA AG(0x03C8)",
    0x03C9: "SHIMOHIRA ELECTRIC MFG.CO.,LTD(0x03C9)",
    0x03CA: "Reserved(0x03CA)",
    0x03CB: "Siemens L&A(0x03CB)",
    0x03CC: "Micro Innovations AG(0x03CC)",
    0x03CD: "Switchgear & Instrumentation(0x03CD)",
    0x03CE: "PRE-TECH CO.: LTD.(0x03CE)",
    0x03CF: "National Semiconductor(0x03CF)",
    0x03D0: "Invensys Process Systems(0x03D0)",
    0x03D1: "Ametek HDR Power Systems(0x03D1)",
    0x03D2: "Reserved(0x03D2)",
    0x03D3: "TETRA-K Corporation(0x03D3)",
    0x03D4: "C & M Corporation(0x03D4)",
    0x03D5: "Siempelkamp Maschinen(0x03D5)",
    0x03D6: "Reserved(0x03D6)",
    0x03D7: "Daifuku America Corporation(0x03D7)",
    0x03D8: "Electro-Matic Products Inc.(0x03D8)",
    0x03D9: "BUSSAN MICROELECTRONICS CORP.(0x03D9)",
    0x03DA: "ELAU AG(0x03DA)",
    0x03DB: "Hetronic USA(0x03DB)",
    0x03DC: "NIIGATA POWER SYSTEMS Co.Ltd.(0x03DC)",
    0x03DD: "Software Horizons Inc.(0x03DD)",
    0x03DE: "B3 Systems Inc.(0x03DE)",
    0x03DF: "Moxa Networking Co.Ltd.(0x03DF)",
    0x03E0: "Reserved(0x03E0)",
    0x03E1: "S4 Integration(0x03E1)",
    0x03E2: "Elettro Stemi S.R.L.(0x03E2)",
    0x03E3: "AquaSensors(0x03E3)",
    0x03E4: "Ifak System GmbH(0x03E4)",
    0x03E5: "SANKEI MANUFACTURING Co.,LTD.(0x03E5)",
    0x03E6: "Emerson Network Power Co.Ltd.(0x03E6)",
    0x03E7: "Fairmount Automation Inc.(0x03E7)",
    0x03E8: "Bird Electronic Corporation(0x03E8)",
    0x03E9: "Nabtesco Corporation(0x03E9)",
    0x03EA: "AGM Electronics Inc.(0x03EA)",
    0x03EB: "ARCX Inc.(0x03EB)",
    0x03EC: "DELTA I/O Co.(0x03EC)",
    0x03ED: "Chun IL Electric Ind. Co.(0x03ED)",
    0x03EE: "N-Tron(0x03EE)",
    0x03EF: "Nippon Pneumatics/Fludics System CO.,LTD.(0x03EF)",
    0x03F0: "DDK Ltd.(0x03F0)",
    0x03F1: "Seiko Epson Corporation(0x03F1)",
    0x03F2: "Halstrup-Walcher GmbH(0x03F2)",
    0x03F3: "ITT(0x03F3)",
    0x03F4: "Ground Fault Systems bv(0x03F4)",
    0x03F5: "Scolari Engineering S.p.A.(0x03F5)",
    0x03F6: "Vialis Traffic bv(0x03F6)",
    0x03F7: "Weidmueller Interface GmbH & Co. KG(0x03F7)",
    0x03F8: "Shanghai Sibotech Automation Co. Ltd(0x03F8)",
    0x03F9: "AEG Power Supply Systems GmbH(0x03F9)",
    0x03FA: "Komatsu Electronics Inc.(0x03FA)",
    0x03FB: "Souriau(0x03FB)",
    0x03FC: "Baumuller Chicago Corp.(0x03FC)",
    0x03FD: "J. Schmalz GmbH(0x03FD)",
    0x03FE: "SEN Corporation(0x03FE)",
    0x03FF: "Korenix Technology Co. Ltd(0x03FF)",
    0x0400: "Cooper Power Tools(0x0400)",
    0x0401: "INNOBIS(0x0401)",
    0x0402: "Shinho System(0x0402)",
    0x0403: "Xm Services Ltd.(0x0403)",
    0x0404: "KVC Co.Ltd.(0x0404)",
    0x0405: "Sanyu Seiki Co.Ltd.(0x0405)",
    0x0406: "TuxPLC(0x0406)",
    0x0407: "Northern Network Solutions(0x0407)",
    0x0408: "Converteam GmbH(0x0408)",
    0x0409: "Symbol Technologies(0x0409)",
    0x040A: "S-TEAM Lab(0x040A)",
    0x040B: "Maguire Products Inc.(0x040B)",
    0x040C: "AC&T(0x040C)",
    0x040D: "MITSUBISHI HEAVY INDUSTRIES: LTD. KOBE SHIPYARD & MACHINERY WORKS(0x040D)",
    0x040E: "Hurletron Inc.(0x040E)",
    0x040F: "Chunichi Denshi Co.Ltd(0x040F)",
    0x0410: "Cardinal Scale Mfg. Co.(0x0410)",
    0x0411: "BTR NETCOM via RIA Connect Inc.(0x0411)",
    0x0412: "Base2(0x0412)",
    0x0413: "ASRC Aerospace(0x0413)",
    0x0414: "Beijing Stone Automation(0x0414)",
    0x0415: "Changshu Switchgear Manufacture Ltd.(0x0415)",
    0x0416: "METRONIX Corp.(0x0416)",
    0x0417: "WIT(0x0417)",
    0x0418: "ORMEC Systems Corp.(0x0418)",
    0x0419: "ASATech (China) Inc.(0x0419)",
    0x041A: "Controlled Systems Limited(0x041A)",
    0x041B: "Mitsubishi Heavy Ind. Digital System Co.Ltd. (M.H.I.)(0x041B)",
    0x041C: "Electrogrip(0x041C)",
    0x041D: "TDS Automation(0x041D)",
    0x041E: "T&C Power Conversion Inc.(0x041E)",
    0x041F: "Robostar Co.Ltd(0x041F)",
    0x0420: "Scancon A/S(0x0420)",
    0x0421: "Haas Automation Inc.(0x0421)",
    0x0422: "Eshed Technology(0x0422)",
    0x0423: "Delta Electronic Inc.(0x0423)",
    0x0424: "Innovasic Semiconductor(0x0424)",
    0x0425: "SoftDEL Systems Limited(0x0425)",
    0x0426: "FiberFin Inc.(0x0426)",
    0x0427: "Nicollet Technologies Corp.(0x0427)",
    0x0428: "B.F. Systems(0x0428)",
    0x0429: "Empire Wire and Supply LLC(0x0429)",
    0x042A: "Reserved(0x042A)",
    0x042B: "Elmo Motion Control LTD(0x042B)",
    0x042C: "Reserved(0x042C)",
    0x042D: "Asahi Keiki Co.Ltd.(0x042D)",
    0x042E: "Joy Mining Machinery(0x042E)",
    0x042F: "MPM Engineering Ltd(0x042F)",
    0x0430: "Wolke Inks & Printers GmbH(0x0430)",
    0x0431: "Mitsubishi Electric Engineering Co.Ltd.(0x0431)",
    0x0432: "COMET AG(0x0432)",
    0x0433: "Real Time Objects & Systems: LLC(0x0433)",
    0x0434: "MISCO Refractometer(0x0434)",
    0x0435: "JT Engineering Inc.(0x0435)",
    0x0436: "Automated Packing Systems(0x0436)",
    0x0437: "Niobrara R&D Corp.(0x0437)",
    0x0438: "Garmin Ltd.(0x0438)",
    0x0439: "Japan Mobile Platform Co.Ltd(0x0439)",
    0x043A: "Advosol Inc.(0x043A)",
    0x043B: "ABB Global Services Limited(0x043B)",
    0x043C: "Sciemetric Instruments Inc.(0x043C)",
    0x043D: "Tata Elxsi Ltd.(0x043D)",
    0x043E: "TPC Mechatronics: Co.Ltd.(0x043E)",
    0x043F: "Cooper Bussmann(0x043F)",
    0x0440: "Trinite Automatisering B.V.(0x0440)",
    0x0441: "Peek Traffic B.V.(0x0441)",
    0x0442: "Acrison Inc(0x0442)",
    0x0443: "Applied Robotics Inc.(0x0443)",
    0x0444: "FireBus Systems Inc.(0x0444)",
    0x0445: "Beijing Sevenstar Huachuang Electronics(0x0445)",
    0x0446: "Magnetek(0x0446)",
    0x0447: "Microscan(0x0447)",
    0x0448: "Air Water Inc.(0x0448)",
    0x0449: "Sensopart Industriesensorik GmbH(0x0449)",
    0x044A: "Tiefenbach Control Systems GmbH(0x044A)",
    0x044B: "INOXPA S.A(0x044B)",
    0x044C: "Zurich University of Applied Sciences(0x044C)",
    0x044D: "Ethernet Direct(0x044D)",
    0x044E: "GSI-Micro-E Systems(0x044E)",
    0x044F: "S-Net Automation Co.Ltd.(0x044F)",
    0x0450: "Power Electronics S.L.(0x0450)",
    0x0451: "Renesas Technology Corp.(0x0451)",
    0x0452: "NSWCCD-SSES(0x0452)",
    0x0453: "Porter Engineering Ltd.(0x0453)",
    0x0454: "Meggitt Airdynamics Inc.(0x0454)",
    0x0455: "Inductive Automation(0x0455)",
    0x0456: "Neural ID(0x0456)",
    0x0457: "EEPod LLC(0x0457)",
    0x0458: "Hitachi Industrial Equipment Systems Co.Ltd.(0x0458)",
    0x0459: "Salem Automation(0x0459)",
    0x045A: "port GmbH(0x045A)",
    0x045B: "B & PLUS(0x045B)",
    0x045C: "Graco Inc.(0x045C)",
    0x045D: "Altera Corporation(0x045D)",
    0x045E: "Technology Brewing Corporation(0x045E)",
    0x0461: "CSE Servelec(0x0461)",
    0x0464: "Fluke Networks(0x0464)",
    0x0465: "Tetra Pak Packaging Solutions SPA(0x0465)",
    0x0466: "Racine Federated Inc.(0x0466)",
    0x0467: "Pureron Japan Co.Ltd.(0x0467)",
    0x046A: "Brother IndustriesLtd.(0x046A)",
    0x046C: "Leroy Automation(0x046C)",
    0x046E: "THK CO.: LTD.(0x046E)",
    0x0471: "TR-Electronic GmbH(0x0471)",
    0x0472: "ASCON S.p.A.(0x0472)",
    0x0473: "Toledo do Brasil Industria de Balancas Ltda.(0x0473)",
    0x0474: "Bucyrus DBT Europe GmbH(0x0474)",
    0x0475: "Emerson Process Management Valve Automation(0x0475)",
    0x0476: "Alstom Transport(0x0476)",
    0x0478: "Matrox Electronic Systems(0x0478)",
    0x0479: "Littelfuse(0x0479)",
    0x047A: "PLASMART Inc.(0x047A)",
    0x047B: "Miyachi Corporation(0x047B)",
    0x047E: "Promess Incorporated(0x047E)",
    0x047F: "COPA-DATA GmbH(0x047F)",
    0x0480: "Precision Engine Controls Corporation(0x0480)",
    0x0481: "Alga Automacao e controle LTDA(0x0481)",
    0x0482: "U.I. Lapp GmbH(0x0482)",
    0x0483: "ICES(0x0483)",
    0x0484: "Philips Lighting bv(0x0484)",
    0x0485: "Aseptomag AG(0x0485)",
    0x0486: "ARC Informatique(0x0486)",
    0x0487: "Hesmor GmbH(0x0487)",
    0x0488: "Kobe SteelLtd.(0x0488)",
    0x0489: "FLIR Systems(0x0489)",
    0x048A: "Simcon A/S(0x048A)",
    0x048B: "COPALP(0x048B)",
    0x048C: "Zypcom Inc.(0x048C)",
    0x048D: "Swagelok(0x048D)",
    0x048E: "Elspec(0x048E)",
    0x048F: "ITT Water & Wastewater AB(0x048F)",
    0x0490: "Kunbus GmbH Industrial Communication(0x0490)",
    0x0492: "Performance Controls Inc.(0x0492)",
    0x0493: "ACS Motion ControlLtd.(0x0493)",
    0x0495: "IStar Technology Limited(0x0495)",
    0x0496: "Alicat Scientific Inc.(0x0496)",
    0x0498: "ADFweb.com SRL(0x0498)",
    0x0499: "Tata Consultancy Services Limited(0x0499)",
    0x049A: "CXR Ltd.(0x049A)",
    0x049B: "Vishay Nobel AB(0x049B)",
    0x049D: "SolaHD(0x049D)",
    0x049E: "Endress+Hauser(0x049E)",
    0x049F: "Bartec GmbH(0x049F)",
    0x04A1: "AccuSentry Inc.(0x04A1)",
    0x04A2: "Exlar Corporation(0x04A2)",
    0x04A3: "ILS Technology(0x04A3)",
    0x04A4: "Control Concepts Inc.(0x04A4)",
    0x04A6: "Procon Engineering Limited(0x04A6)",
    0x04A7: "Hermary Opto Electronics Inc.(0x04A7)",
    0x04A8: "Q-Lambda(0x04A8)",
    0x04AA: "VAMP Ltd(0x04AA)",
    0x04AB: "FlexLink(0x04AB)",
    0x04AC: "Office FA.com Co.Ltd.(0x04AC)",
    0x04AD: "SPMC (Changzhou) Co. Ltd.(0x04AD)",
    0x04AE: "Anton Paar GmbH(0x04AE)",
    0x04AF: "Zhuzhou CSR Times Electric Co.Ltd.(0x04AF)",
    0x04B0: "DeStaCo(0x04B0)",
    0x04B1: "Synrad Inc(0x04B1)",
    0x04B2: "Bonfiglioli Vectron GmbH(0x04B2)",
    0x04B3: "Pivotal Systems(0x04B3)",
    0x04B4: "TKSCT(0x04B4)",
    0x04B5: "Randy Nuernberger(0x04B5)",
    0x04B6: "CENTRALP(0x04B6)",
    0x04B7: "Tengen Group(0x04B7)",
    0x04B8: "OES Inc.(0x04B8)",
    0x04B9: "Actel Corporation(0x04B9)",
    0x04BA: "Monaghan Engineering Inc.(0x04BA)",
    0x04BB: "wenglor sensoric gmbh(0x04BB)",
    0x04BC: "HSA Systems(0x04BC)",
    0x04BD: "MK Precision Co.Ltd.(0x04BD)",
    0x04BE: "Tappan Wire and Cable(0x04BE)",
    0x04BF: "Heinzmann GmbH & Co. KG(0x04BF)",
    0x04C0: "Process Automation International Ltd.(0x04C0)",
    0x04C1: "Secure Crossing(0x04C1)",
    0x04C2: "SMA Railway Technology GmbH(0x04C2)",
    0x04C3: "FMS Force Measuring Systems AG(0x04C3)",
    0x04C4: "ABT Endustri Enerji Sistemleri Sanayi Tic. Ltd. Sti.(0x04C4)",
    0x04C5: "MagneMotion Inc.(0x04C5)",
    0x04C6: "STS Co.Ltd.(0x04C6)",
    0x04C7: "MERAK SIC: SA(0x04C7)",
    0x04C8: "ABOUNDI Inc.(0x04C8)",
    0x04C9: "Rosemount Inc.(0x04C9)",
    0x04CA: "GEA FES Inc.(0x04CA)",
    0x04CB: "TMG Technologie und Engineering GmbH(0x04CB)",
    0x04CC: "embeX GmbH(0x04CC)",
    0x04CD: "GH Electrotermia: S.A.(0x04CD)",
    0x04CE: "Tolomatic(0x04CE)",
    0x04CF: "Dukane(0x04CF)",
    0x04D0: "Elco (Tian Jin) Electronics Co.Ltd.(0x04D0)",
    0x04D1: "Jacobs Automation(0x04D1)",
    0x04D2: "Noda Radio Frequency Technologies Co.Ltd.(0x04D2)",
    0x04D3: "MSC Tuttlingen GmbH(0x04D3)",
    0x04D4: "Hitachi Cable Manchester(0x04D4)",
    0x04D5: "ACOREL SAS(0x04D5)",
    0x04D6: "Global Engineering Solutions Co.Ltd.(0x04D6)",
    0x04D7: "ALTE Transportation: S.L.(0x04D7)",
    0x04D8: "Penko Engineering B.V.(0x04D8)",
}


DEVICE_TYPES = {
    0x0000: "Generic Device (deprecated)(0x0000)",
    0x0002: "AC Drive(0x0002)",
    0x0003: "Motor Overload(0x0003)",
    0x0004: "Limit Switch(0x0004)",
    0x0005: "Inductive Proximity Switch(0x0005)",
    0x0006: "Photoelectric Sensor(0x0006)",
    0x0007: "General Purpose Discrete I/O(0x0007)",
    0x0009: "Resolver(0x0009)",
    0x000C: "Communications Adapter(0x000C)",
    0x000E: "Programmable Logic Controller(0x000E)",
    0x0010: "Position Controller(0x0010)",
    0x0013: "DC Drive(0x0013)",
    0x0015: "Contactor(0x0015)",
    0x0016: "Motor Starter(0x0016)",
    0x0017: "Soft Start(0x0017)",
    0x0018: "Human-Machine Interface(0x0018)",
    0x001A: "Mass Flow Controller(0x001A)",
    0x001B: "Pneumatic Valve(0x001B)",
    0x001C: "Vacuum Pressure Gauge(0x001C)",
    0x001D: "Process Control Value(0x001D)",
    0x001E: "Residual Gas Analyzer(0x001E)",
    0x001F: "DC Power Generator(0x001F)",
    0x0020: "RF Power Generator(0x0020)",
    0x0021: "Turbomolecular Vacuum Pump(0x0021)",
    0x0022: "Encoder(0x0022)",
    0x0023: "Safety Discrete I/O Device(0x0023)",
    0x0024: "Fluid Flow Controller(0x0024)",
    0x0025: "CIP Motion Drive(0x0025)",
    0x0026: "CompoNet Repeater(0x0026)",
    0x0027: "Mass Flow Controller Enhanced(0x0027)",
    0x0028: "CIP Modbus Device(0x0028)",
    0x0029: "CIP Modbus Translator(0x0029)",
    0x002A: "Safety Analog I/O Device(0x002A)",
    0x002B: "Generic Device (keyable)(0x002B)",
    0x002C: "Managed Switch(0x002C)",
    0x003B: "ControlNet Physical Layer Component(0x003B)",
}


STATUS_CODES = {
    0x0000: "Success",
    0x0001: "Invalid Command",
    0x0002: "No Memory Resources",
    0x0003: "Incorrect Data",
    0x0064: "Invalid Session Handle",
    0x0065: "Invalid Length",
    0x0069: "Unsupported Protocol Revision",
    0x006a: "Encapsulated CIP service not allowed on this port"

}


CAPABILITY_FLAGS = [
    "UDP",  # Supports CIP Class 0 or 1 via
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "TCP",  # Supports CIP Encapsulation via TCP
    "",
    ""]


ENIP_INTERFACE_HANDLE = {
    0x00: "CIP (0x00000000)"
}


class CommandSpecificDataItemsField(PacketListField):
    def m2i(self, pkt, payload):
        return self.cls(pkt, payload)


def guess_cmd_type_class(pkt, payload):
    if isinstance(pkt, CommandSpecificData) or isinstance(pkt, CIPCommandSpecificData):
        try:
            type_id = struct.unpack("<H", payload[:2])[0]
        except Exception as err:
            return
        if type_id == 0x000c:
            return ListIdentityResponse(payload)
        elif type_id == 0x0100:
            return ListServiceResponse(payload)
        elif type_id == 0x0000:
            return NullAddressItem(payload)
        elif type_id == 0x00b2:
            return UnconnectedDataItem(payload)


class SocketAddress(Packet):
    fields_desc = [
        LEShortEnumField("SinFamily", 0x0000, ENIP_TYPE_IDS),
        LEShortField("SinPort", 0x0),
        IPField("SinAddress", "0.0.0.0"),
        XLongField("SinZero", 0)
        ]


bind_layers(SocketAddress, Padding)


class RegisterSession(Packet):
    fields_desc = [
        LEShortField("ENIPVersion", 0x0001),
        # TODO: Need to know what does these flags doing for.
        LEShortField("OptionFlags", 0x0000)
    ]


class ListServiceResponse(Packet):
    fields_desc = [
        LEShortEnumField("TypeID", 0x0004, ENIP_TYPE_IDS),
        LEShortField("Length", None),
        LEShortField("ENIPVersion", 0x0001),
        FlagsField("CapabilityFlags", 0, 16, CAPABILITY_FLAGS),
        # TODO: Need check is Name of service always end with '\x00\x00' or not.
        StrLenField("NameOfService", "", length_from=lambda p: p.Length - 4)
    ]


class ListIdentityResponse(Packet):
    fields_desc = [
        LEShortEnumField("TypeID", 0x0004, ENIP_TYPE_IDS),
        LEShortField("Length", None),
        LEShortField("ENIPVersion", 0x0001),
        PacketField("SocketAddress", SocketAddress(), SocketAddress),
        LEShortEnumField("VendorID", 0x0001, VENDOR_IDS),
        LEShortEnumField("DeviceType", 0x000c, DEVICE_TYPES),
        LEShortField("ProductCode", 0x0087),
        XShortField("Revision", 0x0),
        LEShortEnumField("Status", 0x0080, DEVICE_TYPES),
        LEIntField("SerialNumber", 0x0),
        FieldLenField("ProductNameLength", None, fmt="B", length_of="ProductName"),
        StrLenField("ProductName", "", length_from=lambda p: p.ProductNameLength),
        ByteField("State", 0x0)
        ]


class NullAddressItem(Packet):
    fields_desc = [
        LEShortEnumField("TypeID", 0x0000, ENIP_TYPE_IDS),
        LEShortField("Length", 0x00),
    ]


bind_layers(NullAddressItem, Padding)


class UnconnectedDataItem(Packet):
    fields_desc = [
        LEShortEnumField("TypeID", 0x00b2, ENIP_TYPE_IDS),
        LEShortField("Length", None),
    ]


bind_layers(UnconnectedDataItem, Padding)


class ENIPHeader(Packet):
    fields_desc = [
        LEShortEnumField("Command", 0x0004, ENIP_COMMANDS),
        LEShortField("Length", None),
        LEIntField("Session", 0x00000000),
        LEIntEnumField("Status", 0x00000000, STATUS_CODES),
        StrFixedLenField(
            "SenderContext", '0000000000000000'.decode('hex'), length=8),
        XIntField("Options", 0x00000000)
    ]

    def post_build(self, p, pay):
        if self.Length is None and pay:
            length = len(pay)
            p = p[:2] + struct.pack("<H", length) + p[4:]
        return p + pay

    def guess_payload_class(self, payload):
        if len(payload) == 4:
            return RegisterSession
        elif payload[:4] == '\x00\x00\x00\x00':
            return CIPCommandSpecificData
        else:
            return CommandSpecificData


class CommandSpecificData(Packet):
    fields_desc = [FieldLenField("ItemCount", None, fmt="<H", count_of="Items"),
                   CommandSpecificDataItemsField("Items", [], guess_cmd_type_class, count_from=lambda p:p.ItemCount)
                   ]


class CIPCommandSpecificData(Packet):
    fields_desc = [
        IntEnumField("InterfaceHandle", 0x00, ENIP_INTERFACE_HANDLE),
        LEShortField("Timeout", 0x0a),
        FieldLenField("ItemCount", None, fmt="<H", count_of="Items"),
        CommandSpecificDataItemsField("Items", [], guess_cmd_type_class, count_from=lambda p:p.ItemCount)
    ]

    def post_build(self, pkt, pay):
        if isinstance(self.Items[-1], UnconnectedDataItem):
            if self.Items[-1].Length is None and pay:
                length = len(pay)
                pkt = pkt[:-2] + struct.pack("<H", length)
        return pkt + pay

    def guess_payload_class(self, payload):
        if self.InterfaceHandle == 0x00:
            return CIPHeader


bind_layers(TCP, ENIPHeader, dport=44818)
bind_layers(TCP, ENIPHeader, sport=44818)
bind_layers(UDP, ENIPHeader, dport=44818)
bind_layers(UDP, ENIPHeader, sport=44818)
