/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    int timerId;
    int minimum = 0;
    int maximum = 100;
    int selection = 0;

    public ProgressBar(Composite parent, int style) {
        super(parent, ProgressBar.checkStyle(style));
    }

    static int checkStyle(int style) {
        return ProgressBar.checkBits(style |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    @Override
    void createHandle(int index) {
        boolean vertical;
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        this.handle = GTK.gtk_progress_bar_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        boolean bl = vertical = (this.style & 0x200) != 0;
        if (vertical) {
            GTK.gtk_orientable_set_orientation(this.handle, 1);
            GTK.gtk_progress_bar_set_inverted(this.handle, true);
        } else {
            GTK.gtk_orientable_set_orientation(this.handle, 0);
            GTK.gtk_progress_bar_set_inverted(this.handle, false);
        }
        if ((this.style & 2) != 0) {
            this.timerId = GTK.GTK4 ? OS.g_timeout_add(100, this.display.windowTimerProc, this.handle) : GDK.gdk_threads_add_timeout(100, this.display.windowTimerProc, this.handle);
        }
    }

    @Override
    long eventHandle() {
        return this.fixedHandle;
    }

    @Override
    long gtk_realize(long widget) {
        long result = super.gtk_realize(widget);
        if (result != 0L) {
            return result;
        }
        this.updateBar();
        return 0L;
    }

    @Override
    Point resizeCalculationsGTK3(long widget, int width, int height) {
        width = Math.max(2, width);
        return new Point(width, height);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
    }

    @Override
    void setParentBackground() {
    }

    public void setSelection(int value) {
        this.checkWidget();
        this.selection = Math.max(this.minimum, Math.min(this.maximum, value));
        this.updateBar();
    }

    @Override
    long timerProc(long widget) {
        if (this.isVisible()) {
            GTK.gtk_progress_bar_pulse(this.handle);
        }
        return 1L;
    }

    void updateBar() {
        if (!GTK.gtk_widget_get_realized(this.handle)) {
            return;
        }
        double fraction = this.minimum == this.maximum ? 1.0 : (double)(this.selection - this.minimum) / (double)(this.maximum - this.minimum);
        GTK.gtk_progress_bar_set_fraction(this.handle, fraction);
    }
}

