/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GtkTargetEntry;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Display;

class ClipboardProxy {
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    long clipboardOwner = GTK.GTK4 ? GTK4.gtk_window_new() : GTK3.gtk_window_new(0);
    Display display;
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Callback getFunc;
    Callback clearFunc;
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(Display display) {
        ClipboardProxy proxy = (ClipboardProxy)display.getData(ID);
        if (proxy != null) {
            return proxy;
        }
        proxy = new ClipboardProxy(display);
        display.setData(ID, proxy);
        display.disposeExec(() -> {
            ClipboardProxy clipbordProxy = (ClipboardProxy)display.getData(ID);
            if (clipbordProxy == null) {
                return;
            }
            display.setData(ID, null);
            clipbordProxy.dispose();
        });
        return proxy;
    }

    ClipboardProxy(Display display) {
        this.display = display;
        this.getFunc = new Callback(this, "getFunc", 4);
        this.clearFunc = new Callback(this, "clearFunc", 2);
    }

    long clearFunc(long clipboard, long user_data_or_owner) {
        if (clipboard == Clipboard.GTKCLIPBOARD) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (clipboard == Clipboard.GTKPRIMARYCLIPBOARD) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        return 1L;
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.activeClipboard != null && !GTK.GTK4) {
            GTK3.gtk_clipboard_store(Clipboard.GTKCLIPBOARD);
        }
        if (this.activePrimaryClipboard != null && !GTK.GTK4) {
            GTK3.gtk_clipboard_store(Clipboard.GTKPRIMARYCLIPBOARD);
        }
        this.display = null;
        if (this.getFunc != null) {
            this.getFunc.dispose();
        }
        this.getFunc = null;
        if (this.clearFunc != null) {
            this.clearFunc.dispose();
        }
        this.clearFunc = null;
        this.clipboardData = null;
        this.clipboardDataTypes = null;
        this.primaryClipboardData = null;
        this.primaryClipboardDataTypes = null;
        if (this.clipboardOwner != 0L) {
            if (GTK.GTK4) {
                GTK4.gtk_window_destroy(this.clipboardOwner);
            } else {
                GTK3.gtk_widget_destroy(this.clipboardOwner);
            }
        }
        this.clipboardOwner = 0L;
    }

    long getFunc(long clipboard, long selection_data, long info, long user_data_or_owner) {
        if (selection_data == 0L) {
            return 0L;
        }
        long target = GTK3.gtk_selection_data_get_target(selection_data);
        TransferData tdata = new TransferData();
        tdata.type = target;
        Transfer[] types = clipboard == Clipboard.GTKCLIPBOARD ? this.clipboardDataTypes : this.primaryClipboardDataTypes;
        int index = -1;
        int i = 0;
        while (i < types.length) {
            if (types[i].isSupportedType(tdata)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return 0L;
        }
        Object[] data = clipboard == Clipboard.GTKCLIPBOARD ? this.clipboardData : this.primaryClipboardData;
        types[index].javaToNative(data[index], tdata);
        if (tdata.format < 8 || tdata.format % 8 != 0) {
            return 0L;
        }
        GTK3.gtk_selection_data_set(selection_data, tdata.type, tdata.format, tdata.pValue, tdata.length);
        OS.g_free(tdata.pValue);
        return 1L;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean setData(Clipboard owner, Object[] data, Transfer[] dataTypes, int clipboards) {
        if (GTK.GTK4) {
            return this.setData_gtk4(owner, data, dataTypes, clipboards);
        }
        entries = new GtkTargetEntry[]{};
        pTargetsList = 0L;
        try {
            i = 0;
            while (i < dataTypes.length) {
                transfer = dataTypes[i];
                typeIds = transfer.getTypeIds();
                typeNames = transfer.getTypeNames();
                j = 0;
                while (j < typeIds.length) {
                    entry = new GtkTargetEntry();
                    entry.info = typeIds[j];
                    buffer = Converter.wcsToMbcs(typeNames[j], true);
                    pName = OS.g_malloc(buffer.length);
                    C.memmove(pName, buffer, (long)buffer.length);
                    entry.target = pName;
                    tmp = new GtkTargetEntry[entries.length + 1];
                    System.arraycopy(entries, 0, tmp, 0, entries.length);
                    tmp[entries.length] = entry;
                    entries = tmp;
                    ++j;
                }
                ++i;
            }
            pTargetsList = OS.g_malloc(GtkTargetEntry.sizeof * entries.length);
            offset = 0;
            i = 0;
            while (i < entries.length) {
                GTK3.memmove(pTargetsList + (long)offset, entries[i], (long)GtkTargetEntry.sizeof);
                offset += GtkTargetEntry.sizeof;
                ++i;
            }
            if ((clipboards & 1) != 0) {
                this.clipboardData = data;
                this.clipboardDataTypes = dataTypes;
                getFuncProc = this.getFunc.getAddress();
                if (!GTK3.gtk_clipboard_set_with_owner(Clipboard.GTKCLIPBOARD, pTargetsList, entries.length, getFuncProc, clearFuncProc = this.clearFunc.getAddress(), this.clipboardOwner)) {
                }
                GTK3.gtk_clipboard_set_can_store(Clipboard.GTKCLIPBOARD, 0L, 0);
                this.activeClipboard = owner;
            }
            if ((clipboards & 2) != 0) {
                this.primaryClipboardData = data;
                this.primaryClipboardDataTypes = dataTypes;
                getFuncProc = this.getFunc.getAddress();
                if (!GTK3.gtk_clipboard_set_with_owner(Clipboard.GTKPRIMARYCLIPBOARD, pTargetsList, entries.length, getFuncProc, clearFuncProc = this.clearFunc.getAddress(), this.clipboardOwner)) {
                }
                GTK3.gtk_clipboard_set_can_store(Clipboard.GTKPRIMARYCLIPBOARD, 0L, 0);
                this.activePrimaryClipboard = owner;
                return (boolean)this.activePrimaryClipboard;
            }
        }
        finally {
            i = 0;
            ** while (i < entries.length)
        }
lbl-1000:
        // 1 sources

        {
            entry = entries[i];
            if (entry.target != 0L) {
                OS.g_free(entry.target);
            }
            ++i;
            continue;
        }
lbl61:
        // 1 sources

        if (pTargetsList == 0L) return false;
        OS.g_free(pTargetsList);
        return false;
    }

    private boolean setData_gtk4(Clipboard owner, Object[] data, Transfer[] dataTypes, int clipboards) {
        boolean result = false;
        long[] providers = new long[]{};
        int i = 0;
        while (i < dataTypes.length) {
            Transfer transfer = dataTypes[i];
            String[] typeNames = transfer.getTypeNames();
            long provider = this.setProviderFromType(typeNames[0], data[i]);
            if (provider != 0L) {
                long[] tmp = new long[providers.length + 1];
                System.arraycopy(providers, 0, tmp, 0, providers.length);
                tmp[providers.length] = provider;
                providers = tmp;
            }
            ++i;
        }
        if (providers.length == 0) {
            return false;
        }
        long union = GTK4.gdk_content_provider_new_union(providers, providers.length);
        if ((clipboards & 1) != 0) {
            this.clipboardData = data;
            this.clipboardDataTypes = dataTypes;
            result = GTK4.gdk_clipboard_set_content(Clipboard.GTKCLIPBOARD, union);
            this.activeClipboard = owner;
        }
        return result;
    }

    private long setProviderFromType(String string, Object data) {
        long provider = 0L;
        if (data == null) {
            SWT.error(4);
        } else {
            long value;
            if (string.equals("text/plain") || string.equals("text/rtf")) {
                value = OS.g_malloc(OS.GValue_sizeof());
                C.memset(value, 0, OS.GValue_sizeof());
                OS.g_value_init(value, OS.G_TYPE_STRING());
                OS.g_value_set_string(value, Converter.javaStringToCString((String)data));
                provider = GTK4.gdk_content_provider_new_for_value(value);
            }
            if (string.equals("PIXBUF")) {
                if (!(data instanceof ImageData)) {
                    DND.error(2003);
                }
                ImageData imgData = (ImageData)data;
                Image image = new Image((Device)Display.getCurrent(), imgData);
                long pixbuf = ImageList.createPixbuf(image);
                if (pixbuf != 0L) {
                    provider = GTK4.gdk_content_provider_new_typed(GDK.GDK_TYPE_PIXBUF(), pixbuf);
                }
                image.dispose();
            }
            if (string.equals("text/html")) {
                value = OS.g_malloc(OS.GValue_sizeof());
                C.memset(value, 0, OS.GValue_sizeof());
                OS.g_value_init(value, OS.G_TYPE_STRING());
                OS.g_value_set_string(value, Converter.javaStringToCString((String)data));
                provider = GTK4.gdk_content_provider_new_for_value(value);
            }
        }
        return provider;
    }
}

