/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.gtk.OS;

public abstract class ByteArrayTransfer
extends Transfer {
    @Override
    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] types = this.getTypeIds();
        int i = 0;
        while (i < types.length) {
            if (transferData.type == (long)types[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void javaToNative(Object object, TransferData transferData) {
        byte[] buffer;
        transferData.result = 0;
        if (!this.checkByteArray(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((buffer = (byte[])object).length == 0) {
            return;
        }
        long pValue = OS.g_malloc(buffer.length);
        if (pValue == 0L) {
            return;
        }
        C.memmove(pValue, buffer, (long)buffer.length);
        transferData.length = buffer.length;
        transferData.format = 8;
        transferData.pValue = pValue;
        transferData.result = 1;
    }

    boolean checkByteArray(Object object) {
        return object instanceof byte[] && ((byte[])object).length > 0;
    }
}

