/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.Config;
import net.azib.ipscan.config.Version;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;

public class GoogleAnalytics {
    public void report(String screen) {
        this.report("page_view", screen);
    }

    public void report(String type, String content) {
        try {
            Config config = Config.getConfig();
            if (!config.allowReports) {
                return;
            }
            URL url = new URL("https://www.google-analytics.com/mp/collect?measurement_id=G-2F94QVQFGE&api_secret=KzBPI2oaSAWo1v5X5TIG8Q");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (ipscan/" + Version.getVersion() + " " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "; Java " + System.getProperty("java.version") + ")");
            conn.setDoOutput(true);
            StringBuilder payload = new StringBuilder();
            payload.append("{");
            payload.append("\"client_id\":\"").append(config.getGaClientId()).append("\",");
            payload.append("\"non_personalized_ads\":true,");
            payload.append("\"events\":[{");
            payload.append("\"name\":\"").append(type).append("\",");
            payload.append("\"params\":{");
            payload.append("\"app_version\":\"").append(Version.getVersion()).append("\",");
            payload.append("\"app_name\":\"ipscan\",");
            payload.append("\"language\":\"").append(config.getLocale()).append("\",");
            payload.append("\"screen_resolution\":\"").append(config.forGUI().mainWindowSize[0]).append("x").append(config.forGUI().mainWindowSize[1]).append("\",");
            payload.append("\"os_info\":\"").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append(" ").append(System.getProperty("os.arch")).append("\",");
            payload.append("\"java_info\":\"").append("Java ").append(System.getProperty("java.version")).append("\"");
            content = content.replace("\"", "\\\"");
            if ("exception".equals(type)) {
                payload.append(",\"exception_description\":\"").append(content).append("\"");
            } else {
                payload.append(",\"page_title\":\"").append(content).append("\"");
                payload.append(",\"page_location\":\"").append("https://angryip.org/app/").append(URLEncoder.encode(content, StandardCharsets.UTF_8)).append("\"");
            }
            payload.append("}}]");
            payload.append("}");
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.toString().getBytes(StandardCharsets.UTF_8));
            }
            try (InputStream is = conn.getInputStream();){
                is.readAllBytes();
            }
            conn.disconnect();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Failed to report", e);
        }
    }

    public void report(Throwable e) {
        this.report("exception", GoogleAnalytics.extractFirstStackFrame(e));
    }

    public void report(String message, Throwable e) {
        this.report("exception", message + "\n" + GoogleAnalytics.extractFirstStackFrame(e));
    }

    static String extractFirstStackFrame(Throwable e) {
        StackTraceElement stackTraceElement;
        if (e == null) {
            return "";
        }
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement element = null;
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n && !(element = (stackTraceElement = stackTraceElementArray[i])).getClassName().startsWith("net.azib.ipscan"); ++i) {
        }
        int code = e instanceof SWTError ? ((SWTError)e).code : (e instanceof SWTException ? ((SWTException)e).code : -1);
        return String.valueOf(e) + (String)(code >= 0 ? " (" + code + ")" : "") + (String)(element == null ? "" : "\n" + element.getClassName() + "." + element.getMethodName() + ":" + element.getLineNumber()) + (String)(e.getCause() != null ? ";\n" + GoogleAnalytics.extractFirstStackFrame(e.getCause()) : "");
    }

    public void asyncReport(String screen) {
        new Thread(() -> this.report(screen)).start();
    }

    public static void main(String[] args) {
        new GoogleAnalytics().report("hello");
    }
}

