/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LayoutHelper {
    static Map<String, Image> iconCache = new HashMap<String, Image>();

    public static FormLayout formLayout(int marginWidth, int marginHeight, int spacing) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = marginWidth;
        formLayout.marginHeight = marginHeight;
        formLayout.spacing = spacing;
        return formLayout;
    }

    public static FormData formData(int width, int height, FormAttachment left, FormAttachment right, FormAttachment top, FormAttachment bottom) {
        FormData formData = new FormData(width, height);
        formData.left = left;
        formData.right = right;
        formData.top = top;
        formData.bottom = bottom;
        return formData;
    }

    public static FormData formData(FormAttachment left, FormAttachment right, FormAttachment top, FormAttachment bottom) {
        return LayoutHelper.formData(-1, -1, left, right, top, bottom);
    }

    public static Font iconFont(Shell shell) {
        FontData fontData = shell.getFont().getFontData()[0];
        fontData.setHeight(fontData.getHeight() * 4 / 3);
        Font font = new Font(shell.getDisplay(), fontData);
        shell.addDisposeListener(e -> font.dispose());
        return font;
    }

    public static Image icon(String baseName) {
        return iconCache.computeIfAbsent(baseName, k -> {
            Display display = Display.getCurrent();
            return new Image((Device)display, zoom -> {
                String suffix = zoom == 200 ? "@2x.png" : ".png";
                ImageData imageData = new ImageData(LayoutHelper.class.getResourceAsStream("/images/" + baseName + suffix));
                if (zoom != 100 & zoom != 200) {
                    imageData = DPIUtil.autoScaleImageData((Device)display, imageData, 100);
                }
                return imageData;
            });
        });
    }
}

