/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.actions;

import net.azib.ipscan.config.CommandLineProcessor;
import net.azib.ipscan.config.GUIConfig;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.core.state.StateTransitionListener;
import net.azib.ipscan.gui.PreferencesDialog;
import net.azib.ipscan.gui.ResultTable;
import net.azib.ipscan.gui.SelectFetchersDialog;
import net.azib.ipscan.gui.StatisticsDialog;
import net.azib.ipscan.gui.StatusBar;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

public class ToolsActions {

    public static final class SelectInvert
    implements Listener {
        private final ResultTable resultTable;

        public SelectInvert(ResultTable resultTable) {
            this.resultTable = resultTable;
        }

        @Override
        public void handleEvent(Event event) {
            int count = this.resultTable.getItemCount();
            this.resultTable.setRedraw(false);
            for (int i = 0; i < count; ++i) {
                if (this.resultTable.isSelected(i)) {
                    this.resultTable.deselect(i);
                    continue;
                }
                this.resultTable.select(i);
            }
            this.resultTable.setRedraw(true);
            this.resultTable.redraw();
            event.widget = this.resultTable;
            this.resultTable.notifyListeners(13, event);
            this.resultTable.forceFocus();
        }
    }

    public static class SelectAll
    implements Listener {
        private final ResultTable resultTable;

        public SelectAll(ResultTable resultTable) {
            this.resultTable = resultTable;
        }

        @Override
        public void handleEvent(Event event) {
            if (event.type == 1 && event.keyCode == 97 && event.stateMask == SWT.MOD1) {
                this.resultTable.selectAll();
                event.widget = this.resultTable;
                this.resultTable.notifyListeners(13, event);
                event.doit = false;
            }
        }
    }

    public static final class SelectWithoutPorts
    extends SelectDesired {
        public SelectWithoutPorts(ResultTable resultTable) {
            super(resultTable);
        }

        @Override
        boolean isDesired(ScanningResult.ResultType type) {
            return type == ScanningResult.ResultType.ALIVE;
        }
    }

    public static final class SelectWithPorts
    extends SelectDesired {
        public SelectWithPorts(ResultTable resultTable) {
            super(resultTable);
        }

        @Override
        boolean isDesired(ScanningResult.ResultType type) {
            return type == ScanningResult.ResultType.WITH_PORTS;
        }
    }

    public static final class SelectDead
    extends SelectDesired {
        public SelectDead(ResultTable resultTable) {
            super(resultTable);
        }

        @Override
        boolean isDesired(ScanningResult.ResultType type) {
            return type == ScanningResult.ResultType.DEAD;
        }
    }

    public static final class SelectAlive
    extends SelectDesired {
        public SelectAlive(ResultTable resultTable) {
            super(resultTable);
        }

        @Override
        boolean isDesired(ScanningResult.ResultType type) {
            return type.ordinal() >= ScanningResult.ResultType.ALIVE.ordinal();
        }
    }

    static abstract class SelectDesired
    implements Listener {
        private final ResultTable resultTable;
        private final ScanningResultList results;

        public SelectDesired(ResultTable resultTable) {
            this.resultTable = resultTable;
            this.results = resultTable.getScanningResults();
        }

        @Override
        public void handleEvent(Event event) {
            int count = this.resultTable.getItemCount();
            this.resultTable.deselectAll();
            for (int i = 0; i < count; ++i) {
                if (!this.isDesired(this.results.getResult(i).getType())) continue;
                this.resultTable.select(i);
            }
            event.widget = this.resultTable;
            this.resultTable.notifyListeners(13, event);
            this.resultTable.forceFocus();
        }

        abstract boolean isDesired(ScanningResult.ResultType var1);
    }

    public static final class TableSelection
    implements Listener {
        private final StatusBar statusBar;
        private final StateMachine stateMachine;

        public TableSelection(StatusBar statusBar, StateMachine stateMachine) {
            this.statusBar = statusBar;
            this.stateMachine = stateMachine;
        }

        @Override
        public void handleEvent(Event event) {
            if (this.stateMachine.inState(ScanningState.IDLE)) {
                Table resultTable = (Table)event.widget;
                int selectionCount = resultTable.getSelectionCount();
                if (selectionCount > 1) {
                    this.statusBar.setStatusText(selectionCount + Labels.getLabel("text.hostsSelected"));
                } else {
                    this.statusBar.setStatusText(null);
                }
            }
        }
    }

    public static final class ScanStatistics
    implements StateTransitionListener,
    Listener {
        private final StatisticsDialog statisticsDialog;
        private final GUIConfig guiConfig;

        public ScanStatistics(GUIConfig guiConfig, StatisticsDialog statisticsDialog, StateMachine stateMachine, CommandLineProcessor commandProcessor) {
            this.guiConfig = guiConfig;
            this.statisticsDialog = statisticsDialog;
            if (!commandProcessor.shouldAutoQuit()) {
                stateMachine.addTransitionListener(this);
            }
        }

        @Override
        public void handleEvent(Event event) {
            this.statisticsDialog.open();
        }

        @Override
        public void transitionTo(ScanningState state, StateMachine.Transition transition) {
            if (transition == StateMachine.Transition.COMPLETE && this.guiConfig.showScanStats) {
                this.handleEvent(null);
            }
        }
    }

    public static final class ChooseFetchers
    implements Listener {
        private final SelectFetchersDialog selectFetchersDialog;

        public ChooseFetchers(SelectFetchersDialog selectFetchersDialog) {
            this.selectFetchersDialog = selectFetchersDialog;
        }

        @Override
        public void handleEvent(Event event) {
            this.selectFetchersDialog.open();
        }
    }

    public static final class Preferences
    implements Listener {
        private final PreferencesDialog preferencesDialog;
        private final ResultTable resultTable;
        private final StatusBar statusBar;

        public Preferences(PreferencesDialog preferencesDialog, ResultTable resultTable, StatusBar statusBar) {
            this.preferencesDialog = preferencesDialog;
            this.resultTable = resultTable;
            this.statusBar = statusBar;
        }

        @Override
        public void handleEvent(Event event) {
            this.preferencesDialog.open();
            this.resultTable.updateResults();
            this.resultTable.updateColumnNames();
            this.statusBar.updateConfigText();
        }
    }
}

