/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.azib.ipscan.Main;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.core.UserErrorException;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.exporters.ExportProcessor;
import net.azib.ipscan.exporters.Exporter;
import net.azib.ipscan.exporters.ExporterRegistry;
import net.azib.ipscan.exporters.TXTExporter;
import net.azib.ipscan.gui.ResultTable;
import net.azib.ipscan.gui.StatusBar;
import net.azib.ipscan.gui.feeders.FeederGUIRegistry;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ScanMenuActions {

    public static final class NewWindow
    implements Listener {
        @Override
        public void handleEvent(Event event) {
            new Thread("main"){

                @Override
                public void run() {
                    Main.main(new String[0]);
                }
            }.start();
        }
    }

    public static final class Quit
    implements Listener {
        private final Shell shell;

        public Quit(Shell shell) {
            this.shell = shell;
        }

        @Override
        public void handleEvent(Event event) {
            this.shell.close();
        }
    }

    public static final class SaveSelection
    extends SaveResults {
        public SaveSelection(ExporterRegistry exporterRegistry, ResultTable resultTable, StatusBar statusBar, StateMachine stateMachine) {
            super(exporterRegistry, resultTable, statusBar, stateMachine, true);
        }
    }

    public static final class SaveAll
    extends SaveResults {
        public SaveAll(ExporterRegistry exporterRegistry, ResultTable resultTable, StatusBar statusBar, StateMachine stateMachine) {
            super(exporterRegistry, resultTable, statusBar, stateMachine, false);
        }
    }

    static abstract class SaveResults
    implements Listener {
        private final ExporterRegistry exporterRegistry;
        private final ResultTable resultTable;
        private final StatusBar statusBar;
        private final boolean isSelection;
        private final StateMachine stateMachine;

        SaveResults(ExporterRegistry exporterRegistry, ResultTable resultTable, StatusBar statusBar, StateMachine stateMachine, boolean isSelection) {
            this.exporterRegistry = exporterRegistry;
            this.resultTable = resultTable;
            this.statusBar = statusBar;
            this.stateMachine = stateMachine;
            this.isSelection = isSelection;
        }

        @Override
        public void handleEvent(Event event) {
            if (this.resultTable.getItemCount() <= 0) {
                throw new UserErrorException("commands.noResults");
            }
            if (!this.stateMachine.inState(ScanningState.IDLE)) {
                MessageBox box = new MessageBox(this.resultTable.getShell(), 268435656);
                box.setText("Angry IP Scanner");
                box.setMessage(Labels.getLabel("exception.ExporterException.scanningInProgress"));
                if (box.open() != 64) {
                    return;
                }
            }
            FileDialog fileDialog = new FileDialog(this.resultTable.getShell(), 8192);
            ArrayList<String> extensions = new ArrayList<String>();
            ArrayList<String> descriptions = new ArrayList<String>();
            StringBuffer labelBuffer = new StringBuffer(Labels.getLabel(this.isSelection ? "title.exportSelection" : "title.exportAll"));
            this.addFileExtensions(extensions, descriptions, labelBuffer);
            fileDialog.setText(labelBuffer.toString());
            fileDialog.setFilterExtensions(extensions.toArray(new String[extensions.size()]));
            fileDialog.setFilterNames(descriptions.toArray(new String[descriptions.size()]));
            String fileName = fileDialog.open();
            if (fileName == null) {
                return;
            }
            Exporter exporter = this.exporterRegistry.createExporter(fileName);
            this.statusBar.setStatusText(Labels.getLabel("state.exporting"));
            ExportProcessor exportProcessor = new ExportProcessor(exporter, new File(fileName), false);
            ExportProcessor.ScanningResultFilter filter = null;
            if (this.isSelection) {
                filter = (index, result) -> this.resultTable.isSelected(index);
            }
            exportProcessor.process(this.resultTable.getScanningResults(), filter);
            this.statusBar.setStatusText(null);
        }

        private void addFileExtensions(List<String> extensions, List<String> descriptions, StringBuffer sb) {
            sb.append(" (");
            for (Exporter exporter : this.exporterRegistry) {
                extensions.add("*." + exporter.getFilenameExtension());
                sb.append(exporter.getFilenameExtension()).append(", ");
                descriptions.add(Labels.getLabel(exporter.getId()));
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append(")");
        }
    }

    public static class LoadFromFile
    implements Listener {
        private final TXTExporter txtExporter;
        private final ExporterRegistry exporterRegistry;
        private final FeederGUIRegistry feederRegistry;
        private final ScanningResultList scanningResults;
        private final ResultTable resultTable;
        private final StateMachine stateMachine;

        public LoadFromFile(TXTExporter txtExporter, ExporterRegistry exporterRegistry, FeederGUIRegistry feederRegistry, ScanningResultList scanningResults, ResultTable resultTable, StateMachine stateMachine) {
            this.txtExporter = txtExporter;
            this.exporterRegistry = exporterRegistry;
            this.feederRegistry = feederRegistry;
            this.scanningResults = scanningResults;
            this.resultTable = resultTable;
            this.stateMachine = stateMachine;
        }

        @Override
        public void handleEvent(Event event) {
            FileDialog fileDialog = new FileDialog(this.resultTable.getShell(), 4096);
            ArrayList<String> extensions2 = new ArrayList<String>();
            ArrayList<String> descriptions = new ArrayList<String>();
            StringBuffer labelBuffer = new StringBuffer(Labels.getLabel("title.load"));
            this.addFileExtensions(extensions2, descriptions, labelBuffer);
            ArrayList<String> extensions = new ArrayList<String>();
            extensions.add((String)extensions2.get(0));
            fileDialog.setText(labelBuffer.toString());
            fileDialog.setFilterExtensions(extensions.toArray(new String[extensions.size()]));
            fileDialog.setFilterNames(descriptions.toArray(new String[descriptions.size()]));
            String fileName = fileDialog.open();
            if (fileName == null) {
                return;
            }
            this.loadResultsFrom(fileName);
        }

        private void loadResultsFrom(String fileName) {
            try {
                String[] feederIPs;
                String lastLoadedIP;
                this.feederRegistry.select("feeder.range");
                this.scanningResults.initNewScan(this.feederRegistry.current().createFeeder());
                List<ScanningResult> results = this.txtExporter.importResults(fileName, this.feederRegistry.current());
                this.resultTable.clearAll();
                for (ScanningResult result : results) {
                    this.resultTable.addOrUpdateResultRow(result);
                }
                if (!results.isEmpty() && this.resumePreviousScan(lastLoadedIP = results.get(results.size() - 1).getAddress().getHostAddress(), (feederIPs = this.feederRegistry.current().serialize())[1])) {
                    this.stateMachine.continueScanning();
                }
            }
            catch (Exception e) {
                throw new UserErrorException("fileLoad.failed", e);
            }
        }

        private boolean resumePreviousScan(String lastIP, String endIP) {
            if (lastIP.equals(endIP)) {
                return false;
            }
            MessageBox box = new MessageBox(this.resultTable.getShell(), 268435652);
            box.setText(Labels.getLabel("menu.scan.load").replace("&", ""));
            box.setMessage(Labels.getLabel("text.scan.resume").replace("%LASTIP", lastIP).replace("%ENDIP", endIP));
            return box.open() == 64;
        }

        private void addFileExtensions(List<String> extensions, List<String> descriptions, StringBuffer sb) {
            sb.append(" (");
            for (Exporter exporter : this.exporterRegistry) {
                extensions.add("*." + exporter.getFilenameExtension());
                sb.append(exporter.getFilenameExtension()).append(", ");
                descriptions.add(Labels.getLabel(exporter.getId()));
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append(")");
        }
    }
}

