/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import net.azib.ipscan.config.Labels;
import net.azib.ipscan.gui.AboutDialog;
import net.azib.ipscan.gui.PreferencesDialog;
import net.azib.ipscan.gui.SelectFetchersDialog;
import net.azib.ipscan.gui.actions.HelpMenuActions;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MacApplicationMenu {
    private AboutDialog aboutDialog;
    private PreferencesDialog preferencesDialog;
    private SelectFetchersDialog selectFetchersDialog;
    private HelpMenuActions.CheckVersion checkVersion;

    public MacApplicationMenu(Display display, AboutDialog aboutDialog, PreferencesDialog preferencesDialog, SelectFetchersDialog selectFetchersDialog, HelpMenuActions.CheckVersion checkVersion) {
        this.aboutDialog = aboutDialog;
        this.preferencesDialog = preferencesDialog;
        this.selectFetchersDialog = selectFetchersDialog;
        this.checkVersion = checkVersion;
        display.syncExec(() -> this.initApplicationMenu(display));
    }

    private void initApplicationMenu(Display display) {
        MenuItem about;
        Menu systemMenu = display.getSystemMenu();
        if (systemMenu == null) {
            return;
        }
        MenuItem prefs = MacApplicationMenu.getItem(systemMenu, -2);
        if (prefs != null) {
            prefs.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.preferencesDialog.open()));
        }
        if ((about = MacApplicationMenu.getItem(systemMenu, -1)) != null) {
            about.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.aboutDialog.open()));
        }
        MenuItem fetchers = new MenuItem(systemMenu, 0, systemMenu.indexOf(prefs) + 1);
        fetchers.setText(Labels.getLabel("menu.tools.fetchers"));
        fetchers.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.selectFetchersDialog.open()));
        MenuItem checkVersion = new MenuItem(systemMenu, 0, systemMenu.indexOf(about) + 1);
        checkVersion.setText(Labels.getLabel("menu.help.checkVersion"));
        checkVersion.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.checkVersion.check(true)));
    }

    private static MenuItem getItem(Menu menu, int id) {
        MenuItem[] items;
        for (MenuItem item : items = menu.getItems()) {
            if (item.getID() != id) continue;
            return item;
        }
        return null;
    }
}

