/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.feeders;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.feeders.AbstractFeeder;
import net.azib.ipscan.feeders.FeederException;
import net.azib.ipscan.util.InetAddressUtils;

public class FileFeeder
extends AbstractFeeder {
    private static final Pattern PORT_REGEX = Pattern.compile("\\d{1,5}\\b");
    static final Logger LOG = LoggerFactory.getLogger();
    private Map<String, ScanningSubject> foundHosts;
    private Iterator<ScanningSubject> foundIPAddressesIterator;
    private Stream<NetworkInterface> networkInterfaces;
    private int currentIndex;

    @Override
    public String getId() {
        return "feeder.file";
    }

    public FileFeeder() {
        try {
            this.networkInterfaces = NetworkInterface.networkInterfaces();
        }
        catch (SocketException e) {
            LOG.log(Level.WARNING, "", e);
        }
    }

    public FileFeeder(String fileName) {
        this();
        try {
            this.findHosts(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            throw new FeederException("file.notExists");
        }
    }

    public FileFeeder(Reader reader) {
        this();
        this.findHosts(reader);
    }

    private String readLines(BufferedReader fileReader, int num) throws IOException {
        String fileLine;
        int index = 1;
        StringBuilder sb = new StringBuilder();
        while ((fileLine = fileReader.readLine()) != null) {
            sb.append(fileLine).append("\n");
            if (++index <= num) continue;
            break;
        }
        return sb.toString();
    }

    private void findHosts(Reader reader) {
        this.currentIndex = 0;
        this.foundHosts = new LinkedHashMap<String, ScanningSubject>();
        long startTime = System.currentTimeMillis();
        try (BufferedReader fileReader = new BufferedReader(reader);){
            String fileLine;
            while (!(fileLine = this.readLines(fileReader, 20)).isEmpty()) {
                long lineTime = System.currentTimeMillis();
                Matcher matcher = InetAddressUtils.HOSTNAME_REGEX.matcher(fileLine);
                while (matcher.find()) {
                    try {
                        Matcher portMatcher;
                        String host = matcher.group();
                        if (host.equals("angryip.org")) continue;
                        ScanningSubject subject = this.foundHosts.get(host);
                        if (subject == null) {
                            InetAddress address = InetAddress.getByName(host);
                            subject = new ScanningSubject(address, InetAddressUtils.getInterface(address, this.networkInterfaces));
                        }
                        if (!matcher.hitEnd() && fileLine.charAt(matcher.end()) == ':' && (portMatcher = PORT_REGEX.matcher(fileLine.substring(matcher.end() + 1))).lookingAt()) {
                            subject.addRequestedPort(Integer.valueOf(portMatcher.group()));
                        }
                        this.foundHosts.put(host, subject);
                    }
                    catch (UnknownHostException e) {
                        LOG.log(Level.WARNING, e.toString());
                    }
                }
            }
            LOG.fine("File processed in " + (System.currentTimeMillis() - startTime) + " ms");
            if (this.foundHosts.isEmpty()) {
                throw new FeederException("file.nothingFound");
            }
        }
        catch (IOException e) {
            throw new FeederException("file.errorWhileReading");
        }
        this.foundIPAddressesIterator = this.foundHosts.values().iterator();
    }

    @Override
    public int percentageComplete() {
        return Math.round((float)this.currentIndex * 100.0f / (float)this.foundHosts.size());
    }

    @Override
    public boolean hasNext() {
        return this.foundIPAddressesIterator.hasNext();
    }

    @Override
    public ScanningSubject next() {
        ++this.currentIndex;
        return this.foundIPAddressesIterator.next();
    }

    @Override
    public String getInfo() {
        return Integer.toString(this.foundHosts.size());
    }
}

