/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core.net;

import java.net.InetAddress;

public class PingResult {
    InetAddress address;
    private int ttl;
    private long totalTime;
    private long longestTime;
    private int packetCount;
    private int replyCount;
    private boolean timeoutAdaptationAllowed;

    public PingResult(InetAddress address, int packetCount) {
        this.address = address;
        this.packetCount = packetCount;
    }

    public void addReply(long time) {
        ++this.replyCount;
        if (time > this.longestTime) {
            this.longestTime = time;
        }
        this.totalTime += time;
        this.timeoutAdaptationAllowed = this.replyCount > 2;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void setTTL(int ttl) {
        this.ttl = ttl;
    }

    public int getAverageTime() {
        return (int)(this.totalTime / (long)this.replyCount);
    }

    public int getLongestTime() {
        return (int)this.longestTime;
    }

    public int getPacketLoss() {
        return this.packetCount - this.replyCount;
    }

    public int getPacketLossPercent() {
        if (this.replyCount > 0) {
            return this.getPacketLoss() * 100 / this.packetCount;
        }
        return 100;
    }

    public int getPacketCount() {
        return this.packetCount;
    }

    public int getReplyCount() {
        return this.replyCount;
    }

    public boolean isAlive() {
        return this.replyCount > 0;
    }

    public void enableTimeoutAdaptation() {
        if (this.isAlive()) {
            this.timeoutAdaptationAllowed = true;
        }
    }

    public boolean isTimeoutAdaptationAllowed() {
        return this.timeoutAdaptationAllowed;
    }

    public PingResult merge(PingResult result) {
        this.packetCount += result.packetCount;
        this.replyCount += result.replyCount;
        return this;
    }
}

