/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.Scanner;
import net.azib.ipscan.core.ScanningProgressCallback;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningResultCallback;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.core.state.StateTransitionListener;
import net.azib.ipscan.feeders.Feeder;
import net.azib.ipscan.util.InetAddressUtils;

public class ScannerDispatcherThread
extends Thread
implements ThreadFactory,
StateTransitionListener {
    private ScannerConfig config;
    private Scanner scanner;
    private StateMachine stateMachine;
    private ScanningResultList scanningResultList;
    private Feeder feeder;
    private AtomicInteger numActiveThreads = new AtomicInteger();
    ThreadGroup threadGroup;
    ExecutorService threadPool;
    private ScanningProgressCallback progressCallback;
    private ScanningResultCallback resultsCallback;

    public ScannerDispatcherThread(Feeder feeder, Scanner scanner, StateMachine stateMachine, ScanningProgressCallback progressCallback, ScanningResultList scanningResults, ScannerConfig scannerConfig, ScanningResultCallback resultsCallback) {
        this.setName(this.getClass().getSimpleName());
        this.config = scannerConfig;
        this.stateMachine = stateMachine;
        this.progressCallback = progressCallback;
        this.resultsCallback = resultsCallback;
        this.threadGroup = new ThreadGroup(this.getName());
        this.threadPool = Executors.newFixedThreadPool(this.config.maxThreads, this);
        this.setDaemon(true);
        this.feeder = feeder;
        this.scanner = scanner;
        this.scanningResultList = scanningResults;
        try {
            this.scanningResultList.initNewScan(feeder);
            scanner.init(feeder);
        }
        catch (RuntimeException e) {
            stateMachine.reset();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.stateMachine.addTransitionListener(this);
            long lastNotifyTime = 0L;
            try {
                ScanningSubject subject = null;
                while (this.feeder.hasNext() && this.stateMachine.inState(ScanningState.SCANNING)) {
                    long now;
                    Thread.sleep(this.config.threadDelay);
                    if (this.numActiveThreads.intValue() < this.config.maxThreads) {
                        subject = this.feeder.next();
                        if (this.config.skipBroadcastAddresses && InetAddressUtils.isLikelyBroadcast(subject.getAddress(), subject.getIfAddress())) continue;
                        ScanningResult result = this.scanningResultList.createResult(subject.getAddress());
                        this.resultsCallback.prepareForResults(result);
                        AddressScannerTask scanningTask = new AddressScannerTask(subject, result);
                        this.threadPool.execute(scanningTask);
                    }
                    if ((now = System.currentTimeMillis()) - lastNotifyTime < 150L || subject == null) continue;
                    lastNotifyTime = now;
                    this.progressCallback.updateProgress(subject.getAddress(), this.numActiveThreads.intValue(), this.feeder.percentageComplete());
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.stateMachine.stop();
            this.threadPool.shutdown();
            try {
                while (!this.threadPool.awaitTermination(150L, TimeUnit.MILLISECONDS)) {
                    this.progressCallback.updateProgress(null, this.numActiveThreads.intValue(), 100);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.scanner.cleanup();
            this.stateMachine.complete();
        }
        finally {
            this.stateMachine.removeTransitionListener(this);
        }
    }

    @Override
    public void transitionTo(ScanningState state, StateMachine.Transition transition) {
        if (state == ScanningState.KILLING) {
            this.threadGroup.interrupt();
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        return new Thread(this.threadGroup, r){
            {
                this.setDaemon(true);
            }

            @Override
            public void interrupt() {
                ScannerDispatcherThread.this.scanner.interrupt(this);
                super.interrupt();
            }
        };
    }

    class AddressScannerTask
    implements Runnable {
        private ScanningSubject subject;
        private ScanningResult result;

        AddressScannerTask(ScanningSubject subject, ScanningResult result) {
            this.subject = subject;
            this.result = result;
            ScannerDispatcherThread.this.numActiveThreads.incrementAndGet();
        }

        @Override
        public void run() {
            Thread.currentThread().setName(this.getClass().getSimpleName() + ": " + String.valueOf(this.subject));
            try {
                ScannerDispatcherThread.this.scanner.scan(this.subject, this.result);
                ScannerDispatcherThread.this.resultsCallback.consumeResults(this.result);
            }
            finally {
                ScannerDispatcherThread.this.numActiveThreads.decrementAndGet();
            }
        }
    }
}

