/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.core.Plugin;

public class PluginLoader {
    private static final Logger LOG = LoggerFactory.getLogger();

    public List<Class<? extends Plugin>> getClasses() {
        ArrayList<Class<? extends Plugin>> container = new ArrayList<Class<? extends Plugin>>();
        this.loadPluginsSpecifiedInSystemProperties(container);
        this.loadPluginJars(container, this.getOwnFile());
        this.loadPluginJars(container, new File(System.getProperty("user.home"), ".ipscan/."));
        return container;
    }

    void loadPluginsSpecifiedInSystemProperties(List<Class<? extends Plugin>> container) {
        String plugins = System.getProperty("ipscan.plugins");
        if (plugins != null) {
            this.loadPluginClasses(container, this.getClass().getClassLoader(), plugins);
        }
    }

    private void loadPluginClasses(List<Class<? extends Plugin>> container, ClassLoader classLoader, String csvNames) {
        String[] classes;
        for (String className : classes = csvNames.split("\\s*,\\s*")) {
            try {
                Class<?> clazz = Class.forName(className, true, classLoader);
                if (Plugin.class.isAssignableFrom(clazz)) {
                    container.add(clazz);
                    continue;
                }
                LOG.warning("Plugin class " + clazz.getName() + " is not assignable to " + Plugin.class.getName());
            }
            catch (Throwable e) {
                LOG.warning("Unable to load plugin: " + className);
            }
        }
    }

    void loadPluginJars(List<Class<? extends Plugin>> container, File ownFile) {
        File parentDir = ownFile.getParentFile();
        if (parentDir == null || !parentDir.exists()) {
            return;
        }
        File[] jars = parentDir.listFiles((dir, name) -> name.endsWith(".jar") && !name.equals(ownFile.getName()));
        if (jars == null) {
            return;
        }
        for (File jar : jars) {
            try {
                JarFile jarFile = new JarFile(jar);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) continue;
                jarFile.close();
                String classNames = manifest.getMainAttributes().getValue("IPScan-Plugin");
                if (classNames == null) {
                    classNames = manifest.getMainAttributes().getValue("IPScan-Plugins");
                }
                if (classNames == null) continue;
                PluginClassLoader loader = new PluginClassLoader(jar.toURL());
                Labels.getInstance().load(loader);
                this.loadPluginClasses(container, loader, classNames);
            }
            catch (Exception e) {
                LOG.warning("Failed to load plugin jar " + String.valueOf(jar) + ": " + String.valueOf(e));
            }
        }
    }

    private File getOwnFile() {
        return this.getClassLocation(this.getClass());
    }

    File getClassLocation(Class clazz) {
        return this.getResourceLocation(clazz.getResource(clazz.getSimpleName() + ".class"));
    }

    File getResourceLocation(URL resource) {
        String ownPath = resource.getFile();
        if (ownPath.startsWith("file:")) {
            ownPath = ownPath.substring("file:".length());
        }
        if (ownPath.indexOf(33) >= 0) {
            ownPath = ownPath.substring(0, ownPath.indexOf(33));
        }
        return new File(ownPath);
    }

    static class PluginClassLoader
    extends URLClassLoader {
        PluginClassLoader(URL url) {
            super(new URL[]{url}, PluginLoader.class.getClassLoader());
        }

        @Override
        public URL getResource(String name) {
            return Optional.ofNullable(this.findResource(name)).orElseGet(() -> this.getParent().getResource(name));
        }
    }
}

