/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.prefs.Preferences;

public class NamedListConfig
implements Iterable<String> {
    protected String preferenceName;
    protected Preferences preferences;
    protected Map<String, Object> namedList = new LinkedHashMap<String, Object>();

    NamedListConfig(Preferences preferences, String preferenceName) {
        this.preferenceName = preferenceName;
        this.preferences = preferences;
        this.load();
    }

    public void load() {
        if (this.preferences == null) {
            return;
        }
        String[] namedListPrefs = this.preferences.get(this.preferenceName, "").split("###");
        for (int i = 0; i < namedListPrefs.length; i += 2) {
            if (namedListPrefs[i].length() <= 0) continue;
            this.namedList.put(namedListPrefs[i], this.serializeValue(namedListPrefs[i + 1]));
        }
    }

    Object serializeValue(String value) {
        return value;
    }

    public void store() {
        StringBuilder sb = new StringBuilder(32);
        for (Map.Entry<String, Object> e : this.namedList.entrySet()) {
            sb.append(e.getKey()).append("###").append(e.getValue()).append("###");
        }
        if (sb.length() > 3) {
            sb.delete(sb.length() - 3, sb.length());
        }
        this.preferences.put(this.preferenceName, sb.toString());
    }

    public void add(String key, Object value) {
        this.namedList.put(key, value);
    }

    public String get(String key) {
        Object value = this.namedList.get(key);
        return value != null ? value.toString() : null;
    }

    public String remove(String key) {
        return this.namedList.remove(key).toString();
    }

    @Override
    public Iterator<String> iterator() {
        return this.namedList.keySet().iterator();
    }

    public int size() {
        return this.namedList.size();
    }

    public void update(String[] keys) {
        LinkedHashMap<String, Object> newList = new LinkedHashMap<String, Object>();
        for (String key : keys) {
            newList.put(key, this.namedList.get(key));
        }
        this.namedList = newList;
    }
}

