/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import java.net.InetAddress;
import java.util.prefs.Preferences;
import net.azib.ipscan.core.ScanningResult;

public class CommentsConfig {
    private Preferences preferences;

    public CommentsConfig(Preferences preferences) {
        this.preferences = preferences.node("comments");
    }

    public String getComment(InetAddress address, String mac) {
        String comment = null;
        if (mac != null) {
            comment = this.preferences.get(mac, null);
        }
        if (comment == null) {
            comment = this.preferences.get(address.getHostAddress(), null);
        }
        return comment;
    }

    public String getComment(ScanningResult result) {
        return this.getComment(result.getAddress(), result.getMac());
    }

    public void setComment(ScanningResult result, String comment) {
        String key = result.getAddress().getHostAddress();
        if (result.getMac() != null) {
            this.preferences.remove(key);
            String mac = result.getMac();
            if (mac != null) {
                key = mac;
            }
        }
        if (comment == null || comment.isEmpty()) {
            this.preferences.remove(key);
        } else {
            this.preferences.put(key, comment);
        }
    }
}

