---
title: "Import/Export Configuration"
draft: false
description: "Configure Infection Monkey by importing/exporting a configuration file."
pre: "<i class='fas fa-upload'></i> "
---

## Export configuration

You can export the current configuration by clicking the **Export** button at
the bottom of the configuration page. This will save the configuration to a
file, which you can later import. The configuration file can contain plaintext
or encrypted data. If your configuration contains any sensitive data, such as
usernames and passwords, you can choose a password during export that will be
used to encrypt the file.

{{% notice warning %}}
Make sure that you don't lose your password. The data in encrypted
configuration files cannot be recovered if password is lost.
{{% /notice %}}

![Export
Configuration](/images/island/configuration-page/export-configuration.png
"Export Configuration")


## Import configuration

You can import a configuration file by clicking the **Import** button at the
bottom of the configuration page. If the configuration file is encrypted you
will be prompted to enter the password.

{{% notice note %}}
Configuration files that were exported from older versions of Infection Monkey
cannot necessarily be imported into newer versions.
{{% /notice %}}


{{% notice note %}}
If a configuration file enables plugins (e.g. exploiters or payloads) that are
not installed, the Monkey Island will refuse to import it. You can install
plugins on the [plugin installation page](/features/plugins/).
{{% /notice %}}

### Importing a plaintext configuration file
![Configuration without
password](/images/island/configuration-page/import-configuration.png
"Configuration without password")

### Importing a password-protected (encrypted) configuration file
![Password-encrypted
Configuration](/images/island/configuration-page/import-configuration-password.png
"Password-encrypted Configuration")
