---
title: "Log4Shell"
draft: false
description: "Reference material for the Log4Shell exploiter"
pre: "<i class='fas fa-mug-hot'></i> "
---
{{< table_of_contents >}}

## Supported operating systems

| Operating system | Attack from                 | Target                      |
| :--------------- | :-------------------------- | :-------------------------- |
| Linux            | {{< os-icon-supported >}}   | {{< os-icon-supported >}}   |
| Windows          | {{< os-icon-supported >}}   | {{< os-icon-supported >}}   |

## Exploited CVEs

- {{% cve id=CVE-2021-44228 %}}

## Configuration

<!--
This documentation was autogenerated by passing the plugin's config-schema.json
through https://github.com/adobe/jsonschema2md. It was then modified by hand to
remove extraneous information.
-->

| Property                                                            | Type      | Required | Nullable       |
| :------------------------------------------------------------------ | :-------- | :------- | :------------- |
| [target\_ports](#target_ports)                                      | `array`   | Optional | cannot be null |     |
| [try\_all\_discovered\_http\_ports](#try_all_discovered_http_ports) | `boolean` | Optional | cannot be null |
| [exploit\_download\_timeout](#exploit_download_timeout)             | `number`  | Optional | cannot be null |           |
| [agent\_binary\_download\_timeout](#agent_binary_download_timeout)  | `number`  | Optional | cannot be null |

### target\_ports

A list of HTTP ports that the Log4Shell exploiter will try to exploit.

`target_ports`

* is optional

* Type: `integer[]`

* cannot be null

#### target\_ports Default Value

The default value is:

```json
[
  8000,
  8080,
  8983,
  9600
]
```

### try\_all\_discovered\_http\_ports

Attempt to exploit Log4Shell on all HTTP ports discovered from network scanning.

`try_all_discovered_http_ports`

* is optional

* Type: `boolean`

* cannot be null

### exploit\_download\_timeout

The maximum time (in seconds) to wait for the victim to download the exploit.

`exploit_download_timeout`

* is optional

* Type: `number`

* cannot be null

#### exploit\_download\_timeout Constraints

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### exploit\_download\_timeout Default Value

The default value is:

```json
5
```

### agent\_binary\_download\_timeout

The maximum time (in seconds) to wait for a successfully exploited server to download the agent binary.

`agent_binary_download_timeout`

* is optional

* Type: `number`

* cannot be null

#### agent\_binary\_download\_timeout Constraints

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### agent\_binary\_download\_timeout Default Value

The default value is:

```json
15
```

## Services exploited

Infection Monkey will attempt to exploit the Log4Shell vulnerability in the
following services:

- Apache Solr
- Apache Tomcat
- Logstash
