/*
File: bmp.c
Project: imagejs
Author: jklmnn
Homepage: http://jklmnn.de/imagejs/
License: GNU GENERAL PUBLIC LICENSE Version 3
*/


#include "bmp.h"

char *bmp_js(char *content, int size){
	const char _bmp_header[BMP_JS_HEADER] = {0x42, 0x4d, 0x3d, 0x30, 0x3b, 0x2f, 0x2f, 0x00, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x13, 0x0b, 0x00, 0x00, 0x13, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x47, 0x52, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x0a};
	char *buffer = (char*)malloc(BMP_JS_HEADER + size);
	memcpy(buffer, _bmp_header, BMP_JS_HEADER);
	memcpy(&buffer[BMP_JS_HEADER], content, size);
	return buffer;
}

char *bmp_js_l(char *content, int size){
	unsigned int width = size/3 + 3;
	unsigned int height = 1;
	const char _bmp_header1[18] = {0x42, 0x4d, 0x2f, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00};
	char sizew[4], sizeh[4];
	const char _bmp_header2[BMP_JS_HEADER_L - 32] = {0x01, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x13, 0x0b, 0x00, 0x00, 0x13, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x47, 0x52, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x2f, 0x3d, 0x30, 0x3b, 0x0a};
	const char _bmp_footer[6] = {0x2f, 0x2f, 0x00, 0x00, 0x00, 0x00};
	char *buffer = (char*)malloc(BMP_JS_HEADER_L + size);
	for(int i = 0; i < 4; i++){
		sizew[i] = (width >> i*8) &0xff;
		sizeh[i] = (height >> i*8) &0xff;
	}
	memcpy(buffer, _bmp_header1, 18);
	memcpy(&buffer[18], sizew, 4);
	memcpy(&buffer[22], sizeh, 4);
	memcpy(&buffer[26], _bmp_header2, BMP_JS_HEADER_L - 26);
	memcpy(&buffer[BMP_JS_HEADER_L-6], content, size);
	memcpy(&buffer[BMP_JS_HEADER_L-6+size], _bmp_footer, 6);
	return buffer;
}

char *bmp_js_i(char *content, int csize, char *image, int isize){
	const char _bmp_header[7] = {0x42, 0x4d, 0x3d, 0x30, 0x3b, 0x2f, 0x2a};
	const char _bmp_header_end[BMP_JS_HEADER_I] = {0x2a, 0x2f, 0x3b};
	char *buffer = (char*)malloc(csize + isize + BMP_JS_HEADER_I);
	memcpy(buffer, _bmp_header, 7);
	memcpy(&buffer[7], &image[7], isize - 7);
	memcpy(&buffer[isize], _bmp_header_end, BMP_JS_HEADER_I);
	memcpy(&buffer[isize + BMP_JS_HEADER_I], content, csize);
        for (int i = 7; i < isize - 7; i++){
                if (buffer[i] == '*' && buffer[i + 1] == '/'){
                        buffer[i + 2] = '/';
                        buffer[i + 3] = '*';
                }
        }
	return buffer;
}

char *bmp_filename(char *fn, int size){
	const char _bmp_ending[BMP_ENDING] = {0x2e, 0x62, 0x6d, 0x70, 0x00};
	char *newfile = (char*)malloc(size + BMP_ENDING);
	memcpy(newfile, fn, size);
	memcpy(&newfile[size], _bmp_ending, BMP_ENDING);
	return newfile;
}
