﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AutoSecTools.Components.Collections
{
    public static class ByteExtension
    {
        public static int IndexOf(this byte[] Value, int StartIndex, byte[] Bytes)
        {
            bool match;

            for (int x = StartIndex; x < Value.Length; x++)
            {
                match = true;

                for (int y = 0; y < Bytes.Length; y++)
                {
                    var i = x + y;
                    if (i == Value.Length)
                        return -1;
                    else if (Value[i] != Bytes[y])
                    {
                        match = false;

                        break;
                    }                    
                }

                if (match)
                    return x;
            }

            return -1;
        }

        public static int IndexOf(this byte[] Value, byte[] Bytes)
        {
            return IndexOf(Value, 0, Bytes);
        }

        public static string ToHex(this IEnumerable<byte> Bytes)
        {
            return Bytes
                .Select(x => Convert.ToString(x, 16).PadLeft(2, '0'))
                .Aggregate((x, y) => x + y);
        }

        public static string GetASCIIString(this byte[] Bytes)
        {
            return ASCIIEncoding.ASCII.GetString(Bytes);
        }

        public static string GetString(this byte[] Bytes)
        {
            var sb = new StringBuilder();
            for (int i = 0; i < Bytes.Length; i++)
                sb.Append((char)Bytes[i]);

            return sb.ToString();
        }
    }
}
